/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mnt.FundFlowItemMapRuleCollection;
import com.kingdee.eas.fm.mnt.FundFlowItemMapRuleFactory;
import com.kingdee.eas.fm.mnt.FundFlowItemMapRuleInfo;
import com.kingdee.eas.fm.mnt.MNTException;
import com.kingdee.eas.fm.mnt.app.AbstractFundFlowItemMapRuleControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FundFlowItemMapRuleControllerBean
extends AbstractFundFlowItemMapRuleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mnt.app.FundFlowItemMapRuleControllerBean");
    private static final String resPath = "com.kingdee.eas.fm.mnt.MNTAutoGenerateResource";
    private static final String resKey = "584_FundFlowItemMapRuleControllerBean";

    private FundFlowItemMapRuleCollection getFundFlowItemMapRuleColl(Context ctx, Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(this.getSelectors());
        FundFlowItemMapRuleCollection coll = FundFlowItemMapRuleFactory.getLocalInstance(ctx).getFundFlowItemMapRuleCollection(evi);
        return coll;
    }

    @Override
    protected Map _batchEnable(Context ctx, List idList) throws BOSException, EASBizException {
        String errorDetail = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashSet idSet = new HashSet(idList);
        FundFlowItemMapRuleCollection coll = this.getFundFlowItemMapRuleColl(ctx, idSet);
        CoreBaseCollection newColl = new CoreBaseCollection();
        FundFlowItemMapRuleInfo info = null;
        int validCount = 0;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            try {
                if (info.isIsEnable()) {
                    throw new MNTException(MNTException.FUNDFLOWMAPRULE_REPEATE_ENABLE);
                }
                ++validCount;
                info.setIsEnable(true);
                newColl.add((CoreBaseInfo)info);
                continue;
            }
            catch (Exception ex) {
                errorDetail = errorDetail + this.getErrorMsg(ctx, info.getNumber(), ex) + "\n";
            }
        }
        this.updateBatchData(ctx, newColl);
        map.put("validCount", new Integer(validCount));
        map.put("errorDetail", errorDetail);
        return map;
    }

    private String getErrorMsg(Context ctx, String number, Exception ex) {
        return ResourceBase.getString((String)resPath, (String)resKey, (Locale)ctx.getLocale()) + number + "\uff1a" + ex.getMessage();
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add("isEnable");
        sel.add("id");
        sel.add("number");
        return sel;
    }

    @Override
    protected Map _batchDisable(Context ctx, List idList) throws BOSException, EASBizException {
        String errorDetail = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashSet idSet = new HashSet(idList);
        FundFlowItemMapRuleCollection coll = this.getFundFlowItemMapRuleColl(ctx, idSet);
        FundFlowItemMapRuleInfo info = null;
        CoreBaseCollection newColl = new CoreBaseCollection();
        int validCount = 0;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            try {
                if (!info.isIsEnable()) {
                    throw new MNTException(MNTException.FUNDFLOWMAPRULE_REPEATE_DISABLE);
                }
                ++validCount;
                info.setIsEnable(false);
                newColl.add((CoreBaseInfo)info);
                continue;
            }
            catch (Exception ex) {
                errorDetail = errorDetail + this.getErrorMsg(ctx, info.getNumber(), ex) + "\n";
            }
        }
        this.updateBatchData(ctx, newColl);
        map.put("validCount", new Integer(validCount));
        map.put("errorDetail", errorDetail);
        return map;
    }

    @Override
    protected Map _batchRemove(Context ctx, List idList) throws BOSException, EASBizException {
        String errorDetail = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashSet idSet = new HashSet(idList);
        FundFlowItemMapRuleCollection coll = this.getFundFlowItemMapRuleColl(ctx, idSet);
        ObjectUuidPK[] pkArray = new ObjectUuidPK[coll.size()];
        FundFlowItemMapRuleInfo info = null;
        int validCount = 0;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            try {
                if (info.isIsEnable()) {
                    throw new MNTException(MNTException.FUNDFLOWMAPRULE_CANNOTDEL_ENABLE);
                }
                pkArray[validCount++] = new ObjectUuidPK(info.getId().toString());
                continue;
            }
            catch (Exception ex) {
                errorDetail = errorDetail + this.getErrorMsg(ctx, info.getNumber(), ex) + "\n";
            }
        }
        this.deleteBatchData(ctx, (IObjectPK[])pkArray);
        map.put("validCount", new Integer(validCount));
        map.put("errorDetail", errorDetail);
        return map;
    }
}

