/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.FMParamUtil;
import com.kingdee.eas.fm.common.util.JournalBalanceUtil;
import com.kingdee.eas.fm.mnt.MNTException;
import com.kingdee.eas.fm.mnt.app.AbstractRptBlockFundFlowGGFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.bireport.app.BireportBaseFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptBlockFundFlowGGFacadeControllerBean
extends AbstractRptBlockFundFlowGGFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.RptBlockFundFlowGGFacadeControllerBean");

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        SchemaSource ss = new SchemaSource();
        Timestamp dtFrom = new Timestamp(((Date)params.getObjectElement("jdFrom.value")).getTime());
        Timestamp dtTo = new Timestamp(((Date)params.getObjectElement("jdTo.value")).getTime());
        dtTo.setHours(23);
        dtTo.setMinutes(59);
        dtTo.setSeconds(59);
        String amountUnit = String.valueOf(((AmountUnitEnum)params.getObjectElement("jtAmountUnit.value")).getValue());
        Set bankIdSet = (Set)params.getObject("bankIdSet");
        Set companyIdSet = (Set)params.getObject("companyIdSet");
        boolean forCompany = (Boolean)params.getObjectElement("jrbCompany.value");
        boolean forBank = (Boolean)params.getObjectElement("jrbBank.value");
        Set rateCurrencyIdSet = (Set)params.getObject("RateCurrencySet");
        boolean isRateCurrency = rateCurrencyIdSet != null && rateCurrencyIdSet.size() > 0;
        String loc = RptBlockFundFlowGGFacadeControllerBean.getLoc((Context)ctx);
        String configFile = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer mdx = new StringBuffer();
        Object rsCurrency = null;
        sql.setLength(0);
        sql.append(" select distinct A.FID, A.FNumber, A.FName_" + loc + " FName from t_bd_currency A");
        ss.setDataItem("Currency", sql.toString(), null);
        String temptable = "";
        if (isRateCurrency) {
            temptable = this.buildFactTempTable(ctx);
            HashSet<String> currencyIdSet = new HashSet<String>();
            StringBuffer currencySql = new StringBuffer();
            SqlParams sp = new SqlParams();
            currencySql.append("select distinct FCurrencyID  from T_CAS_JournalSummary A where 1=1 ");
            if (bankIdSet != null && bankIdSet.size() > 0) {
                currencySql.append("\n and B.FBank in(''");
                Iterator iter = bankIdSet.iterator();
                while (iter.hasNext()) {
                    currencySql.append(",?");
                    sp.addString((String)iter.next());
                }
                currencySql.append(')');
            }
            JournalBalanceUtil.appendFilter((String)"A.FCompanyID", (Set)companyIdSet, (StringBuffer)currencySql, (SqlParams)sp, (String)"and");
            currencySql.append("\n and A.FCreateDate>=? and A.FCreateDate<=?");
            sp.addTimestamp(dtFrom).addTimestamp(dtTo);
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)currencySql.toString(), (Object[])sp.getParams());
                while (rs.next()) {
                    currencyIdSet.add(rs.getString("FCurrencyID"));
                }
            }
            catch (SQLException rs) {
                // empty catch block
            }
            Iterator it = currencyIdSet.iterator();
            String locCurrencyId = (String)rateCurrencyIdSet.iterator().next();
            CurrencyInfo locCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(locCurrencyId));
            CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            String currencyStr = "";
            while (it.hasNext()) {
                String currencyid = (String)it.next();
                BigDecimal rate = null;
                if (currencyid.equals(locCurrencyId)) {
                    rate = Constants.ONE;
                } else {
                    CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyid));
                    ExchangeRateInfo rateInfo = FMHelper.getExRateInfo((Context)ctx, (CurrencyInfo)currency, (CurrencyInfo)locCurrency, (CompanyOrgUnitInfo)company, (Date)dtTo);
                    if (EmptyUtil.isEmpty((CoreBaseInfo)rateInfo)) {
                        currencyStr = currencyStr + "," + currency.getName();
                    } else {
                        rate = ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)rateInfo.getConvertMode()) ? Constants.ONE.divide(rateInfo.getConvertRate(), 20, 4) : rateInfo.getConvertRate();
                    }
                }
                String insertCurrencySql = "insert into " + temptable + " values('" + currencyid + "', " + rate + ")";
                DbUtil.execute((Context)ctx, (String)insertCurrencySql);
            }
            if (currencyStr.length() > 0) {
                throw new MNTException(MNTException.EXCEPTIONEXHANGERATE, new Object[]{currencyStr.substring(1), locCurrency.getName()});
            }
        }
        Object rsFact = null;
        StringBuffer factSql = new StringBuffer();
        StringBuffer factGroup = new StringBuffer();
        SqlParams sp = new SqlParams();
        if (isRateCurrency) {
            factSql.append(" select A.FCurrencyId, ").append(" sum(A.FDebitAmount/").append(amountUnit).append(")*F.FRate FIAmount,").append(" sum(A.FCreditAmount/").append(amountUnit).append(")*F.FRate FOAmount,").append(" sum((A.FDebitAmount-A.FCreditAmount)/").append(amountUnit).append(")*F.FRate FSumAmount");
        } else {
            factSql.append(" select A.FCurrencyId, ").append(" sum(A.FDebitAmount/").append(amountUnit).append(")*isNull(F.FConvertRate,1) FIAmount,").append(" sum(A.FCreditAmount/").append(amountUnit).append(")*isNull(F.FConvertRate,1) FOAmount,").append(" sum((A.FDebitAmount-A.FCreditAmount)/").append(amountUnit).append(")*isNull(F.FConvertRate,1) FSumAmount");
        }
        factGroup.append("\n group by A.FCurrencyID");
        if (isRateCurrency) {
            factGroup.append(", F.FRate");
        } else {
            factGroup.append(", F.FConvertRate");
        }
        if (forCompany) {
            factSql.append(", A.FCompanyID");
            factGroup.append(", A.FCompanyID");
        } else if (forBank) {
            factSql.append(", B.FBank FBankID");
            factGroup.append(", B.FBank");
        }
        if (isRateCurrency) {
            factSql.append("\n from T_CAS_JournalSummary A").append("\n left join " + temptable + " F on F.FRateCurrencyID=A.FCurrencyId ").append("\n inner join T_BD_AccountBanks B on B.FID=A.FAccountBankID").append("\n inner join T_Org_Company C on C.FID=A.FCompanyID").append("\n where 1=1 ");
        } else {
            String exchangeRate = "(\n select * from T_BD_ExchangeRate where fexchangeauxid not in\n (select fexchangeauxid from (\n select count(1) c, fexchangeauxid from T_BD_ExchangeRate group by fexchangeauxid\n ) A_INNER where c>1\n )\n union all\n select A.* from T_BD_ExchangeRate A inner join\n (\n select max(FAvailTime) FAvailTime, fexchangeauxid from T_BD_ExchangeRate\n where fexchangeauxid in \n (select fexchangeauxid from (\n select count(1) c, fexchangeauxid from T_BD_ExchangeRate group by fexchangeauxid\n ) A_INNER where c>1\n ) group by fexchangeauxid\n ) B on A.fexchangeauxid=B.fexchangeauxid and A.FAvailTime=B.FAvailTime\n)";
            factSql.append("\n from T_CAS_JournalSummary A").append("\n inner join T_BD_AccountBanks B on B.FID=A.FAccountBankID").append("\n inner join T_Org_Company C on C.FID=A.FCompanyID").append("\n inner join T_BD_ExchangeTable D on D.FID=C.FBaseExgTableID").append("\n left join T_BD_ExchangeAux E on E.FExchangeTableID=D.FID and E.FSourceCurrencyID=A.FCurrencyID and E.FTargetCurrencyID=C.FBaseCurrencyID").append("\n left join " + exchangeRate + " F on F.FExchangeAuxID=E.FID ").append("\n where 1=1 ");
        }
        if (bankIdSet != null && bankIdSet.size() > 0) {
            factSql.append("\n and B.FBank in(''");
            Iterator iter = bankIdSet.iterator();
            while (iter.hasNext()) {
                factSql.append(",?");
                sp.addString((String)iter.next());
            }
            factSql.append(')');
        }
        JournalBalanceUtil.appendFilter((String)"A.FCompanyID", (Set)companyIdSet, (StringBuffer)factSql, (SqlParams)sp, (String)"and");
        factSql.append("\n and A.FCreateDate>=? and A.FCreateDate<=?");
        sp.addTimestamp(dtFrom).addTimestamp(dtTo);
        factSql.append(factGroup);
        ss.setDataItem("Fact", factSql.toString(), sp);
        String paramValue = FMParamUtil.getParamValue((Context)ctx, (String)"MNT001");
        mdx.append(" with member [Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Currency].members)' ");
        if (forCompany) {
            configFile = "RptBlockFundFlowGG_company.xml";
            Object rsCompany = null;
            SqlParams spCompany = new SqlParams();
            sql.setLength(0);
            sql.append(" select A.FID, A.FNumber, A.FName_" + loc + " FName, A.FParentID from t_org_company  A ").append(" where 1=1 ");
            JournalBalanceUtil.appendFilter((String)"A.FID", (Set)companyIdSet, (StringBuffer)sql, (SqlParams)spCompany, (String)"and");
            ss.setDataItem("Company", sql.toString(), spCompany);
            mdx.append(" member [Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Company].levels(0).members)'").append(" select ").append("\n {[Measures].members} on columns, ");
            if ("1".equals(paramValue)) {
                mdx.append("\n non empty union({[Company].members} * {union([Currency].members,{[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]})},{[Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]} * {[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}) on rows ").append("\n from fm");
            } else {
                mdx.append("\n non empty union({[Company].levels(0).members} * {union([Currency].members,{[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]})},{[Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]} * {[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}) on rows ").append("\n from fm");
            }
        } else if (forBank) {
            configFile = "RptBlockFundFlowGG_bank.xml";
            Object rsBank = null;
            sql.setLength(0);
            sql.append(" select A.FID, A.FName_" + loc + " FName ").append("\n from t_bd_bank A");
            ss.setDataItem("Bank", sql.toString(), null);
            mdx.append(" member [Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Bank].levels(0).members)'").append(" select ").append("\n {[Measures].members} on columns, ");
            if ("1".equals(paramValue)) {
                mdx.append("\n non empty union({[Bank].members} * {union([Currency].members,{[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]})},{[Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]} * {[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}) on rows ").append("\n from fm");
            } else {
                mdx.append("\n non empty union({[Bank].levels(0).members} * {union([Currency].members,{[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]})},{[Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]} * {[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}) on rows ").append("\n from fm");
            }
        } else {
            configFile = "RptBlockFundFlowGG_currency.xml";
            mdx.append(" select ").append("\n {[Measures].members} on columns, ").append("\n non empty union([Currency].members,{[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}) on rows ").append("\n from fm");
        }
        ss.setCaller(RptBlockFundFlowGGFacadeControllerBean.class);
        ss.setFilename(configFile);
        ss.setMdx(mdx.toString());
        return ss;
    }

    private String buildFactTempTable(Context ctx) throws BOSException {
        String sSQL = "if not exists (select * from KSQL_USERTABLES where KSQL_COL_TABNAME='T_Temp_RptLoanStruanalyse') Create Table T_Temp_RptLoanStruanalyse (FRateCurrencyId Varchar(44), FRate NUMERIC(17,8) DEFAULT 0);";
        DbUtil.execute((Context)ctx, (String)sSQL);
        sSQL = "Delete From T_Temp_RptLoanStruanalyse";
        DbUtil.execute((Context)ctx, (String)sSQL);
        return "T_Temp_RptLoanStruanalyse";
    }

    private static String getTempTableSql(Context ctx, String sql, SqlParams sp, String tempTableName) throws BOSException {
        String tempBankTablefact = BireportBaseFacadeControllerBean.getTempTableName((String)tempTableName, (Context)ctx);
        StringBuffer baseSqlfact = new StringBuffer();
        baseSqlfact.append("Select * into ").append(tempBankTablefact).append(" from ( ").append(sql).append(" ) as tt");
        BireportBaseFacadeControllerBean.executeSelectInto((String)baseSqlfact.toString(), (SqlParams)sp, (Context)ctx);
        String newSql = "select * from " + tempBankTablefact;
        return newSql;
    }
}

