/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.FundFlowItemCollection;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.IFundFlowItem;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.mnt.MNTException;
import com.kingdee.eas.fm.mnt.MerageUnitTreeInfo;
import com.kingdee.eas.fm.mnt.app.AbstractRptCashFlowFacadeControllerBean;
import com.kingdee.eas.fm.mnt.utils.MNTUtils;
import com.kingdee.eas.fm.mnt.vo.CompanyFundFlowInfo;
import com.kingdee.eas.fm.mnt.vo.FundFlowInfo;
import com.kingdee.eas.fm.mnt.vo.MergeFundFlowInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class RptCashFlowFacadeControllerBean
extends AbstractRptCashFlowFacadeControllerBean {
    private static final long serialVersionUID = -4264406312571716331L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mnt.app.RptCashFlowFacadeControllerBean");
    private static final String RES = "com.kingdee.eas.fm.mnt.ReportResource";

    @Override
    protected List _getFundFlowInfoList(Context ctx, IObjectValue model, java.util.Date startDate, java.util.Date endDate) throws BOSException, EASBizException {
        String flowId = this.getFixedFundFlowID(ctx);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)model;
        String companyId = company.getId().toString();
        String orgId = "'" + companyId + "'";
        String baseCurrencyID = company.getBaseCurrency().getId().toString();
        String baseExTableID = company.getBaseExchangeTable().getId().toString();
        Map<String, BigDecimal> rateMap = this.getRateMap(ctx, orgId, baseCurrencyID, baseExTableID, startDate, endDate);
        Map<String, BigDecimal> flowAmtMap = null;
        if (rateMap != null && rateMap.size() > 0) {
            flowAmtMap = this.getFlowAmtMap(ctx, companyId, startDate, endDate, rateMap);
        }
        Map<String, BigDecimal> startBalanceMap = this.getStartBalance4Single(ctx, flowId, companyId, rateMap, baseCurrencyID, baseExTableID, startDate, endDate);
        if (flowAmtMap != null) {
            flowAmtMap.putAll(startBalanceMap);
        } else {
            flowAmtMap = startBalanceMap;
        }
        if (flowAmtMap != null && flowAmtMap.size() > 0) {
            Map<String, BigDecimal> parentMap = this.getParentAmtMap4Single(ctx, flowAmtMap);
            flowAmtMap.putAll(parentMap);
        }
        List<FundFlowInfo> lst = this.getFundFlowItemList(ctx, flowAmtMap);
        return lst;
    }

    private List<FundFlowInfo> getFundFlowItemList(Context ctx, Map<String, BigDecimal> flowAmtMap) throws BOSException {
        ArrayList<FundFlowInfo> lst = new ArrayList<FundFlowInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isRptCalc", (Object)new Integer(1)));
        view.setFilter(filter);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("longNumber"));
        view.setSorter(sort);
        FundFlowItemCollection colls = FundFlowItemFactory.getLocalInstance((Context)ctx).getFundFlowItemCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            FundFlowItemInfo srcInfo = colls.get(i);
            FundFlowInfo destInfo = this.convertFundFlowInfo(srcInfo);
            String pk = destInfo.getFundFlowItemID();
            if (flowAmtMap != null && flowAmtMap.containsKey(pk)) {
                destInfo.setActAmt(flowAmtMap.get(pk));
            }
            lst.add(destInfo);
        }
        return lst;
    }

    private FundFlowInfo convertFundFlowInfo(FundFlowItemInfo srcInfo) {
        FundFlowInfo destInfo = new FundFlowInfo();
        destInfo.setFundFlowItemID(srcInfo.getId().toString());
        destInfo.setNumber(srcInfo.getNumber());
        destInfo.setName(srcInfo.getName());
        destInfo.setLongNumber(srcInfo.getLongNumber());
        destInfo.setIsLeaf(srcInfo.isIsLeaf());
        destInfo.setLevel(srcInfo.getLevel());
        return destInfo;
    }

    private Map<String, BigDecimal> getParentAmtMap4Single(Context ctx, Map<String, BigDecimal> flowAmtMap) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> parentMap = new HashMap<String, BigDecimal>();
        IFundFlowItem iFundFlowItem = FundFlowItemFactory.getLocalInstance((Context)ctx);
        for (Map.Entry<String, BigDecimal> entry : flowAmtMap.entrySet()) {
            BigDecimal init;
            FundFlowItemInfo info = iFundFlowItem.getFundFlowItemInfo((IObjectPK)new ObjectUuidPK(entry.getKey()));
            BigDecimal direction = info.getDirection() == FundFlowDirection.OUT ? new BigDecimal(-1) : BigDecimal.ONE;
            BigDecimal bigDecimal = init = entry.getValue() != null ? entry.getValue() : BigDecimal.ZERO;
            if (info.getParent() == null) continue;
            String pid = info.getParent().getId().toString();
            this.calc(iFundFlowItem, pid, init, direction, parentMap);
        }
        return parentMap;
    }

    private void calc(IFundFlowItem iFundFlowItem, String key, BigDecimal value, BigDecimal childDir, Map<String, BigDecimal> parentMap) throws BOSException, EASBizException {
        FundFlowItemInfo info = iFundFlowItem.getFundFlowItemInfo((IObjectPK)new ObjectUuidPK(key));
        if (info.isIsRptCalc()) {
            BigDecimal direction = info.getDirection() == FundFlowDirection.OUT ? new BigDecimal(-1) : BigDecimal.ONE;
            BigDecimal operate = direction.compareTo(childDir) > 0 ? new BigDecimal(-1) : BigDecimal.ONE;
            BigDecimal init = value.multiply(operate);
            BigDecimal pValue = null;
            pValue = parentMap.containsKey(key) ? init.add(parentMap.get(key)) : init;
            parentMap.put(key, pValue);
            if (info.getParent() != null) {
                String pid = info.getParent().getId().toString();
                this.calc(iFundFlowItem, pid, init, direction, parentMap);
            }
        }
    }

    private Map<String, BigDecimal> getStartBalance4Single(Context ctx, String flowId, String companyId, Map<String, BigDecimal> rateMap, String baseCurrencyID, String baseExTableID, java.util.Date startDate, java.util.Date endDate) throws BOSException, EASBizException {
        String orgId = "'" + companyId + "'";
        IRowSet rs = this.getCasPeriod(ctx, orgId);
        BigDecimal balance = this.getCompanyBalance(ctx, rs, startDate, rateMap, baseCurrencyID, baseExTableID, endDate);
        HashMap<String, BigDecimal> flowAmtMap = new HashMap<String, BigDecimal>();
        flowAmtMap.put(flowId, balance);
        return flowAmtMap;
    }

    private BigDecimal getCompanyBalance(Context ctx, IRowSet confRS, java.util.Date startDate, Map<String, BigDecimal> rateMap, String baseCurrencyID, String baseExTableID, java.util.Date endDate) throws BOSException, EASBizException {
        BigDecimal balance = null;
        try {
            while (confRS.next()) {
                balance = BigDecimal.ZERO;
                String key = confRS.getString("FCompanyID");
                int startPeriod = confRS.getInt("startPeriod");
                Date startBeginDate = confRS.getDate("startBeginDate");
                IRowSet bizRS = this.getBizData4Single(ctx, key, startPeriod, startBeginDate, startDate);
                IExchangeRate iExchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
                while (bizRS.next()) {
                    String srcCurrencyID = bizRS.getString("FCurrencyID");
                    BigDecimal rate = BigDecimal.ONE;
                    if (rateMap.containsKey(srcCurrencyID)) {
                        rate = rateMap.get(srcCurrencyID);
                    } else if (srcCurrencyID.equals(baseCurrencyID)) {
                        rateMap.put(srcCurrencyID, BigDecimal.ONE);
                    } else {
                        ExchangeRateInfo erInfo = iExchangRate.getExchangeRateConvertInfo((IObjectPK)new ObjectUuidPK(baseExTableID), (IObjectPK)new ObjectUuidPK(srcCurrencyID), (IObjectPK)new ObjectUuidPK(baseCurrencyID), endDate);
                        if (erInfo == null) {
                            logger.error((Object)("srcCurrencyID = " + srcCurrencyID + "not find rate!"));
                            SelectorItemCollection sic = new SelectorItemCollection();
                            sic.add(new SelectorItemInfo("name"));
                            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(srcCurrencyID), sic);
                            throw new MNTException(MNTException.NOEXCHANGE, new Object[]{currency.getName()});
                        }
                        rate = erInfo.getConvertRate();
                        rateMap.put(srcCurrencyID, rate);
                    }
                    balance = balance.add(bizRS.getBigDecimal("FActAmt").multiply(rate));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return balance;
    }

    private IRowSet getBizData4Single(Context ctx, String companyID, int startPeriod, java.util.Date startBeginDate, java.util.Date startDate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT jb.FCompanyID, jb.FCurrencyID, ISNULL(jb.FMonthStartAmt,0)/10000 FActAmt   ");
        sql.append(" FROM T_CAS_JournalBalance jb    ");
        sql.append(" left join T_BD_AccountBanks acc on acc.fid = jb.FAccountBankID   ");
        sql.append(" left join T_BD_Bank bank on bank.FID = acc.FBank   ");
        sql.append(" left join T_BD_Period pd on pd.FID = jb.FPeriodID     ");
        sql.append(" WHERE FType IN(1,2) and acc.FIsClosed = 0 and bank.FIsInGroup = 0 and FIsInit = 0   ");
        sql.append(" and jb.FCompanyID = '" + companyID + "'");
        sql.append(" and pd.FNumber = " + startPeriod);
        sql.append(" UNION ALL  ");
        sql.append(" SELECT j.FCompanyID,j.FCurrencyID, SUM(FDebitAmount - FCreditAmount)/10000 FActAmt   ");
        sql.append(" FROM  T_CAS_Journal j     ");
        sql.append(" left join T_BD_AccountBanks acc on acc.fid = j.FAccountBankID   ");
        sql.append(" left join T_BD_Bank bank on bank.FID = acc.FBank   ");
        sql.append(" WHERE acc.FIsClosed = 0 and bank.FIsInGroup = 0    ");
        sql.append(" and  j.FCompanyID = '" + companyID + "'");
        sql.append(" and j.FCreateDate >= {ts'" + DateHelper.formatDate2((java.util.Date)startBeginDate) + "'}");
        sql.append(" and j.FCreateDate <  {ts'" + DateHelper.formatDate2((java.util.Date)startDate) + "'}");
        sql.append(" GROUP BY j.FCompanyID, j.FCurrencyID   ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private Map<String, BigDecimal> getFlowAmtMap(Context ctx, String companyId, java.util.Date startDate, java.util.Date endDate, Map<String, BigDecimal> rateMap) throws BOSException {
        HashMap<String, BigDecimal> flowAmtMap = new HashMap<String, BigDecimal>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select rpt.FFundFlowItemID, rpt.FCurrencyID,  ");
        sql.append(" case  ");
        sql.append("   when ffi.FDirection = 1 then sum(rpt.FDebitAmt - rpt.FCreditAmt)/10000  ");
        sql.append("   when ffi.FDirection = 2 then sum(rpt.FDebitAmt - rpt.FCreditAmt)/10000*-1 else 0 ");
        sql.append(" end FActAmt ");
        sql.append(" from T_MNT_FundFlowDayReport rpt ");
        sql.append(" left join T_CAS_FundFlowItem ffi on ffi.FID = rpt.FFundFlowItemID ");
        sql.append(" where rpt.FFundFlowItemID is not null ");
        sql.append(" and ffi.FIsRptCalc = 1 ");
        sql.append(" and rpt.FCompanyID = '" + companyId + "'");
        sql.append(" and rpt.FBizTime >= {ts'" + DateHelper.formatDate2((java.util.Date)startDate) + "'}");
        sql.append(" and rpt.FBizTime <= {ts'" + DateHelper.formatDate2((java.util.Date)endDate) + "'}");
        sql.append(" group by rpt.FFundFlowItemID, ffi.FDirection, rpt.FCurrencyID ");
        IRowSet rs = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString()).executeSQL();
        try {
            BigDecimal subTotalAmt = BigDecimal.ZERO;
            while (rs.next()) {
                String key = rs.getString("FFundFlowItemID");
                String srcCurrencyID = rs.getString("FCurrencyID");
                BigDecimal rate = BigDecimal.ONE;
                if (rateMap.containsKey(srcCurrencyID)) {
                    rate = rateMap.get(srcCurrencyID);
                }
                subTotalAmt = !flowAmtMap.containsKey(key) ? rs.getBigDecimal("FActAmt").multiply(rate) : subTotalAmt.add(rs.getBigDecimal("FActAmt").multiply(rate));
                flowAmtMap.put(key, subTotalAmt);
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        return flowAmtMap;
    }

    @Override
    protected List _getMergeFundFlowList(Context ctx, IObjectValue model, String orgIds, java.util.Date startDate, java.util.Date endDate) throws BOSException, EASBizException {
        String flowId = this.getFixedFundFlowID(ctx);
        MerageUnitTreeInfo tree = (MerageUnitTreeInfo)model;
        String baseCurrencyID = tree.getMergeCurrency().getId().toString();
        String baseExTableID = tree.getRptConvertExaTable().getId().toString();
        String treeId = tree.getId().toString();
        Map<String, BigDecimal> rateMap = this.getRateMap(ctx, orgIds, baseCurrencyID, baseExTableID, startDate, endDate);
        Map<String, MergeFundFlowInfo> flowAmtMap = null;
        if (rateMap != null && rateMap.size() > 0) {
            flowAmtMap = this.getFlowAmtInfo(ctx, orgIds, rateMap, startDate, endDate);
            flowAmtMap = this.getEliminateAmt(ctx, treeId, orgIds, flowAmtMap, rateMap, startDate, endDate);
        }
        Map<String, MergeFundFlowInfo> startBalanceMap = this.getStartBalance(ctx, flowId, orgIds, rateMap, baseCurrencyID, baseExTableID, startDate, endDate);
        if (flowAmtMap != null) {
            flowAmtMap.putAll(startBalanceMap);
        } else {
            flowAmtMap = startBalanceMap;
        }
        if (flowAmtMap != null && flowAmtMap.size() > 0) {
            Map<String, MergeFundFlowInfo> parentMap = this.getParentAmtMap(ctx, flowAmtMap);
            flowAmtMap.putAll(parentMap);
        }
        List<MergeFundFlowInfo> lst = this.getFundFlowInfoList(ctx, flowAmtMap);
        return lst;
    }

    private String getFixedFundFlowID(Context ctx) throws BOSException, EASBizException {
        String flowId = "lVIAAAAqMMlggo5y";
        IFundFlowItem iFundFlowItem = FundFlowItemFactory.getLocalInstance((Context)ctx);
        if (!iFundFlowItem.exists((IObjectPK)new ObjectUuidPK(flowId))) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(0)));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)EASResource.getString((String)RES, (String)"19_FIXED_DATE_START_BALANCE"), CompareType.LIKE));
            view.setFilter(filter);
            FundFlowItemCollection colls = iFundFlowItem.getFundFlowItemCollection(view);
            if (EmptyUtil.isEmpty((AbstractObjectCollection)colls)) {
                throw new MNTException(MNTException.START_BALANCE_FLOW_ID_ISNULL);
            }
            flowId = colls.get(0).getId().toString();
        }
        return flowId;
    }

    private List<MergeFundFlowInfo> getFundFlowInfoList(Context ctx, Map<String, MergeFundFlowInfo> flowAmtMap) throws BOSException {
        ArrayList<MergeFundFlowInfo> lst = new ArrayList<MergeFundFlowInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isRptCalc", (Object)new Integer(1)));
        view.setFilter(filter);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("longNumber"));
        view.setSorter(sort);
        FundFlowItemCollection colls = FundFlowItemFactory.getLocalInstance((Context)ctx).getFundFlowItemCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            FundFlowItemInfo info = colls.get(i);
            MergeFundFlowInfo destInfo = this.convertInfo(info);
            String pk = info.getId().toString();
            if (flowAmtMap != null && flowAmtMap.containsKey(pk)) {
                MergeFundFlowInfo srcInfo = flowAmtMap.get(pk);
                destInfo.setCompAmtList(srcInfo.getCompAmtList());
                destInfo.setSummaryAmt(srcInfo.getSummaryAmt());
                destInfo.setElimWithinAmt(srcInfo.getElimWithinAmt());
                destInfo.setElimOutsideAmt(srcInfo.getElimOutsideAmt());
            }
            lst.add(destInfo);
        }
        return lst;
    }

    private MergeFundFlowInfo convertInfo(FundFlowItemInfo info) {
        MergeFundFlowInfo destInfo = new MergeFundFlowInfo();
        destInfo.setFundFlowItemID(info.getId().toString());
        destInfo.setNumber(info.getNumber());
        destInfo.setName(info.getName());
        destInfo.setLongNumber(info.getLongNumber());
        destInfo.setIsLeaf(info.isIsLeaf());
        destInfo.setLevel(info.getLevel());
        return destInfo;
    }

    private Map<String, MergeFundFlowInfo> getParentAmtMap(Context ctx, Map<String, MergeFundFlowInfo> flowAmtMap) throws BOSException {
        HashMap<String, MergeFundFlowInfo> parentMap = new HashMap<String, MergeFundFlowInfo>();
        try {
            IFundFlowItem iFundFlowItem = FundFlowItemFactory.getLocalInstance((Context)ctx);
            for (Map.Entry<String, MergeFundFlowInfo> entry : flowAmtMap.entrySet()) {
                FundFlowItemInfo info = iFundFlowItem.getFundFlowItemInfo((IObjectPK)new ObjectUuidPK(entry.getKey()));
                BigDecimal direction = info.getDirection() == FundFlowDirection.OUT ? new BigDecimal(-1) : BigDecimal.ONE;
                MergeFundFlowInfo initInfo = entry.getValue();
                if (info.getParent() == null) continue;
                String pid = info.getParent().getId().toString();
                this.calc(iFundFlowItem, pid, initInfo, direction, parentMap);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return parentMap;
    }

    private void calc(IFundFlowItem iFundFlowItem, String key, MergeFundFlowInfo initInfo, BigDecimal childDir, Map<String, MergeFundFlowInfo> parentMap) throws BOSException, EASBizException {
        FundFlowItemInfo info = iFundFlowItem.getFundFlowItemInfo((IObjectPK)new ObjectUuidPK(key));
        if (info.isIsRptCalc()) {
            BigDecimal direction = info.getDirection() == FundFlowDirection.OUT ? new BigDecimal(-1) : BigDecimal.ONE;
            BigDecimal operate = direction.compareTo(childDir) > 0 ? new BigDecimal(-1) : BigDecimal.ONE;
            MergeFundFlowInfo parentInfo = null;
            parentInfo = parentMap.containsKey(key) ? this.buildMergeFundFlowInfo(key, initInfo, operate, parentMap.get(key)) : this.buildMergeFundFlowInfo(key, initInfo, operate);
            parentMap.put(key, parentInfo);
            if (info.getParent() != null) {
                String pid = info.getParent().getId().toString();
                this.calc(iFundFlowItem, pid, initInfo, childDir, parentMap);
            }
        }
    }

    private MergeFundFlowInfo buildMergeFundFlowInfo(String key, MergeFundFlowInfo initInfo, BigDecimal direction, MergeFundFlowInfo currInfo) {
        MergeFundFlowInfo pInfo = new MergeFundFlowInfo();
        pInfo.setFundFlowItemID(key);
        pInfo.setSummaryAmt(initInfo.getSummaryAmt().multiply(direction).add(currInfo.getSummaryAmt()));
        BigDecimal initElimWithinAmt = initInfo.getElimWithinAmt() != null ? initInfo.getElimWithinAmt() : BigDecimal.ZERO;
        BigDecimal currElimWithinAmt = currInfo.getElimWithinAmt() != null ? currInfo.getElimWithinAmt() : BigDecimal.ZERO;
        pInfo.setElimWithinAmt(initElimWithinAmt.multiply(direction).add(currElimWithinAmt));
        BigDecimal initElimOutsideAmt = initInfo.getElimOutsideAmt() != null ? initInfo.getElimOutsideAmt() : BigDecimal.ZERO;
        BigDecimal currElimOutsideAmt = currInfo.getElimOutsideAmt() != null ? currInfo.getElimOutsideAmt() : BigDecimal.ZERO;
        pInfo.setElimOutsideAmt(initElimOutsideAmt.multiply(direction).add(currElimOutsideAmt));
        List<CompanyFundFlowInfo> lst = this.getCompanyAmtList(key, initInfo, direction, currInfo);
        pInfo.setCompAmtList(lst);
        return pInfo;
    }

    private List<CompanyFundFlowInfo> getCompanyAmtList(String key, MergeFundFlowInfo initInfo, BigDecimal direction, MergeFundFlowInfo currInfo) {
        HashMap<String, CompanyFundFlowInfo> initCompMap = new HashMap<String, CompanyFundFlowInfo>();
        HashMap<String, CompanyFundFlowInfo> currCompMap = new HashMap<String, CompanyFundFlowInfo>();
        HashSet<String> compIdSet = new HashSet<String>();
        if (initInfo.getCompAmtList() != null && initInfo.getCompAmtList().size() > 0) {
            for (CompanyFundFlowInfo initCompInfo : initInfo.getCompAmtList()) {
                initCompMap.put(initCompInfo.getCompanyID(), initCompInfo);
                compIdSet.add(initCompInfo.getCompanyID());
            }
        }
        if (currInfo.getCompAmtList() != null && currInfo.getCompAmtList().size() > 0) {
            for (CompanyFundFlowInfo currCompInfo : currInfo.getCompAmtList()) {
                currCompMap.put(currCompInfo.getCompanyID(), currCompInfo);
                compIdSet.add(currCompInfo.getCompanyID());
            }
        }
        ArrayList<CompanyFundFlowInfo> lst = new ArrayList<CompanyFundFlowInfo>();
        for (String compKey : compIdSet) {
            CompanyFundFlowInfo destComp = new CompanyFundFlowInfo();
            destComp.setFundFlowItemID(key);
            destComp.setCompanyID(compKey);
            BigDecimal currAmt = BigDecimal.ZERO;
            BigDecimal initAmt = BigDecimal.ZERO;
            if (initCompMap.containsKey(compKey) && currCompMap.containsKey(compKey)) {
                if (currCompMap.get(compKey) != null && ((CompanyFundFlowInfo)currCompMap.get(compKey)).getActAmt() != null) {
                    currAmt = ((CompanyFundFlowInfo)currCompMap.get(compKey)).getActAmt();
                }
                if (initCompMap.get(compKey) != null && ((CompanyFundFlowInfo)initCompMap.get(compKey)).getActAmt() != null) {
                    initAmt = direction.multiply(((CompanyFundFlowInfo)initCompMap.get(compKey)).getActAmt());
                }
            } else if (initCompMap.containsKey(compKey) && !currCompMap.containsKey(compKey)) {
                if (initCompMap.get(compKey) != null && ((CompanyFundFlowInfo)initCompMap.get(compKey)).getActAmt() != null) {
                    initAmt = direction.multiply(((CompanyFundFlowInfo)initCompMap.get(compKey)).getActAmt());
                }
            } else if (!initCompMap.containsKey(compKey) && currCompMap.containsKey(compKey) && currCompMap.get(compKey) != null && ((CompanyFundFlowInfo)currCompMap.get(compKey)).getActAmt() != null) {
                currAmt = ((CompanyFundFlowInfo)currCompMap.get(compKey)).getActAmt();
            }
            destComp.setActAmt(currAmt.add(initAmt));
            lst.add(destComp);
        }
        return lst;
    }

    private MergeFundFlowInfo buildMergeFundFlowInfo(String key, MergeFundFlowInfo srcInfo, BigDecimal direction) {
        MergeFundFlowInfo dest = new MergeFundFlowInfo();
        if (key != null) {
            dest.setFundFlowItemID(key);
        } else {
            dest.setFundFlowItemID(srcInfo.getFundFlowItemID());
        }
        ArrayList<CompanyFundFlowInfo> lst = new ArrayList<CompanyFundFlowInfo>();
        for (CompanyFundFlowInfo compInfo : srcInfo.getCompAmtList()) {
            CompanyFundFlowInfo destComp = compInfo.copy();
            destComp.setActAmt(compInfo.getActAmt().multiply(direction));
            lst.add(destComp);
        }
        dest.setCompAmtList(lst);
        dest.setSummaryAmt(srcInfo.getSummaryAmt().multiply(direction));
        if (srcInfo.getElimWithinAmt() != null) {
            dest.setElimWithinAmt(srcInfo.getElimWithinAmt().multiply(direction));
        }
        if (srcInfo.getElimOutsideAmt() != null) {
            dest.setElimOutsideAmt(srcInfo.getElimOutsideAmt().multiply(direction));
        }
        return dest;
    }

    private Map<String, MergeFundFlowInfo> getEliminateAmt(Context ctx, String treeId, String orgIds, Map<String, MergeFundFlowInfo> flowAmtMap, Map<String, BigDecimal> rateMap, java.util.Date startDate, java.util.Date endDate) throws BOSException {
        MergeFundFlowInfo info;
        StringBuffer mergeUnitIds = new StringBuffer();
        if ((mergeUnitIds = MNTUtils.getMergeUnitIdByGroup(ctx, treeId, mergeUnitIds)) != null && mergeUnitIds.length() > 0) {
            mergeUnitIds.deleteCharAt(mergeUnitIds.length() - 1);
        }
        String mergeIds = mergeUnitIds.toString();
        Map<String, BigDecimal> elimWithinMap = this.getElimWithInData(ctx, orgIds, mergeIds, rateMap, startDate, endDate);
        Map<String, BigDecimal> elimOutSideMap = this.getElimOutsideData(ctx, orgIds, mergeIds, rateMap, startDate, endDate);
        if (elimWithinMap != null && elimWithinMap.size() > 0) {
            for (String key : elimWithinMap.keySet()) {
                if (!flowAmtMap.containsKey(key)) continue;
                info = flowAmtMap.get(key);
                info.setElimWithinAmt(elimWithinMap.get(key));
            }
        }
        if (elimOutSideMap != null && elimOutSideMap.size() > 0) {
            for (String key : elimOutSideMap.keySet()) {
                if (!flowAmtMap.containsKey(key)) continue;
                info = flowAmtMap.get(key);
                info.setElimOutsideAmt(elimOutSideMap.get(key));
            }
        }
        return flowAmtMap;
    }

    public Map<String, BigDecimal> getElimWithInData(Context ctx, String companyIds, String mergeIds, Map<String, BigDecimal> rateMap, java.util.Date startDate, java.util.Date endDate) throws BOSException {
        HashMap<String, BigDecimal> elimWithinMap = new HashMap<String, BigDecimal>();
        if (companyIds == null || companyIds.length() <= 0 || mergeIds == null || mergeIds.length() <= 0) {
            return elimWithinMap;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select rpt.FFundFlowItemID, rpt.FCurrencyID, 1 as mergeScope, ");
        sql.append(" case  ");
        sql.append("   when ffi.FDirection = 1 then sum(rpt.FDebitAmt - rpt.FCreditAmt)/10000  ");
        sql.append("   when ffi.FDirection = 2 then sum(rpt.FDebitAmt - rpt.FCreditAmt)/10000*-1 else 0 ");
        sql.append(" end FActAmt ");
        sql.append(" from T_MNT_FundFlowDayReport rpt  ");
        sql.append(" left join T_CAS_FundFlowItem ffi on ffi.FID = rpt.FFundFlowItemID ");
        sql.append(" where rpt.FFundFlowItemID is not null and ffi.fisrpteliminate = 1  and ffi.FIsRptCalc = 1 ");
        sql.append(" and rpt.FCompanyID IN (").append(companyIds).append(") ");
        sql.append(" and rpt.Foppcompanyorgid IN (").append(companyIds).append(") ");
        sql.append(" and rpt.FBizTime >= {ts'").append(DateHelper.formatDate2((java.util.Date)startDate)).append("'} ");
        sql.append(" and rpt.FBizTime <= {ts'").append(DateHelper.formatDate2((java.util.Date)endDate)).append("'} ");
        sql.append(" group by rpt.FFundFlowItemID, ffi.FDirection, rpt.FCurrencyID ");
        IRowSet rs = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString()).executeSQL();
        try {
            BigDecimal subTotalAmt = BigDecimal.ZERO;
            while (rs.next()) {
                String key = rs.getString("FFundFlowItemID");
                String srcCurrencyID = rs.getString("FCurrencyID");
                BigDecimal rate = BigDecimal.ONE;
                if (rateMap.containsKey(srcCurrencyID)) {
                    rate = rateMap.get(srcCurrencyID);
                }
                subTotalAmt = !elimWithinMap.containsKey(key) ? rs.getBigDecimal("FActAmt").multiply(rate) : subTotalAmt.add(rs.getBigDecimal("FActAmt").multiply(rate));
                elimWithinMap.put(key, subTotalAmt);
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        return elimWithinMap;
    }

    public Map<String, BigDecimal> getElimOutsideData(Context ctx, String companyIds, String mergeIds, Map<String, BigDecimal> rateMap, java.util.Date startDate, java.util.Date endDate) throws BOSException {
        HashMap<String, BigDecimal> elimOutSideMap = new HashMap<String, BigDecimal>();
        if (companyIds == null || companyIds.length() <= 0 || mergeIds == null || mergeIds.length() <= 0) {
            return elimOutSideMap;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select rpt.FFundFlowItemID, rpt.FCurrencyID, 2 as mergeScope, ");
        sql.append(" case  ");
        sql.append("   when ffi.FDirection = 1 then sum(rpt.FDebitAmt - rpt.FCreditAmt)/10000  ");
        sql.append("   when ffi.FDirection = 2 then sum(rpt.FDebitAmt - rpt.FCreditAmt)/10000*-1 else 0 ");
        sql.append(" end FActAmt ");
        sql.append(" from T_MNT_FundFlowDayReport rpt  ");
        sql.append(" left join T_CAS_FundFlowItem ffi on ffi.FID = rpt.FFundFlowItemID ");
        sql.append(" where rpt.FFundFlowItemID is not null and ffi.fisrpteliminate = 1  and ffi.FIsRptCalc = 1 ");
        sql.append(" and rpt.FCompanyID IN (").append(companyIds).append(") ");
        sql.append(" and rpt.Foppcompanyorgid IN (select cfcompanyid from t_mnt_merageunit where cfcompanyid not in ( ");
        sql.append(" select cfcompanyid from t_mnt_merageunit where fid in(").append(mergeIds).append("))) ");
        sql.append(" and rpt.FBizTime >= {ts'").append(DateHelper.formatDate2((java.util.Date)startDate)).append("'} ");
        sql.append(" and rpt.FBizTime <= {ts'").append(DateHelper.formatDate2((java.util.Date)endDate)).append("'} ");
        sql.append(" group by rpt.FFundFlowItemID, ffi.FDirection, rpt.FCurrencyID ");
        IRowSet rs = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString()).executeSQL();
        try {
            BigDecimal subTotalAmt = BigDecimal.ZERO;
            while (rs.next()) {
                String key = rs.getString("FFundFlowItemID");
                String srcCurrencyID = rs.getString("FCurrencyID");
                BigDecimal rate = BigDecimal.ONE;
                if (rateMap.containsKey(srcCurrencyID)) {
                    rate = rateMap.get(srcCurrencyID);
                }
                subTotalAmt = !elimOutSideMap.containsKey(key) ? rs.getBigDecimal("FActAmt").multiply(rate) : subTotalAmt.add(rs.getBigDecimal("FActAmt").multiply(rate));
                elimOutSideMap.put(key, subTotalAmt);
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        return elimOutSideMap;
    }

    private Map<String, MergeFundFlowInfo> getFlowAmtInfo(Context ctx, String orgIds, Map<String, BigDecimal> rateMap, java.util.Date startDate, java.util.Date endDate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select rpt.FFundFlowItemID, rpt.FCompanyID, rpt.FCurrencyID, ");
        sql.append(" case  ");
        sql.append("   when ffi.FDirection = 1 then sum(rpt.FDebitAmt - rpt.FCreditAmt)/10000  ");
        sql.append("   when ffi.FDirection = 2 then sum(rpt.FDebitAmt - rpt.FCreditAmt)/10000*-1 else 0 ");
        sql.append(" end FActAmt ");
        sql.append(" from T_MNT_FundFlowDayReport rpt ");
        sql.append(" left join T_CAS_FundFlowItem ffi on ffi.FID = rpt.FFundFlowItemID ");
        sql.append(" where rpt.FFundFlowItemID is not null ");
        sql.append(" and ffi.FIsRptCalc = 1 ");
        sql.append(" and rpt.FCompanyID IN (" + orgIds + ") ");
        sql.append(" and rpt.FBizTime >= {ts'" + DateHelper.formatDate2((java.util.Date)startDate) + "'}");
        sql.append(" and rpt.FBizTime <= {ts'" + DateHelper.formatDate2((java.util.Date)endDate) + "'}");
        sql.append(" group by rpt.FFundFlowItemID, ffi.FDirection, rpt.FCompanyID, rpt.FCurrencyID ");
        IRowSet rs = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString()).executeSQL();
        HashMap<String, List<CompanyFundFlowInfo>> tmpMap = new HashMap<String, List<CompanyFundFlowInfo>>();
        try {
            while (rs.next()) {
                String key = rs.getString("FFundFlowItemID");
                CompanyFundFlowInfo cfInfo = new CompanyFundFlowInfo();
                cfInfo.setFundFlowItemID(key);
                cfInfo.setCompanyID(rs.getString("FCompanyID"));
                cfInfo.setCurrencyID(rs.getString("FCurrencyID"));
                cfInfo.setActAmt(rs.getBigDecimal("FActAmt"));
                ArrayList<CompanyFundFlowInfo> lst = (ArrayList<CompanyFundFlowInfo>)tmpMap.get(key);
                if (lst == null) {
                    lst = new ArrayList<CompanyFundFlowInfo>();
                }
                lst.add(cfInfo);
                tmpMap.put(key, lst);
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        Map<String, TreeMap<String, List<CompanyFundFlowInfo>>> flowMap = this.getFlowMap(tmpMap);
        Map<String, MergeFundFlowInfo> flowAmtMap = this.getFlowAmtMap(flowMap, rateMap);
        return flowAmtMap;
    }

    private Map<String, MergeFundFlowInfo> getFlowAmtMap(Map<String, TreeMap<String, List<CompanyFundFlowInfo>>> flowMap, Map<String, BigDecimal> rateMap) {
        HashMap<String, MergeFundFlowInfo> flowAmtMap = new HashMap<String, MergeFundFlowInfo>();
        for (String flowId : flowMap.keySet()) {
            Map compMap = flowMap.get(flowId);
            logger.info((Object)("-------------flowId=" + flowId + "-------------"));
            ArrayList<CompanyFundFlowInfo> lst = new ArrayList<CompanyFundFlowInfo>();
            BigDecimal summaryAmt = BigDecimal.ZERO;
            for (String comId : compMap.keySet()) {
                BigDecimal subComAmt = BigDecimal.ZERO;
                List comLst = (List)compMap.get(comId);
                for (CompanyFundFlowInfo info : comLst) {
                    String currencyID = info.getCurrencyID();
                    BigDecimal rate = BigDecimal.ONE;
                    if (rateMap.containsKey(currencyID)) {
                        rate = rateMap.get(currencyID);
                    }
                    subComAmt = subComAmt.add(info.getActAmt().multiply(rate));
                }
                CompanyFundFlowInfo dest = new CompanyFundFlowInfo();
                dest.setFundFlowItemID(flowId);
                dest.setCompanyID(comId);
                dest.setActAmt(subComAmt);
                lst.add(dest);
                summaryAmt = summaryAmt.add(subComAmt);
            }
            MergeFundFlowInfo mInfo = new MergeFundFlowInfo();
            mInfo.setFundFlowItemID(flowId);
            mInfo.setCompAmtList(lst);
            mInfo.setSummaryAmt(summaryAmt);
            flowAmtMap.put(flowId, mInfo);
        }
        return flowAmtMap;
    }

    private Map<String, TreeMap<String, List<CompanyFundFlowInfo>>> getFlowMap(Map<String, List<CompanyFundFlowInfo>> tmpMap) {
        HashMap<String, TreeMap<String, List<CompanyFundFlowInfo>>> flowMap = new HashMap<String, TreeMap<String, List<CompanyFundFlowInfo>>>();
        for (String flowId : tmpMap.keySet()) {
            List<CompanyFundFlowInfo> infoList = tmpMap.get(flowId);
            TreeMap<String, ArrayList<CompanyFundFlowInfo>> compMap = new TreeMap<String, ArrayList<CompanyFundFlowInfo>>();
            for (CompanyFundFlowInfo info : infoList) {
                String k = info.getCompanyID();
                ArrayList<CompanyFundFlowInfo> lst = (ArrayList<CompanyFundFlowInfo>)compMap.get(k);
                if (lst == null) {
                    lst = new ArrayList<CompanyFundFlowInfo>();
                }
                lst.add(info);
                compMap.put(k, lst);
            }
            flowMap.put(flowId, compMap);
        }
        return flowMap;
    }

    private Map<String, BigDecimal> getRateMap(Context ctx, String orgIds, String baseCurrencyID, String baseExTableID, java.util.Date startDate, java.util.Date endDate) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> rateMap = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select rpt.FCurrencyID  ");
        sql.append(" from T_MNT_FundFlowDayReport rpt ");
        sql.append(" where rpt.FFundFlowItemID is not null ");
        sql.append(" and rpt.FCompanyID IN (" + orgIds + ") ");
        sql.append(" and rpt.FBizTime >= {ts'" + DateHelper.formatDate2((java.util.Date)startDate) + "'}");
        sql.append(" and rpt.FBizTime <= {ts'" + DateHelper.formatDate2((java.util.Date)endDate) + "'}");
        sql.append(" group by rpt.FCurrencyID ");
        IRowSet rs = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString()).executeSQL();
        IExchangeRate iExchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        try {
            if (rs != null) {
                rateMap = new HashMap<String, BigDecimal>();
                while (rs.next()) {
                    String srcCurrencyID = rs.getString("FCurrencyID");
                    if (srcCurrencyID.equals(baseCurrencyID)) {
                        rateMap.put(baseCurrencyID, BigDecimal.ONE);
                        continue;
                    }
                    ExchangeRateInfo erInfo = iExchangRate.getExchangeRateConvertInfo((IObjectPK)new ObjectUuidPK(baseExTableID), (IObjectPK)new ObjectUuidPK(srcCurrencyID), (IObjectPK)new ObjectUuidPK(baseCurrencyID), endDate);
                    if (erInfo == null) {
                        logger.error((Object)("srcCurrencyID = " + srcCurrencyID + "not find rate!"));
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("name"));
                        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(srcCurrencyID), sic);
                        throw new MNTException(MNTException.NOEXCHANGE, new Object[]{currency.getName()});
                    }
                    rateMap.put(srcCurrencyID, erInfo.getConvertRate());
                }
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        return rateMap;
    }

    private Map<String, MergeFundFlowInfo> getStartBalance(Context ctx, String flowId, String orgIds, Map<String, BigDecimal> rateMap, String mergeCurrencyID, String baseExTableID, java.util.Date startDate, java.util.Date endDate) throws BOSException, EASBizException {
        IRowSet rs = this.getCasPeriod(ctx, orgIds);
        Map<String, List<CompanyFundFlowInfo>> orgMap = this.getCompanyBalance(ctx, rs, startDate);
        Map<String, MergeFundFlowInfo> flowAmtMap = this.getFlowAmtMap(ctx, flowId, orgMap, rateMap, mergeCurrencyID, baseExTableID, endDate);
        return flowAmtMap;
    }

    private Map<String, MergeFundFlowInfo> getFlowAmtMap(Context ctx, String flowId, Map<String, List<CompanyFundFlowInfo>> orgMap, Map<String, BigDecimal> rateMap, String mergeCurrencyID, String baseExTableID, java.util.Date endDate) throws BOSException, EASBizException {
        HashMap<String, MergeFundFlowInfo> flowMap = new HashMap<String, MergeFundFlowInfo>();
        if (rateMap == null) {
            logger.error((Object)"rateMap is null!");
            rateMap = new HashMap<String, BigDecimal>();
        }
        IExchangeRate iExchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ArrayList<CompanyFundFlowInfo> lst = new ArrayList<CompanyFundFlowInfo>();
        BigDecimal summaryAmt = BigDecimal.ZERO;
        for (String orgId : orgMap.keySet()) {
            BigDecimal subComAmt = BigDecimal.ZERO;
            List<CompanyFundFlowInfo> comLst = orgMap.get(orgId);
            for (CompanyFundFlowInfo info : comLst) {
                String srcCurrencyID = info.getCurrencyID();
                BigDecimal rate = BigDecimal.ONE;
                if (rateMap.containsKey(srcCurrencyID)) {
                    rate = rateMap.get(srcCurrencyID);
                } else if (srcCurrencyID.equals(mergeCurrencyID)) {
                    rateMap.put(srcCurrencyID, BigDecimal.ONE);
                } else {
                    ExchangeRateInfo erInfo = iExchangRate.getExchangeRateConvertInfo((IObjectPK)new ObjectUuidPK(baseExTableID), (IObjectPK)new ObjectUuidPK(srcCurrencyID), (IObjectPK)new ObjectUuidPK(mergeCurrencyID), endDate);
                    if (erInfo == null) {
                        logger.error((Object)("srcCurrencyID = " + srcCurrencyID + "not find rate!"));
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("name"));
                        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(srcCurrencyID), sic);
                        throw new MNTException(MNTException.NOEXCHANGE, new Object[]{currency.getName()});
                    }
                    rate = erInfo.getConvertRate();
                    rateMap.put(srcCurrencyID, rate);
                }
                subComAmt = subComAmt.add(info.getActAmt().multiply(rate));
            }
            CompanyFundFlowInfo dest = new CompanyFundFlowInfo();
            dest.setFundFlowItemID(flowId);
            dest.setCompanyID(orgId);
            dest.setActAmt(subComAmt);
            lst.add(dest);
            summaryAmt = summaryAmt.add(subComAmt);
        }
        MergeFundFlowInfo mInfo = new MergeFundFlowInfo();
        mInfo.setFundFlowItemID(flowId);
        mInfo.setCompAmtList(lst);
        mInfo.setSummaryAmt(summaryAmt);
        flowMap.put(flowId, mInfo);
        return flowMap;
    }

    private Map<String, List<CompanyFundFlowInfo>> getCompanyBalance(Context ctx, IRowSet confRS, java.util.Date startDate) throws BOSException {
        TreeMap<String, List<CompanyFundFlowInfo>> orgMap = new TreeMap<String, List<CompanyFundFlowInfo>>();
        try {
            while (confRS.next()) {
                String key = confRS.getString("FCompanyID");
                int startPeriod = confRS.getInt("startPeriod");
                Date startBeginDate = confRS.getDate("startBeginDate");
                IRowSet bizRS = this.getBizData(ctx, key, startPeriod, startBeginDate, startDate);
                ArrayList<CompanyFundFlowInfo> lst = (ArrayList<CompanyFundFlowInfo>)orgMap.get(key);
                if (lst == null) {
                    lst = new ArrayList<CompanyFundFlowInfo>();
                }
                while (bizRS.next()) {
                    String companyID = bizRS.getString("FCompanyID");
                    if (!key.equals(companyID)) continue;
                    CompanyFundFlowInfo cfInfo = new CompanyFundFlowInfo();
                    cfInfo.setCompanyID(key);
                    cfInfo.setCurrencyID(bizRS.getString("FCurrencyID"));
                    cfInfo.setActAmt(bizRS.getBigDecimal("FActAmt"));
                    lst.add(cfInfo);
                }
                orgMap.put(key, lst);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return orgMap;
    }

    private IRowSet getBizData(Context ctx, String companyID, int startPeriod, java.util.Date startBeginDate, java.util.Date startDate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FCompanyID, FCurrencyID, sum(FMonthStartAmt)/10000 FActAmt  ");
        sql.append(" from (  ");
        sql.append("   SELECT jb.FCompanyID, jb.FCurrencyID, ISNULL(jb.FMonthStartAmt,0) FMonthStartAmt   ");
        sql.append("   FROM T_CAS_JournalBalance jb    ");
        sql.append("   left join T_BD_AccountBanks acc on acc.fid = jb.FAccountBankID   ");
        sql.append("   left join T_BD_Bank bank on bank.FID = acc.FBank   ");
        sql.append("   left join T_BD_Period pd on pd.FID = jb.FPeriodID     ");
        sql.append("   WHERE FType IN(1,2) and acc.FIsClosed = 0 and bank.FIsInGroup = 0 and FIsInit = 0   ");
        sql.append("   and jb.FCompanyID = '" + companyID + "'");
        sql.append("   and pd.FNumber = " + startPeriod);
        sql.append("   UNION ALL  ");
        sql.append("   SELECT j.FCompanyID,j.FCurrencyID, SUM(FDebitAmount - FCreditAmount) FMonthStartAmt   ");
        sql.append("   FROM  T_CAS_Journal j     ");
        sql.append("   left join T_BD_AccountBanks acc on acc.fid = j.FAccountBankID   ");
        sql.append("   left join T_BD_Bank bank on bank.FID = acc.FBank   ");
        sql.append("   WHERE acc.FIsClosed = 0 and bank.FIsInGroup = 0    ");
        sql.append("   and  j.FCompanyID = '" + companyID + "'");
        sql.append("   and j.FCreateDate >= {ts'" + DateHelper.formatDate2((java.util.Date)startBeginDate) + "'}");
        sql.append("   and j.FCreateDate <  {ts'" + DateHelper.formatDate2((java.util.Date)startDate) + "'}");
        sql.append("   GROUP BY j.FCompanyID, j.FCurrencyID   ");
        sql.append(" ) as tmp   ");
        sql.append(" GROUP BY FCompanyID, FCurrencyID   ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getCasPeriod(Context ctx, String orgIds) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select ctrol.FCompanyID, ");
        sql.append("        startPer.FBeginDate startBeginDate, startPer.FPeriodYear * 100 + startPer.FPeriodNumber startPeriod, ");
        sql.append("        currPer.FPeriodYear * 100 + currPer.FPeriodNumber curPeriod  ");
        sql.append(" from T_BD_SystemStatusCtrol ctrol  ");
        sql.append(" left join T_BD_Period startPer on startPer.FID = ctrol.FStartPeriodID  ");
        sql.append(" left join T_BD_Period currPer on currPer.FID = ctrol.FCurrentPeriodID  ");
        sql.append(" where ctrol.FIsStart = 1  ");
        sql.append(" and ctrol.FSystemStatusID IN ( select FID from T_BD_SystemStatus where FName = 7 ) ");
        sql.append(" and ctrol.FCompanyID IN (" + orgIds + ") ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }
}

