/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.mnt.app.AbstractRptCreditLimitListFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.BirtUtils;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptCreditLimitListFacadeControllerBean
extends AbstractRptCreditLimitListFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mnt.app.RptCreditLimitListFacadeControllerBean");
    Set companyIdSet;
    Set bankIdSet;

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        SchemaSource ss = new SchemaSource();
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        this.bankIdSet = (Set)params.getObject("bankIdSet");
        int yearFrom = (Integer)params.getObjectElement("yearFrom.value");
        int yearTo = (Integer)params.getObjectElement("yearTo.value");
        AmountUnitEnum unit = (AmountUnitEnum)params.getObjectElement("kDUnit.value");
        StringBuffer factSql = new StringBuffer();
        StringBuffer mdx = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        String configFile = "";
        String loc = RptCreditLimitListFacadeControllerBean.getLoc((Context)ctx);
        Object rsYear = null;
        sql.setLength(0);
        sql.append(" select '1' as fid,'").append(yearFrom).append("' as fname");
        if (yearFrom != yearTo) {
            int nextFrom = yearFrom + 1;
            int spanInt = yearTo - yearFrom;
            int i = nextFrom;
            for (int k = 2; i <= yearTo && k <= spanInt + 1; ++i, ++k) {
                sql.append("\n union select '").append(k).append("' as fid,'").append(i).append("' as fname");
            }
        }
        ss.setDataItem("Year", sql.toString(), null);
        Object rsFact = null;
        SqlParams sp = new SqlParams();
        factSql.setLength(0);
        sql.setLength(0);
        Calendar calFrom = Calendar.getInstance();
        calFrom.set(1, yearFrom);
        calFrom.set(2, 0);
        calFrom.set(5, 1);
        Timestamp yearPeriodFrom = new Timestamp(DateTimeUtils.truncateDate((Date)calFrom.getTime()).getTime());
        Calendar calTo = Calendar.getInstance();
        calTo.set(1, yearFrom);
        calTo.set(2, 11);
        calTo.set(5, 31);
        Timestamp yearPeriodTo = new Timestamp(DateTimeUtils.truncateDate((Date)calTo.getTime()).getTime());
        factSql.append("select '1' as FYearId,");
        factSql.append(" sum(FQuotaAmount*FExchangeRate)/").append(unit.getValue()).append(" as FQuotaAmount,").append("sum(FUsedAmount*FExchangeRate)/").append(unit.getValue()).append(" as FUsedAmount,").append("sum(FBalance*FExchangeRate)/").append(unit.getValue()).append(" as FBalance").append(" from t_fin_creditlimit  where FIssueDate>=?\n and FIssueDate<=? ");
        sp.addTimestamp(yearPeriodFrom);
        sp.addTimestamp(yearPeriodTo);
        if (this.companyIdSet.size() > 0) {
            factSql.append("\n and FCompanyId in(");
            factSql.append(BirtUtils.idListToInClause((Collection)this.companyIdSet)).append(")");
        }
        if (this.bankIdSet.size() > 0) {
            factSql.append("\n and FCreditInstitutionId in(");
            factSql.append(BirtUtils.idListToInClause((Collection)this.bankIdSet)).append(")");
        }
        if (yearFrom != yearTo) {
            int nextFrom = yearFrom + 1;
            int spanInt = yearTo - yearFrom;
            int i = nextFrom;
            for (int k = 2; i <= yearTo && k <= spanInt + 1; ++i, ++k) {
                Calendar calSinceFrom = Calendar.getInstance();
                calSinceFrom.set(1, i);
                calSinceFrom.set(2, 0);
                calSinceFrom.set(5, 1);
                Timestamp yearPeriodSinceFrom = new Timestamp(DateTimeUtils.truncateDate((Date)calSinceFrom.getTime()).getTime());
                Calendar calSinceTo = Calendar.getInstance();
                calSinceTo.set(1, i);
                calSinceTo.set(2, 11);
                calSinceTo.set(5, 31);
                Timestamp yearPeriodSinceTo = new Timestamp(DateTimeUtils.truncateDate((Date)calSinceTo.getTime()).getTime());
                factSql.append("\n union all \n");
                factSql.append("select '").append(k).append("' as FYearId,");
                factSql.append(" sum(FQuotaAmount*FExchangeRate)/").append(unit.getValue()).append(" as FQuotaAmount,").append("sum(FUsedAmount*FExchangeRate)/").append(unit.getValue()).append(" as FUsedAmount,").append("sum(FBalance*FExchangeRate)/").append(unit.getValue()).append(" as FBalance").append(" from t_fin_creditlimit  where FIssueDate>=?\n and FIssueDate<=? ");
                sp.addTimestamp(yearPeriodSinceFrom);
                sp.addTimestamp(yearPeriodSinceTo);
                if (this.companyIdSet.size() > 0) {
                    factSql.append("\n and FCompanyId in(");
                    factSql.append(BirtUtils.idListToInClause((Collection)this.companyIdSet)).append(")");
                }
                if (this.bankIdSet.size() <= 0) continue;
                factSql.append("\n and FCreditInstitutionId in(");
                factSql.append(BirtUtils.idListToInClause((Collection)this.bankIdSet)).append(")");
            }
        }
        ss.setDataItem("Fact", factSql.toString(), sp);
        configFile = "RptCreditLimitList.xml";
        mdx.append("with member [Year].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Year].members)'").append("\n select [Measures].members on columns,").append("\n union({[Year].members},{[Year].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}) on rows ").append("\n from Fact");
        ss.setCaller(RptCreditLimitListFacadeControllerBean.class);
        ss.setFilename(configFile);
        ss.setMdx(mdx.toString());
        return ss;
    }
}

