/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.FMParamUtil;
import com.kingdee.eas.fm.common.util.JournalBalanceUtil;
import com.kingdee.eas.fm.mnt.MNTException;
import com.kingdee.eas.fm.mnt.app.AbstractRptCurrencyFundGGFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptCurrencyFundGGFacadeControllerBean
extends AbstractRptCurrencyFundGGFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.RptCurrencyFundGGFacadeControllerBean");

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        String companyId = params.getString("companyId");
        CurrencyCollection cc = this.getAllCurrency(companyId, ctx);
        int n = cc.size();
        for (int i = 0; i < n; ++i) {
            String currencyId = cc.get(i).getId().toString();
            if (!currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) && !currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) continue;
            cc.removeObject(i);
            --i;
            --n;
        }
        RptParams pp = new RptParams();
        pp.setObject("currencys", (Object)cc);
        return pp;
    }

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        String factTempTable2;
        String idField;
        SchemaSource ss = new SchemaSource();
        Timestamp toDate = new Timestamp(((Date)params.getObjectElement("jdDate.value")).getTime());
        toDate.setHours(23);
        toDate.setMinutes(59);
        toDate.setSeconds(59);
        String amountUnit = String.valueOf(((AmountUnitEnum)params.getObjectElement("jtAmountUnit.value")).getValue());
        Set bankIdSet = (Set)params.getObject("bankIdSet");
        Set companyIdSet = (Set)params.getObject("companyIdSet");
        Set rateCurrencyIdSet = (Set)params.getObject("RateCurrencySet");
        boolean forCompany = (Boolean)params.getObjectElement("jrbCompany.value");
        boolean forBank = (Boolean)params.getObjectElement("jrbBank.value");
        boolean allForeignCurrency = params.getBoolean("allForeignCurrency");
        boolean ckInnerAmt = (Boolean)params.getObjectElement("ckinnerAmt.value");
        BigDecimal txtAmtFrom = (BigDecimal)params.getObject("txtAmtFrom1");
        BigDecimal txtAmtTo = (BigDecimal)params.getObject("txtAmtTo1");
        boolean israteCurrency = rateCurrencyIdSet != null && rateCurrencyIdSet.size() > 0;
        Object[][] objs = (Object[][])params.getObjectElement("tbl.value");
        ArrayList<Object> currencyList = new ArrayList<Object>();
        for (int i = 0; i < objs.length; ++i) {
            if (!((Boolean)objs[i][0]).booleanValue()) continue;
            currencyList.add(objs[i][1]);
        }
        CurrencyInfo baseCurrency = (CurrencyInfo)currencyList.get(0);
        String currencySumID_1 = "111";
        String currencySumID_2 = "222";
        String loc = RptCurrencyFundGGFacadeControllerBean.getLoc((Context)ctx);
        String configFile = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer mdx = new StringBuffer();
        IRowSet rsCurrency = null;
        SqlParams currencySp = new SqlParams();
        sql.setLength(0);
        sql.append(" select distinct A.FID,A.FName from (select distinct FID, FName_" + loc + " FName from t_bd_currency where FID!='").append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID).append("' and FID!='").append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID).append("') A ").append("\n where (1=1 ");
        JournalBalanceUtil.appendCurrencyFilter((String)"A.FID", currencyList, (StringBuffer)sql, (SqlParams)currencySp, (boolean)allForeignCurrency);
        if (allForeignCurrency) {
            sql.append(")");
        } else {
            sql.append(") or A.FID='").append(baseCurrency.getId().toString()).append('\'');
        }
        sql.append("\n union all\n").append("select '").append("111").append("' FID, N'").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"zhehebenweibi", (Locale)ctx.getLocale())).append("' FName ");
        sql.append("\n union all\n").append("select '").append("222").append("' FID, N'").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"waibizhehebenweibi", (Locale)ctx.getLocale())).append("' FName ");
        rsCurrency = this._executeQuery(ctx, sql.toString(), currencySp);
        ss.setDataItem("Currency", sql.toString(), currencySp);
        String factTempTable = JournalBalanceUtil.createJournalBalanceTable2((Timestamp)toDate, (String)amountUnit, (Set)bankIdSet, (Set)companyIdSet, (boolean)allForeignCurrency, currencyList, (Context)ctx);
        StringBuffer factTempTableForCompany = new StringBuffer();
        factTempTableForCompany.append(" select  B.* from (select * from(select sum(FSum*FConvertRate) as FAmount,FCompanyID from ").append(factTempTable).append(" group by FCompanyID ) as aaa where 1=1 ");
        if (txtAmtFrom != null & txtAmtTo == null) {
            factTempTableForCompany.append(" and FAmount >= ").append(txtAmtFrom);
            factTempTableForCompany.append(" ) A left outer join ").append(factTempTable).append(" B on A.FCompanyID = B.FCompanyID");
        } else if (txtAmtFrom == null & txtAmtTo != null) {
            factTempTableForCompany.append(" and FAmount <= ").append(txtAmtTo);
            factTempTableForCompany.append(" ) A left outer join ").append(factTempTable).append(" B on A.FCompanyID = B.FCompanyID");
        } else if (txtAmtFrom != null & txtAmtTo != null) {
            factTempTableForCompany.append(" and FAmount >= ").append(txtAmtFrom).append(" and FAmount <= ").append(txtAmtTo);
            factTempTableForCompany.append(" ) A left outer join ").append(factTempTable).append(" B on A.FCompanyID = B.FCompanyID");
        } else {
            factTempTableForCompany.setLength(0);
            factTempTableForCompany.append("select * from " + factTempTable);
        }
        StringBuffer factTempTableForBank = new StringBuffer();
        factTempTableForBank.append(" select  B.* from (select * from(select sum(FSum*FConvertRate) as FAmount,FBankID from ").append(factTempTable).append(" group by FBankID ) as aaa where 1=1 ");
        if (txtAmtFrom != null & txtAmtTo == null) {
            factTempTableForBank.append(" and FAmount >= ").append(txtAmtFrom);
            factTempTableForBank.append(" ) A left outer join ").append(factTempTable).append(" B on A.FBankID = B.FBankID");
        } else if (txtAmtFrom == null & txtAmtTo != null) {
            factTempTableForBank.append(" and FAmount <= ").append(txtAmtTo);
            factTempTableForBank.append(" ) A left outer join ").append(factTempTable).append(" B on A.FBankID = B.FBankID");
        } else if (txtAmtFrom != null & txtAmtTo != null) {
            factTempTableForBank.append(" and FAmount >= ").append(txtAmtFrom).append(" and FAmount <= ").append(txtAmtTo);
            factTempTableForBank.append(" ) A left outer join ").append(factTempTable).append(" B on A.FBankID = B.FBankID");
        } else {
            factTempTableForBank.setLength(0);
            factTempTableForBank.append("select * from " + factTempTable);
        }
        String temptable = "";
        if (israteCurrency) {
            temptable = this.buildFactTempTable(ctx);
            HashSet<String> currencyIdSet = new HashSet<String>();
            StringBuffer currencySql = new StringBuffer();
            StringBuffer factGroup = new StringBuffer();
            idField = forCompany ? "FCompanyID" : "FBankID";
            factTempTable2 = forCompany ? factTempTableForCompany.toString() : factTempTableForBank.toString();
            factGroup.append("\n group by FCurrencyId, FConvertRate, ").append(idField);
            currencySql.append("select distinct FCurrencyID from (").append(factTempTable2).append(" ) t");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)currencySql.toString());
                while (rs.next()) {
                    currencyIdSet.add(rs.getString("FCurrencyID"));
                }
            }
            catch (SQLException rs) {
                // empty catch block
            }
            Iterator it = currencyIdSet.iterator();
            String locCurrencyId = (String)rateCurrencyIdSet.iterator().next();
            CurrencyInfo locCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(locCurrencyId));
            CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            String currencyStr = "";
            while (it.hasNext()) {
                String currencyid = (String)it.next();
                BigDecimal rate = null;
                if (currencyid.equals(locCurrencyId)) {
                    rate = Constants.ONE;
                } else {
                    CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyid));
                    ExchangeRateInfo rateInfo = FMHelper.getExRateInfo((Context)ctx, (CurrencyInfo)currency, (CurrencyInfo)locCurrency, (CompanyOrgUnitInfo)company, (Date)toDate);
                    if (EmptyUtil.isEmpty((CoreBaseInfo)rateInfo)) {
                        currencyStr = currencyStr + "," + currency.getName();
                    } else {
                        rate = ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)rateInfo.getConvertMode()) ? Constants.ONE.divide(rateInfo.getConvertRate(), 20, 4) : rateInfo.getConvertRate();
                    }
                }
                String insertCurrencySql = "insert into " + temptable + " values('" + currencyid + "', " + rate + ")";
                DbUtil.execute((Context)ctx, (String)insertCurrencySql);
            }
            if (currencyStr.length() > 0) {
                throw new MNTException(MNTException.EXCEPTIONEXHANGERATE, new Object[]{currencyStr.substring(1), locCurrency.getName()});
            }
        }
        StringBuffer factSql = new StringBuffer();
        StringBuffer factGroup = new StringBuffer();
        SqlParams sp = new SqlParams();
        idField = forCompany ? "FCompanyID" : "FBankID";
        String string = factTempTable2 = forCompany ? factTempTableForCompany.toString() : factTempTableForBank.toString();
        if (!ckInnerAmt) {
            factTempTable2 = factTempTable2 + " inner join T_BD_bank bank  on FBankID=bank.FID  where bank.FIsInGroup = 0  ";
        }
        factGroup.append("\n group by FCurrencyId, ").append(idField).append(israteCurrency ? ",FRate " : ",FConvertRate");
        factSql.append("select FCurrencyId, sum(FCurrent) FCurrent, sum(FFixed) FFixed, sum(FSum) FSum, ").append(idField).append("\n from ( ").append(factTempTable2).append(" )\n as bbb group by FCurrencyId,").append(idField).append("\n union all \n");
        if (israteCurrency) {
            factSql.append("select '111' FCurrencyId, sum(FCurrent)*FRate FCurrent, sum(FFixed)*FRate FFixed, sum(FSum)*FRate FSum, " + idField + " from (");
        } else {
            factSql.append("select '111' FCurrencyId, sum(FCurrent)*FConvertRate FCurrent, sum(FFixed)*FConvertRate FFixed, sum(FSum)*FConvertRate FSum, " + idField + " from (");
        }
        factSql.append(factTempTable2);
        factSql.append(" ) as ddd ");
        if (israteCurrency) {
            factSql.append(" left join " + temptable + " on " + temptable + ".FRateCurrencyID = ddd.FCurrencyID ");
        }
        factSql.append(factGroup);
        factSql.append(" \n union all \n");
        if (israteCurrency) {
            factSql.append("select '222' FCurrencyId, sum(FCurrent)*FRate FCurrent, sum(FFixed)*FRate FFixed, sum(FSum)*FRate FSum, " + idField + " from (");
        } else {
            factSql.append("select '222' FCurrencyId, sum(FCurrent)*FConvertRate FCurrent, sum(FFixed)*FConvertRate FFixed, sum(FSum)*FConvertRate FSum, " + idField + " from (");
        }
        factSql.append(factTempTable2);
        factSql.append(" )\n as ccc ");
        if (israteCurrency) {
            factSql.append(" left join " + temptable + " on " + temptable + ".FRateCurrencyID = ccc.FCurrencyID ");
        }
        factSql.append("where FCurrencyId<>?").append(factGroup);
        sp.addString(baseCurrency.getId().toString());
        ss.setDataItem("Fact", factSql.toString(), sp);
        try {
            HashSet<String> currencyIds = new HashSet<String>();
            while (rsCurrency.next()) {
                currencyIds.add(rsCurrency.getString("FID"));
            }
            int n = currencyList.size();
            for (int i = 1; i < n; ++i) {
                if (currencyIds.contains(((CurrencyInfo)currencyList.get(i)).getId().toString())) continue;
                currencyList.remove(i);
                --i;
                --n;
            }
            rsCurrency.absolute(-1);
            rsCurrency.moveToCurrentRow();
        }
        catch (Exception e) {
            throw new SQLDataException(e.getMessage());
        }
        StringBuffer currencyDim = new StringBuffer();
        if (allForeignCurrency) {
            currencyDim.append("filter([Currency].members,[Currency].currentmember.name<>\"").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"zhehebenweibi", (Locale)ctx.getLocale())).append("\")");
        } else {
            currencyDim.append("{[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"zhehebenweibi", (Locale)ctx.getLocale())).append("],[Currency].[").append(baseCurrency.getName()).append(']');
            int n = currencyList.size();
            if (n > 1) {
                currencyDim.append(", [Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"waibizhehebenweibi", (Locale)ctx.getLocale())).append("]");
                for (int i = 1; i < n; ++i) {
                    currencyDim.append(", [Currency].[").append(((CurrencyInfo)currencyList.get(i)).getName()).append(']');
                }
            }
            currencyDim.append('}');
        }
        String paramValue = FMParamUtil.getParamValue((Context)ctx, (String)"MNT001");
        mdx.append("with ");
        if (forCompany) {
            configFile = "RptCurrencyFundGG_company.xml";
            SqlParams spCompany = new SqlParams();
            sql.setLength(0);
            sql.append(" select A.FID, A.FName_" + loc + " FName, A.FParentID from t_org_company A where 1=1 ");
            JournalBalanceUtil.appendFilter((String)"A.FID", (Set)companyIdSet, (StringBuffer)sql, (SqlParams)spCompany, (String)"and");
            ss.setDataItem("Company", sql.toString(), spCompany);
            mdx.append(" member [Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Company].levels(0).members)' ");
            mdx.append(" select ").append("\n ").append(currencyDim).append(" * {[Measures].members} on columns, ");
            if ("1".equals(paramValue)) {
                mdx.append("\n non empty {union([Company].members,{[Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]})} on rows ").append("\n from fm");
            } else {
                mdx.append("\n non empty {union([Company].levels(0).members,{[Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]})} on rows ").append("\n from fm");
            }
        } else {
            configFile = "RptCurrencyFundGG_bank.xml";
            SqlParams bankSp = new SqlParams();
            sql.setLength(0);
            sql.append(" select A.FID, A.FName_" + loc + " FName,A.FParentID FParentID ").append("\n from t_bd_bank A where 1=1");
            JournalBalanceUtil.appendFilter((String)"A.FID", (Set)bankIdSet, (StringBuffer)sql, (SqlParams)bankSp, (String)"and");
            ss.setDataItem("Bank", sql.toString(), bankSp);
            mdx.append(" member [Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Bank].levels(0).members)' ");
            mdx.append(" select ").append("\n ").append(currencyDim).append(" *{[Measures].members} on columns, ");
            if ("1".equals(paramValue)) {
                mdx.append("\n non empty {union([Bank].members,{[Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]})} on rows ").append("\n from fm");
            } else {
                mdx.append("\n non empty {union([Bank].levels(0).members,{[Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]})} on rows ").append("\n from fm");
            }
        }
        ss.setCaller(RptCurrencyFundGGFacadeControllerBean.class);
        ss.setFilename(configFile);
        ss.setMdx(mdx.toString());
        return ss;
    }

    private String buildFactTempTable(Context ctx) throws BOSException {
        String sSQL = "if not exists (select * from KSQL_USERTABLES where KSQL_COL_TABNAME='T_Temp_RptLoanStruanalyse') Create Table T_Temp_RptLoanStruanalyse (FRateCurrencyId Varchar(44), FRate NUMERIC(17,8) DEFAULT 0);";
        DbUtil.execute((Context)ctx, (String)sSQL);
        sSQL = "Delete From T_Temp_RptLoanStruanalyse";
        DbUtil.execute((Context)ctx, (String)sSQL);
        return "T_Temp_RptLoanStruanalyse";
    }
}

