/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.util.JournalBalanceUtil;
import com.kingdee.eas.fm.common.util.RptFmOtherItemUtil;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.mnt.app.AbstractRptFinancingListFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.BirtUtils;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.bireport.util.SimpleTreeNode;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptFinancingListFacadeControllerBean
extends AbstractRptFinancingListFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mnt.app.RptFinancingListFacadeControllerBean");
    Set companyIdSet;
    Set currencyIdSet;
    Set bankIdSet;
    boolean forCompany;
    boolean forCurrency;
    boolean forBank;

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        SchemaSource ss = new SchemaSource();
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        this.currencyIdSet = (Set)params.getObject("currencyIdSet");
        ArrayList<CurrencyInfo> currencyIdList = new ArrayList<CurrencyInfo>();
        Iterator e = this.currencyIdSet.iterator();
        while (e.hasNext()) {
            currencyIdList.add(this.getCurrencyInfo(e.next().toString(), ctx));
        }
        this.bankIdSet = (Set)params.getObject("bankIdSet");
        SimpleTreeNode bankTreeNode = (SimpleTreeNode)params.getObject("bankTree");
        SimpleTreeNode selectedBankTreeNode = (SimpleTreeNode)params.getObject("childBankTree");
        int yearFrom = (Integer)params.getObjectElement("yearFrom.value");
        int yearTo = (Integer)params.getObjectElement("yearTo.value");
        AmountUnitEnum unit = (AmountUnitEnum)params.getObjectElement("kDUnit.value");
        this.forCompany = (Boolean)params.getObjectElement("kDRadioButtonCompany.value");
        this.forCurrency = (Boolean)params.getObjectElement("kDRadioButtonCurrency.value");
        this.forBank = (Boolean)params.getObjectElement("kDRadioButtonBank.value");
        StringBuffer factSql = new StringBuffer();
        StringBuffer factGroup = new StringBuffer();
        StringBuffer mdx = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        String configFile = "";
        String loc = RptFinancingListFacadeControllerBean.getLoc((Context)ctx);
        Object rsYear = null;
        sql.setLength(0);
        sql.append(" select '1' as fid,'").append(yearFrom).append("' as fname");
        if (yearFrom != yearTo) {
            int nextFrom = yearFrom + 1;
            int spanInt = yearTo - yearFrom;
            int i = nextFrom;
            for (int k = 2; i <= yearTo && k <= spanInt + 1; ++i, ++k) {
                sql.append("\n union select '").append(k).append("' as fid,'").append(i).append("' as fname");
            }
        }
        ss.setDataItem("Year", sql.toString(), null);
        Object rsFact = null;
        factSql.setLength(0);
        sql.setLength(0);
        sql.append(" select top 1 FEndDate from t_bd_period where fperiodyear = ").append(yearFrom).append(" order by fperiodNumber desc");
        IRowSet rsPeriod = this.executeQuery(ctx, sql.toString(), null);
        Timestamp yearPeriod = this.getYearPeriod((ResultSet)rsPeriod);
        if (yearPeriod == null) {
            throw new FinBizException(FinBizException.PERIODISNULL);
        }
        String factTempTable = JournalBalanceUtil.createJournalBalanceTable2((Timestamp)yearPeriod, (String)new Integer(unit.getValue()).toString(), (Set)this.bankIdSet, (Set)this.companyIdSet, (boolean)false, currencyIdList, (Context)ctx);
        factSql.append("select '1' as FYearId,");
        this.setSqlPrefixAndSuffix(factSql, factGroup);
        factSql.append(" sum(FSum*FConvertRate) as FSum from ").append(factTempTable).append(" where 1=1 ");
        this.setSqlFilter(factSql);
        factSql.append("\n group by ").append(factGroup);
        if (yearFrom != yearTo) {
            int nextFrom = yearFrom + 1;
            int spanInt = yearTo - yearFrom;
            int i = nextFrom;
            for (int k = 2; i <= yearTo && k <= spanInt + 1; ++i, ++k) {
                sql.setLength(0);
                factGroup.setLength(0);
                factSql.append("\n union all \n");
                sql.append(" select top 1 FEndDate from t_bd_period where fperiodyear = ").append(i).append("order by fperiodNumber desc");
                IRowSet rsPeriodSince = this.executeQuery(ctx, sql.toString(), null);
                Timestamp yearPeriodSince = this.getYearPeriod((ResultSet)rsPeriodSince);
                if (yearPeriodSince == null) {
                    throw new FinBizException(FinBizException.PERIODISNULL);
                }
                String factTempTableSince = JournalBalanceUtil.createJournalBalanceTable2((Timestamp)yearPeriodSince, (String)new Integer(unit.getValue()).toString(), (Set)this.bankIdSet, (Set)this.companyIdSet, (boolean)false, currencyIdList, (Context)ctx);
                factSql.append("select '").append(k).append("' as FYearId,");
                this.setSqlPrefixAndSuffix(factSql, factGroup);
                factSql.append(" sum(FSum*FConvertRate) as FSum from ").append(factTempTableSince).append(" where 1=1 ");
                this.setSqlFilter(factSql);
                factSql.append("\n group by ").append(factGroup);
            }
        }
        ss.setDataItem("Fact", factSql.toString(), null);
        if (this.forCompany) {
            configFile = "RptFinancingList_Company.xml";
            Object rsCompany = null;
            sql.setLength(0);
            sql.append("select com.FId,com.FName_").append(loc).append(" as FName, com.FParentID  from T_ORG_Company as com\n");
            ss.setDataItem("Company", sql.toString(), null);
            mdx.append("with member [Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Company].levels(0).members)'").append("\n member [Year].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Year].members)'").append("\n select [Year].members on columns,").append("\n non empty {[Company].members,[Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]} on rows ").append("\n from Fact");
        }
        if (this.forCurrency) {
            configFile = "RptFinancingList_Currency.xml";
            Object rsCurrency = null;
            sql.setLength(0);
            sql.append("select cur.FId,cur.FName_").append(loc).append(" as FName from T_BD_Currency as cur\n");
            ss.setDataItem("Currency", sql.toString(), null);
            mdx.append("with member [Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Currency].members)'").append("\n member [Year].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Year].members)'").append("\n select [Year].members on columns,").append("\n non empty {[Currency].members,[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]} on rows ").append("\n from Fact");
        }
        if (this.forBank) {
            String otherList;
            configFile = "RptFinancingList_Bank.xml";
            String tempBankTable = RptFinancingListFacadeControllerBean.getBankTempTable((Context)ctx);
            Object rsBank = null;
            SqlParams bankSp = new SqlParams();
            sql.setLength(0);
            sql.append(" select distinct A.FID, A.FName_" + loc + " FName,A.FParentID ").append("\n from ").append(tempBankTable).append(" A where 1=1 ");
            if (this.bankIdSet != null && this.bankIdSet.size() > 0) {
                sql.append("\n and A.Fid in(");
                sql.append(BirtUtils.idListToInClause((Collection)this.bankIdSet)).append(")");
            }
            if ((otherList = RptFmOtherItemUtil.buildSelectBank((SimpleTreeNode)bankTreeNode, (SimpleTreeNode)selectedBankTreeNode, (String)tempBankTable, (boolean)true, (String)"FID")) != null) {
                sql.append(otherList);
            }
            ss.setDataItem("Bank", sql.toString(), bankSp);
            mdx.append("with member [Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Bank].levels(0).members)'").append("\n member [Year].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Year].members)'").append("\n select [Year].members on columns,").append("\n non empty {[Bank].members,[Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]} on rows ").append("\n from Fact");
        }
        ss.setCaller(RptFinancingListFacadeControllerBean.class);
        ss.setFilename(configFile);
        ss.setMdx(mdx.toString());
        return ss;
    }

    private void setSqlPrefixAndSuffix(StringBuffer factSql, StringBuffer factGroup) {
        if (this.forCompany) {
            factSql.append("FCompanyID,");
            factGroup.append("FCompanyID");
        } else if (this.forBank) {
            factSql.append("FBankID,");
            factGroup.append("FBankID");
        } else if (this.forCurrency) {
            factSql.append("FCurrencyId,");
            factGroup.append("FCurrencyId");
        }
    }

    private void setSqlFilter(StringBuffer factSql) {
        if (this.companyIdSet != null && this.companyIdSet.size() > 0) {
            factSql.append("\n and FCompanyID in(");
            factSql.append(BirtUtils.idListToInClause((Collection)this.companyIdSet)).append(")");
        }
        if (this.bankIdSet != null && this.bankIdSet.size() > 0) {
            factSql.append("\n and FBankID in(");
            factSql.append(BirtUtils.idListToInClause((Collection)this.bankIdSet)).append(")");
        }
        if (this.currencyIdSet != null && this.currencyIdSet.size() > 0) {
            factSql.append("\n and FCurrencyId in(");
            factSql.append(BirtUtils.idListToInClause((Collection)this.currencyIdSet)).append(")");
        }
    }

    private Timestamp getYearPeriod(ResultSet rsPeriod) {
        Timestamp yearPeriod = null;
        try {
            while (rsPeriod.next()) {
                yearPeriod = rsPeriod.getTimestamp("FEndDate");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return yearPeriod;
    }

    protected CurrencyInfo getCurrencyInfo(String currencyId, Context ctx) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        ICurrency currency = CurrencyFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("*"));
        CurrencyInfo currencyInfo = null;
        try {
            currencyInfo = currency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId), sic);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return currencyInfo;
    }
}

