/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.util.RptFmOtherItemUtil;
import com.kingdee.eas.fm.mnt.app.AbstractRptLoanListFacadeControllerBean;
import com.kingdee.eas.fm.mnt.app.RptFinancingListFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.BirtUtils;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.bireport.util.SimpleTreeNode;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptLoanListFacadeControllerBean
extends AbstractRptLoanListFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mnt.app.RptLoanListFacadeControllerBean");
    Set companyIdSet;
    Set currencyIdSet;
    Set bankIdSet;
    Set inGroupIdSet;
    boolean forCompany;
    boolean forCurrency;
    boolean forBank;

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        SchemaSource ss = new SchemaSource();
        AmountUnitEnum kDUnit = (AmountUnitEnum)params.getObjectElement("kDUnit.value");
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        this.bankIdSet = (Set)params.getObject("bankIdSet");
        SimpleTreeNode bankTreeNode = (SimpleTreeNode)params.getObject("bankTree");
        SimpleTreeNode selectedBankTreeNode = (SimpleTreeNode)params.getObject("childBankTree");
        this.currencyIdSet = (Set)params.getObject("currencyIdSet");
        this.inGroupIdSet = (Set)params.getObject("inGroupIdSet");
        int yearFrom = (Integer)params.getObjectElement("yearFrom.value");
        int yearTo = (Integer)params.getObjectElement("yearTo.value");
        this.forCompany = (Boolean)params.getObjectElement("kDRadioButtonCompany.value");
        this.forCurrency = (Boolean)params.getObjectElement("kDRadioButtonCurrency.value");
        this.forBank = (Boolean)params.getObjectElement("kDRadioButtonBank.value");
        StringBuffer factSql = new StringBuffer();
        StringBuffer factGroup = new StringBuffer();
        StringBuffer mdx = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        String configFile = "";
        String loc = RptLoanListFacadeControllerBean.getLoc((Context)ctx);
        Object rsYear = null;
        sql.setLength(0);
        sql.append(" select '1' as fid,'").append(yearFrom).append("' as fname");
        if (yearFrom != yearTo) {
            int nextFrom = yearFrom + 1;
            int spanInt = yearTo - yearFrom;
            int i = nextFrom;
            for (int k = 2; i <= yearTo && k <= spanInt + 1; ++i, ++k) {
                sql.append("\n union select '").append(k).append("' as fid,'").append(i).append("' as fname");
            }
        }
        ss.setDataItem("Year", sql.toString(), null);
        Object rsFact = null;
        SqlParams sp = new SqlParams();
        factSql.setLength(0);
        factSql.append("select '1' as FYearId,").append(this.getSelectedField()).append(",sum(A.FBaLance + isnull(B.FAmount,0))/").append(kDUnit.getValue()).append(" as FBalanceAmount from (select FID,").append(this.getSelectedField()).append(",FBaLance*FLocalCurExRate  as FBaLance from t_fin_loan ").append(" where FIssueDate<=? ");
        GregorianCalendar gCalendar = new GregorianCalendar(yearFrom, 11, 31, 23, 59, 59);
        sp.addTimestamp(new Timestamp(gCalendar.getTimeInMillis()));
        this.setSqlFilter(factSql);
        factSql.append(" ) A left outer join (select Fsourcebillid ,sum(FAmount*FLocalCurExRate) FAmount from t_fin_repayment ").append(" where FBizDate > ? group by Fsourcebillid) B on A.FID = B.Fsourcebillid group by ").append(this.getSelectedField());
        sp.addTimestamp(new Timestamp(gCalendar.getTimeInMillis()));
        if (yearFrom != yearTo) {
            int nextFrom = yearFrom + 1;
            int spanInt = yearTo - yearFrom;
            int i = nextFrom;
            for (int k = 2; i <= yearTo && k <= spanInt + 1; ++i, ++k) {
                factGroup.setLength(0);
                factSql.append("\n union all \n");
                factSql.append("select '").append(k).append("' as FYearId,").append(this.getSelectedField()).append(",sum(A.FBaLance + isnull(B.FAmount,0))/").append(kDUnit.getValue()).append(" as FBalanceAmount from (select FID,").append(this.getSelectedField()).append(", FBaLance*FLocalCurExRate  as FBaLance from t_fin_loan ").append(" where FIssueDate<=? ");
                gCalendar.set(1, i);
                sp.addTimestamp(new Timestamp(gCalendar.getTimeInMillis()));
                this.setSqlFilter(factSql);
                factSql.append(" ) A left outer join (select Fsourcebillid ,sum(FAmount*FLocalCurExRate) FAmount from t_fin_repayment ").append(" where FBizDate > ? group by Fsourcebillid) B on A.FID = B.Fsourcebillid group by ").append(this.getSelectedField());
                sp.addTimestamp(new Timestamp(gCalendar.getTimeInMillis()));
            }
        }
        ss.setDataItem("Fact", factSql.toString(), sp);
        if (this.forCompany) {
            configFile = "RptLoanList_Company.xml";
            Object rsCompany = null;
            sql.setLength(0);
            sql.append("select com.FId,com.FName_").append(loc).append(" as FName, com.FParentID  from T_ORG_Company as com where 1=1 \n");
            if (this.companyIdSet != null && this.companyIdSet.size() > 0) {
                sql.append("\n and Fid in(");
                sql.append(BirtUtils.idListToInClause((Collection)this.companyIdSet)).append(")");
            }
            ss.setDataItem("Company", sql.toString(), null);
            mdx.append("\n select [Year].members on columns,").append(" non empty {company.members} on rows from Fact ");
        }
        if (this.forCurrency) {
            configFile = "RptLoanList_Currency.xml";
            Object rsCurrency = null;
            sql.setLength(0);
            sql.append("select cur.FId,cur.FName_").append(loc).append(" as FName from T_BD_Currency as cur\n");
            ss.setDataItem("Currency", sql.toString(), null);
            mdx.append(" with member [Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Currency].members)'").append("\n select [Year].members on columns,").append(" non empty {{currency.members},{[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}} on rows from Fact ");
        }
        if (this.forBank) {
            String otherList;
            configFile = "RptLoanList_Bank.xml";
            String tempBankTable = RptLoanListFacadeControllerBean.getBankTempTable((Context)ctx);
            Object rsBank = null;
            SqlParams bankSp = new SqlParams();
            sql.setLength(0);
            sql.append(" select distinct A.FID, A.FName_" + loc + " FName,A.FParentID ").append("\n from ").append(tempBankTable).append(" A where 1=1 ");
            if (this.bankIdSet != null && this.bankIdSet.size() > 0) {
                sql.append("\n and A.Fid in(");
                sql.append(BirtUtils.idListToInClause((Collection)this.bankIdSet)).append(")");
            }
            if ((otherList = RptFmOtherItemUtil.buildSelectBank((SimpleTreeNode)bankTreeNode, (SimpleTreeNode)selectedBankTreeNode, (String)tempBankTable, (boolean)true, (String)"FID")) != null) {
                sql.append(otherList);
            }
            ss.setDataItem("Bank", sql.toString(), bankSp);
            mdx.append(" with member [Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Bank].levels(0).members)'").append("\n select [Year].members on columns,").append(" non empty {{bank.members},[Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]} on rows from Fact ");
        }
        ss.setCaller(RptFinancingListFacadeControllerBean.class);
        ss.setFilename(configFile);
        ss.setMdx(mdx.toString());
        return ss;
    }

    private String getSelectedField() {
        String selectedField = null;
        if (this.forCompany) {
            selectedField = new String("FCompanyID");
        } else if (this.forBank) {
            selectedField = new String("FInstitutionId");
        } else if (this.forCurrency) {
            selectedField = new String("FCurrencyId");
        }
        return selectedField;
    }

    private void setSqlFilter(StringBuffer factSql) {
        if (this.companyIdSet != null && this.companyIdSet.size() > 0) {
            factSql.append("\n and FCompanyID in(");
            factSql.append(BirtUtils.idListToInClause((Collection)this.companyIdSet)).append(")");
        }
        if (this.bankIdSet != null && this.bankIdSet.size() > 0) {
            factSql.append("\n and (");
            factSql.append("( FInstitutionId in(");
            factSql.append(BirtUtils.idListToInClause((Collection)this.bankIdSet)).append(")").append(")");
            if (this.inGroupIdSet != null && this.inGroupIdSet.size() > 0) {
                factSql.append(" or ");
                factSql.append(" ( FIsGroupLoan = 1 ) ");
            }
            factSql.append(")");
        } else if (this.inGroupIdSet == null || this.inGroupIdSet.size() <= 0) {
            factSql.append("\n and FIsGroupLoan = 0  ");
        }
        if (this.currencyIdSet != null && this.currencyIdSet.size() > 0) {
            factSql.append("\n and FCurrencyId in(");
            factSql.append(BirtUtils.idListToInClause((Collection)this.currencyIdSet)).append(")");
        }
    }

    private Timestamp getYearPeriod(ResultSet rsPeriod) {
        Timestamp yearPeriod = null;
        try {
            while (rsPeriod.next()) {
                yearPeriod = rsPeriod.getTimestamp("FEndDate");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return yearPeriod;
    }
}

