/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.BankAreaTypeEnum;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.FMParamUtil;
import com.kingdee.eas.fm.common.util.JournalBalanceUtil;
import com.kingdee.eas.fm.mnt.MNTException;
import com.kingdee.eas.fm.mnt.app.AbstractRptUsableFundFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.bireport.app.BireportBaseFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptUsableFundFacadeControllerBean
extends AbstractRptUsableFundFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.RptUsableFundFacadeControllerBean");

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        SqlParams sp1;
        String loc = RptUsableFundFacadeControllerBean.getLoc((Context)ctx);
        SchemaSource ss = new SchemaSource();
        ss.setCaller(RptUsableFundFacadeControllerBean.class);
        String amountUnit = String.valueOf(((AmountUnitEnum)params.getObjectElement("jtAmountUnit.value")).getValue());
        Set bankIdSet = (Set)params.getObject("bankIdSet");
        Set companyIdSet = (Set)params.getObject("companyIdSet");
        boolean forCompany = (Boolean)params.getObjectElement("jrbCompany.value");
        boolean forBank = (Boolean)params.getObjectElement("jrbBank.value");
        boolean ckInnerAmt = (Boolean)params.getObjectElement("ckinnerAmt.value");
        Timestamp ts = new Timestamp(((Date)params.getObjectElement("jdTo.value")).getTime());
        Set rateCurrencyIdSet = (Set)params.getObject("RateCurrencySet");
        StringBuffer sql = new StringBuffer();
        SqlParams sp = new SqlParams();
        String factTempTable = JournalBalanceUtil.createJournalBalanceTable2((Timestamp)ts, (String)amountUnit, (Set)bankIdSet, (Set)companyIdSet, (boolean)false, new ArrayList(), (Context)ctx);
        boolean isRateCurrency = rateCurrencyIdSet != null && rateCurrencyIdSet.size() > 0;
        String temptable = "";
        if (isRateCurrency) {
            temptable = this.buildFactTempTable(ctx);
        }
        sql.setLength(0);
        sp.clear();
        if (forCompany || forBank) {
            // empty if block
        }
        sql.append(this.getFactSql(new StringBuffer(""), forCompany, forBank, amountUnit, factTempTable, companyIdSet, sp, bankIdSet, temptable, ts, ts, isRateCurrency, ckInnerAmt));
        String factSql2 = this.getFactSql(new StringBuffer(""), forCompany, forBank, amountUnit, factTempTable, companyIdSet, new SqlParams(), bankIdSet, temptable, ts, ts, false, true);
        if (isRateCurrency) {
            HashSet<String> currencyIdSet = new HashSet<String>();
            StringBuffer currencySql = new StringBuffer();
            currencySql.append("select distinct FCurrencyID from (").append(factSql2.toString()).append(") t");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)currencySql.toString(), (Object[])sp.getParams());
                while (rs.next()) {
                    currencyIdSet.add(rs.getString("FCurrencyID"));
                }
            }
            catch (SQLException rs) {
                // empty catch block
            }
            Iterator it = currencyIdSet.iterator();
            String locCurrencyId = (String)rateCurrencyIdSet.iterator().next();
            CurrencyInfo locCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(locCurrencyId));
            CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            String currencyStr = "";
            while (it.hasNext()) {
                String currencyid = (String)it.next();
                BigDecimal rate = null;
                if (currencyid.equals(locCurrencyId)) {
                    rate = Constants.ONE;
                } else {
                    CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyid));
                    ExchangeRateInfo rateInfo = FMHelper.getExRateInfo((Context)ctx, (CurrencyInfo)currency, (CurrencyInfo)locCurrency, (CompanyOrgUnitInfo)company, (Date)ts);
                    if (EmptyUtil.isEmpty((CoreBaseInfo)rateInfo)) {
                        currencyStr = currencyStr + "," + currency.getName();
                    } else {
                        rate = ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)rateInfo.getConvertMode()) ? Constants.ONE.divide(rateInfo.getConvertRate(), 20, 4) : rateInfo.getConvertRate();
                    }
                }
                String insertCurrencySql = "insert into " + temptable + " values('" + currencyid + "', " + rate + ")";
                DbUtil.execute((Context)ctx, (String)insertCurrencySql);
            }
            if (currencyStr.length() > 0) {
                throw new MNTException(MNTException.EXCEPTIONEXHANGERATE, new Object[]{currencyStr.substring(1), locCurrency.getName()});
            }
        }
        StringBuffer factSql = new StringBuffer();
        factSql.append("select FRegionType,FCurrencyID,").append(forCompany ? "FCompanyID," : "").append(forBank ? "FBankID," : "").append("sum(FBalance) FBalance, sum(FLimited)/" + amountUnit + " FLimited, sum(FUsable)/" + amountUnit + " FUsable, sum(FOriginal)/" + amountUnit + " FOriginal");
        factSql.append(", sum(FLocal)/" + amountUnit + " FLocal");
        factSql.append("\n from (\n").append(sql.toString()).append("\n ) TEMP");
        factSql.append("\n group by TEMP.FRegionType,TEMP.FCurrencyID").append(forCompany ? ",TEMP.FCompanyID" : "").append(forBank ? ",TEMP.FBankID" : "");
        ss.setDataItem("Fact", factSql.toString(), sp);
        sql.setLength(0);
        sql.append("select 1 as fid, '" + BankAreaTypeEnum.In.getAlias() + "' as fname ").append("\n union all").append("\n select 2 as fid, '" + BankAreaTypeEnum.Out.getAlias() + "' as fname ").append("\n union all").append("\n select 3 as fid, '" + BankAreaTypeEnum.GAT.getAlias() + "' as fname ");
        ss.setDataItem("RegionType", sql.toString(), null);
        sql.setLength(0);
        sql.append(" select A.FID, A.FNumber, A.FName_" + loc + " FName from t_bd_currency A where FID!='" + CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID + "' and FID!='" + CurrencyInfo.GENERAL_REPORT_CURRENCY_ID + "'");
        ss.setDataItem("Currency", sql.toString(), null);
        if (forCompany) {
            ss.setFilename("RptUsableFund_company.xml");
            sql.setLength(0);
            sp1 = new SqlParams();
            sql.append(" select A.FID, A.FNumber, A.FName_" + loc + " FName, A.FParentID from t_org_company  A \n where 1=1 ");
            JournalBalanceUtil.appendFilter((String)"A.FID", (Set)companyIdSet, (StringBuffer)sql, (SqlParams)sp1, (String)"and");
            ss.setDataItem("Company", sql.toString(), sp1);
        } else if (forBank) {
            ss.setFilename("RptUsableFund_bank.xml");
            sql.setLength(0);
            sp1 = new SqlParams();
            sql.append(" select A.FID, A.FName_" + loc + " FName,A.FParentID from t_bd_bank A where 1=1");
            JournalBalanceUtil.appendFilter((String)"A.FID", (Set)bankIdSet, (StringBuffer)sql, (SqlParams)sp1, (String)"and");
            ss.setDataItem("Bank", sql.toString(), sp1);
        } else {
            ss.setFilename("RptUsableFund_currency.xml");
        }
        String paramValue = FMParamUtil.getParamValue((Context)ctx, (String)"MNT001");
        StringBuffer mdx = new StringBuffer();
        mdx.append(" with member [Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"xiaoji", (Locale)ctx.getLocale())).append("] as 'iif(measures.currentmember.name=\"FLocal\",sum([Currency].members),null)'");
        if (forCompany) {
            mdx.append(" member [Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"xiaoji", (Locale)ctx.getLocale())).append("] as 'sum([Company].levels(0).members)'");
            mdx.append("select [Measures].members on columns,");
            if ("1".equals(paramValue)) {
                mdx.append("\n non empty hierarchize(union({[RegionType].members*[Company].members*[Currency].members},[RegionType].members*{[Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"xiaoji", (Locale)ctx.getLocale())).append("]}*{[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"xiaoji", (Locale)ctx.getLocale())).append("]})) on rows").append("\n from fm");
            } else {
                mdx.append("\n non empty hierarchize(union({[RegionType].members*[Company].levels(0).members*[Currency].members},[RegionType].members*{[Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"xiaoji", (Locale)ctx.getLocale())).append("]}*{[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"xiaoji", (Locale)ctx.getLocale())).append("]})) on rows").append("\n from fm");
            }
        } else if (forBank) {
            mdx.append(" member [Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"xiaoji", (Locale)ctx.getLocale())).append("] as 'sum([Bank].levels(0).members)'");
            mdx.append("select [Measures].members on columns,");
            if ("1".equals(paramValue)) {
                mdx.append("\n non empty hierarchize(union({[RegionType].members*[Bank].members*[Currency].members},[RegionType].members*{[Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"xiaoji", (Locale)ctx.getLocale())).append("]}*{[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"xiaoji", (Locale)ctx.getLocale())).append("]})) on rows").append("\n from fm");
            } else {
                mdx.append("\n non empty hierarchize(union({[RegionType].members*[Bank].levels(0).members*[Currency].members},[RegionType].members*{[Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"xiaoji", (Locale)ctx.getLocale())).append("]}*{[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"xiaoji", (Locale)ctx.getLocale())).append("]})) on rows").append("\n from fm");
            }
        } else {
            mdx.append("\n select [Measures].members on columns,").append("\n non empty hierarchize(union({[RegionType].members*[Currency].members},[RegionType].members*{[Currency].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"xiaoji", (Locale)ctx.getLocale())).append("]})) on rows").append("\n from fm");
        }
        ss.setMdx(mdx.toString());
        return ss;
    }

    private String getFactSql(StringBuffer sql, boolean forCompany, boolean forBank, String amountUnit, Object factTempTable, Set companyIdSet, SqlParams sp, Set bankIdSet, String temptable, Timestamp ts2, Timestamp ts, boolean isRateCurrency, boolean ckInnerAmt) {
        sql.append("select 1 as No, A.FBankAreaType FRegionType, C.FCurrencyID, ").append(forCompany ? "C.FCompanyID," : "").append(forBank ? "A.FID FBankID," : "").append("sum(isNull(C.FSum,0)) FBalance,").append("0 FUsable,").append("0 FLimited,").append("sum(isNull(C.FSum,0))*" + amountUnit + " FOriginal,");
        if (isRateCurrency) {
            sql.append("sum(isNull(C.FSum,0))*FRate*" + amountUnit + " FLocal");
        } else {
            sql.append("sum(isNull(C.FSum,0))*isNull(C.FConvertRate,1)*" + amountUnit + " FLocal");
        }
        sql.append("\n from T_BD_BANK A").append("\n , ").append(factTempTable + " C");
        if (isRateCurrency) {
            sql.append(" left join " + temptable + " on " + temptable + ".FRateCurrencyID = C.FCurrencyID ");
        }
        sql.append("\n where C.FBankID=A.FID ");
        if (!ckInnerAmt) {
            sql.append("\n and A.FIsInGroup = 0 ");
        }
        if (forCompany) {
            JournalBalanceUtil.appendFilter((String)"C.FCompanyID", (Set)companyIdSet, (StringBuffer)sql, (SqlParams)sp, (String)"and");
        }
        JournalBalanceUtil.appendFilter((String)"A.FID", (Set)bankIdSet, (StringBuffer)sql, (SqlParams)sp, (String)"and");
        sql.append("\n group by A.FBankAreaType, C.FCurrencyID").append(forCompany ? ",C.FCompanyID" : "").append(forBank ? ",A.FID" : "").append(isRateCurrency ? ",FRate" : ",C.FConvertRate");
        sql.append("\n union all \n").append("select 2 as No, A.FBankAreaType FRegionType, C.FCurrencyID, ").append(forCompany ? "C.FCompanyID," : "").append(forBank ? "A.FID FBankID," : "").append("0 FBalance,").append("sum(isNull(C.FBalance,0)) FUsable,").append("0 FLimited,").append("sum(isNull(C.FBalance,0)) FOriginal,");
        if (isRateCurrency) {
            sql.append("sum(isNull(C.FBalance,0))*FRate FLocal");
        } else {
            sql.append("sum(isNull(C.FBalance,0))*isNull(C.FExchangeRate,1) FLocal");
        }
        sql.append("\n from T_BD_BANK A").append("\n inner join t_fin_CreditLimit C on C.FCreditInstitutionId=A.FID and C.FRegion=A.FBankAreaType");
        if (isRateCurrency) {
            sql.append(" left join " + temptable + " on " + temptable + ".FRateCurrencyID = C.FCurrencyID ");
        }
        sql.append("\n where C.Fissuedate<=? and C.Fexpireddate>=? and C.FIsClosed=0");
        sp.addTimestamp(ts).addTimestamp(ts2);
        if (!ckInnerAmt) {
            sql.append("\n and A.FIsInGroup = 0 ");
        }
        JournalBalanceUtil.appendFilter((String)"C.FCompanyID", (Set)companyIdSet, (StringBuffer)sql, (SqlParams)sp, (String)"and");
        JournalBalanceUtil.appendFilter((String)"A.FID", (Set)bankIdSet, (StringBuffer)sql, (SqlParams)sp, (String)"and");
        sql.append("\n group by A.FBankAreaType, C.FCurrencyID").append(forCompany ? ",C.FCompanyID" : "").append(forBank ? ",A.FID" : "").append(isRateCurrency ? ",FRate" : ", C.FExchangeRate");
        sql.append("\n union all \n").append("select 3 as No, A.FBankAreaType FRegionType, C.FCurrencyID, ").append(forCompany ? "C.FCompanyID," : "").append(forBank ? "A.FID FBankID," : "").append("0 FBalance,").append("0 FUsable,").append("sum(isNull(C.FAmount,0))  FLimited,").append("-1*sum(isNull(C.FAmount,0)) FOriginal,");
        if (isRateCurrency) {
            sql.append("-1*sum(isNull(C.FAmount,0))*FRate FLocal");
        } else {
            sql.append("-1*sum(isNull(C.FAmount,0))*isNull(C.FExchageRate,1) FLocal");
        }
        sql.append("\n from T_BD_BANK A").append("\n inner join T_BD_AccountBanks B on B.FBank=A.FID").append("\n inner join T_MNT_DepositInControl C on C.FBankID=A.FID and C.FRegion=A.FBankAreaType and C.FCompanyID=B.FCompanyID and C.FBankAcctID=B.FID");
        if (isRateCurrency) {
            sql.append(" left join " + temptable + " on " + temptable + ".FRateCurrencyID = C.FCurrencyID ");
        }
        sql.append("\n where C.FBeginDate<=? and C.FEndDate>=? ");
        sp.addTimestamp(ts).addTimestamp(ts);
        JournalBalanceUtil.appendFilter((String)"C.FCompanyID", (Set)companyIdSet, (StringBuffer)sql, (SqlParams)sp, (String)"and");
        JournalBalanceUtil.appendFilter((String)"A.FID", (Set)bankIdSet, (StringBuffer)sql, (SqlParams)sp, (String)"and");
        if (!ckInnerAmt) {
            sql.append("\n and A.FIsInGroup = 0 ");
        }
        sql.append("\n group by A.FBankAreaType, C.FCurrencyID").append(isRateCurrency ? ",FRate" : ", C.FExchageRate").append(forCompany ? ",C.FCompanyID" : "").append(forBank ? ",A.FID" : "");
        return sql.toString();
    }

    private String buildFactTempTable(Context ctx) throws BOSException {
        String sSQL = "if not exists (select * from KSQL_USERTABLES where KSQL_COL_TABNAME='T_Temp_RptLoanStruanalyse') Create Table T_Temp_RptLoanStruanalyse (FRateCurrencyId Varchar(44), FRate NUMERIC(17,8) DEFAULT 0);";
        DbUtil.execute((Context)ctx, (String)sSQL);
        sSQL = "Delete From T_Temp_RptLoanStruanalyse";
        DbUtil.execute((Context)ctx, (String)sSQL);
        return "T_Temp_RptLoanStruanalyse";
    }

    private static String getTempTableSql(Context ctx, String sql, SqlParams sp, String tempTableName) throws BOSException {
        String tempBankTablefact = BireportBaseFacadeControllerBean.getTempTableName((String)tempTableName, (Context)ctx);
        StringBuffer baseSqlfact = new StringBuffer();
        baseSqlfact.append("Select * into ").append(tempBankTablefact).append(" from ( ").append(sql).append(" ) as tt");
        BireportBaseFacadeControllerBean.executeSelectInto((String)baseSqlfact.toString(), (SqlParams)sp, (Context)ctx);
        String newSql = "select * from " + tempBankTablefact;
        return newSql;
    }
}

