/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AgentPayBillCollection;
import com.kingdee.eas.fi.cas.AgentPayBillEntryCollection;
import com.kingdee.eas.fi.cas.AgentPayBillEntryInfo;
import com.kingdee.eas.fi.cas.AgentPayBillFactory;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fm.mnt.BizBype;
import com.kingdee.eas.fm.mnt.DcDirection;
import com.kingdee.eas.fm.mnt.FundFlowDayReportInfo;
import com.kingdee.eas.fm.mnt.SourBillType;
import com.kingdee.eas.fm.mnt.app.service.IFundFlowDayReportBuilder;
import com.kingdee.eas.fm.mnt.utils.MNTUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AgentPay2DayReportBuilderImpl
implements IFundFlowDayReportBuilder {
    @Override
    public CoreBaseCollection getFundFlowDayReportColl(Context ctx, Map<String, List<String>> aliasMap, Date beginDate, Date endDate) throws BOSException, EASBizException {
        CoreBaseCollection destColls = new CoreBaseCollection();
        Set<String> companyIds = aliasMap.keySet();
        AgentPayBillCollection srcColls = this.getAgentPayBillColl(ctx, companyIds, beginDate, endDate);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)srcColls)) {
            Map<String, FundFlowItemInfo> matchMap = MNTUtils.getFlowItemMatchMap(ctx, companyIds, BizBype.agentPay.getValue());
            for (int i = 0; i < srcColls.size(); ++i) {
                AgentPayBillInfo srcInfo = srcColls.get(i);
                AgentPayBillEntryCollection entryColls = srcInfo.getEntrys();
                for (int j = 0; j < entryColls.size(); ++j) {
                    AgentPayBillEntryInfo entry = entryColls.get(j);
                    FundFlowDayReportInfo destInfo = this.convertReportInfo(ctx, srcInfo, entry, matchMap, aliasMap);
                    destColls.add((CoreBaseInfo)destInfo);
                    ArrayList<String> srcIdList = new ArrayList<String>();
                    srcIdList.add(srcInfo.getId().toString());
                    BOTPUtil.saveBOTRelation((Context)ctx, srcIdList, (String)destInfo.getId().toString());
                }
            }
        }
        return destColls;
    }

    private FundFlowDayReportInfo convertReportInfo(Context ctx, AgentPayBillInfo srcInfo, AgentPayBillEntryInfo entry, Map<String, FundFlowItemInfo> matchMap, Map<String, List<String>> aliasMap) throws EASBizException, BOSException {
        FundFlowDayReportInfo destInfo = new FundFlowDayReportInfo();
        destInfo.setId(BOSUuid.create((BOSObjectType)destInfo.getBOSType()));
        destInfo.setSourceBillId(srcInfo.getId().toString());
        destInfo.setSourceBillEntryId(entry.getId().toString());
        destInfo.setCompany(srcInfo.getCompany());
        String number = MNTUtils.getNumberRule(ctx, (IObjectValue)destInfo, srcInfo.getCompany().getId().toString());
        if (number != null) {
            destInfo.setNumber(number);
        } else {
            destInfo.setNumber(srcInfo.getNumber());
        }
        Date currentDate = DateTimeUtils.truncateDate((Date)new Date());
        destInfo.setBizDate(currentDate);
        destInfo.setAccountBank(srcInfo.getPayBankAccount());
        destInfo.setCurrency(srcInfo.getCurrency());
        destInfo.setBizTime(srcInfo.getBizDate());
        destInfo.setDebitAmt(BigDecimal.ZERO);
        destInfo.setCreditAmt(entry.getAmount());
        destInfo.setReceiveDate(currentDate);
        destInfo.setIsByManual(false);
        destInfo.setBizType(BizBype.agentPay);
        destInfo.setSourceBillType(SourBillType.agentPayBill);
        destInfo.setDcDirection(DcDirection.credit);
        destInfo.setOppBankAcctNum(entry.getRecBankAccount());
        destInfo.setOppBankName(entry.getRecBankName());
        AccountBankInfo acctBankInfo = this.getAccountBank(ctx, entry.getRecBankAccount());
        if (acctBankInfo != null) {
            destInfo.setOppBankAcct(acctBankInfo);
            destInfo.setOppBankInfo(acctBankInfo.getBank());
        }
        destInfo.setOppCompanyStr(entry.getRecName());
        destInfo.setDescription(srcInfo.getDescription());
        AsstActTypeInfo asstType = new AsstActTypeInfo();
        asstType.setId(BOSUuid.read((String)"YW3xsAEJEADgAAWgwKgTB0c4VZA="));
        destInfo.setOppCompanyType(asstType);
        destInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        destInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        if (entry.getFundFlowItem() != null) {
            destInfo.setFundFlowItem(entry.getFundFlowItem());
        } else if (srcInfo.getFundFlowItem() != null) {
            destInfo.setFundFlowItem(srcInfo.getFundFlowItem());
        }
        if (destInfo.getFundFlowItem() == null && matchMap != null && destInfo.getAccountBank() != null) {
            String key = destInfo.getCompany().getId().toString() + destInfo.getBizType().getValue() + destInfo.getAccountBank().getId().toString();
            destInfo.setFundFlowItem(matchMap.get(key));
        }
        return destInfo;
    }

    private AccountBankInfo getAccountBank(Context ctx, String accountNumber) throws BOSException {
        AccountBankInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bank.*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)accountNumber, CompareType.EQUALS));
        view.setFilter(filter);
        AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    private AgentPayBillCollection getAgentPayBillColl(Context ctx, Set<String> companyIds, Date beginDate, Date endDate) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("PayBankAccount.*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.fundFlowItem.*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", companyIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)15));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)endDate, CompareType.LESS_EQUALS));
        view.setFilter(filter);
        return AgentPayBillFactory.getLocalInstance((Context)ctx).getAgentPayBillCollection(view);
    }
}

