/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.mnt.BizBype;
import com.kingdee.eas.fm.mnt.DcDirection;
import com.kingdee.eas.fm.mnt.FundFlowDayReportInfo;
import com.kingdee.eas.fm.mnt.SourBillType;
import com.kingdee.eas.fm.mnt.app.service.IFundFlowDayReportBuilder;
import com.kingdee.eas.fm.mnt.utils.MNTUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Payment2DayReportBuilderImpl
implements IFundFlowDayReportBuilder {
    @Override
    public CoreBaseCollection getFundFlowDayReportColl(Context ctx, Map<String, List<String>> aliasMap, Date beginDate, Date endDate) throws BOSException, EASBizException {
        CoreBaseCollection destColls = new CoreBaseCollection();
        Set<String> companyIds = aliasMap.keySet();
        PaymentBillCollection srcColls = this.getPaymentBillColl(ctx, companyIds, beginDate, endDate);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)srcColls)) {
            Map<String, FundFlowItemInfo> matchMap = MNTUtils.getFlowItemMatchMap(ctx, companyIds, BizBype.payment.getValue());
            for (int i = 0; i < srcColls.size(); ++i) {
                PaymentBillInfo srcInfo = srcColls.get(i);
                PaymentBillEntryCollection entryColls = srcInfo.getEntries();
                for (int j = 0; j < entryColls.size(); ++j) {
                    PaymentBillEntryInfo entry = entryColls.get(j);
                    FundFlowDayReportInfo destInfo = this.convertReportInfo(ctx, srcInfo, entry, matchMap, aliasMap);
                    destColls.add((CoreBaseInfo)destInfo);
                    ArrayList<String> srcIdList = new ArrayList<String>();
                    srcIdList.add(srcInfo.getId().toString());
                    BOTPUtil.saveBOTRelation((Context)ctx, srcIdList, (String)destInfo.getId().toString());
                }
            }
        }
        return destColls;
    }

    private FundFlowDayReportInfo convertReportInfo(Context ctx, PaymentBillInfo srcInfo, PaymentBillEntryInfo entry, Map<String, FundFlowItemInfo> matchMap, Map<String, List<String>> aliasMap) throws EASBizException, BOSException {
        FundFlowDayReportInfo destInfo = new FundFlowDayReportInfo();
        destInfo.setId(BOSUuid.create((BOSObjectType)destInfo.getBOSType()));
        destInfo.setSourceBillId(srcInfo.getId().toString());
        destInfo.setSourceBillEntryId(entry.getId().toString());
        destInfo.setCompany(srcInfo.getCompany());
        String number = MNTUtils.getNumberRule(ctx, (IObjectValue)destInfo, srcInfo.getCompany().getId().toString());
        if (number != null) {
            destInfo.setNumber(number);
        } else {
            destInfo.setNumber(srcInfo.getNumber());
        }
        Date currentDate = DateTimeUtils.truncateDate((Date)new Date());
        destInfo.setBizDate(currentDate);
        destInfo.setAccountBank(srcInfo.getPayerAccountBank());
        destInfo.setCurrency(srcInfo.getCurrency());
        destInfo.setBizTime(srcInfo.getBizDate());
        destInfo.setDebitAmt(BigDecimal.ZERO);
        destInfo.setCreditAmt(entry.getActualAmt());
        destInfo.setReceiveDate(currentDate);
        destInfo.setIsByManual(false);
        destInfo.setBizType(BizBype.payment);
        destInfo.setSourceBillType(SourBillType.paymentBill);
        destInfo.setDcDirection(DcDirection.credit);
        destInfo.setOppBankAcctNum(srcInfo.getPayeeAccountBank());
        destInfo.setOppBankName(srcInfo.getPayeeBank());
        if (srcInfo.getPayeeAccountBankO() != null) {
            destInfo.setOppBankAcct(srcInfo.getPayeeAccountBankO());
            destInfo.setOppBankInfo(srcInfo.getPayeeAccountBankO().getBank());
        } else {
            AccountBankInfo acctBankInfo = this.getAccountBank(ctx, srcInfo.getPayeeAccountBank());
            if (acctBankInfo != null) {
                destInfo.setOppBankAcct(acctBankInfo);
                destInfo.setOppBankInfo(acctBankInfo.getBank());
            }
        }
        destInfo.setOppCompanyStr(srcInfo.getPayeeName());
        destInfo.setOppCompanyOrg(MNTUtils.getCompany(ctx, srcInfo.getPayeeName(), aliasMap));
        destInfo.setDescription(srcInfo.getDescription());
        destInfo.setOppCompanyType(srcInfo.getPayeeType());
        destInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        destInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        if (entry.getFundFlowItem() != null) {
            destInfo.setFundFlowItem(entry.getFundFlowItem());
        } else if (srcInfo.getFundFlowItem() != null) {
            destInfo.setFundFlowItem(srcInfo.getFundFlowItem());
        }
        if (destInfo.getFundFlowItem() == null && matchMap != null && destInfo.getAccountBank() != null) {
            String key = destInfo.getCompany().getId().toString() + destInfo.getBizType().getValue() + destInfo.getAccountBank().getId().toString();
            destInfo.setFundFlowItem(matchMap.get(key));
        }
        return destInfo;
    }

    private AccountBankInfo getAccountBank(Context ctx, String accountNumber) throws BOSException {
        AccountBankInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bank.*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)accountNumber, CompareType.EQUALS));
        view.setFilter(filter);
        AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    private PaymentBillCollection getPaymentBillColl(Context ctx, Set<String> companyIds, Date beginDate, Date endDate) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("payerAccountBank.*"));
        sic.add(new SelectorItemInfo("payeeAccountBankO.bank.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.fundFlowItem.*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", companyIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)15));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)endDate, CompareType.LESS_EQUALS));
        view.setFilter(filter);
        return PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(view);
    }
}

