/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fm.be.BizTypeEnum;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.mnt.BizBype;
import com.kingdee.eas.fm.mnt.DcDirection;
import com.kingdee.eas.fm.mnt.FundFlowDayReportInfo;
import com.kingdee.eas.fm.mnt.SourBillType;
import com.kingdee.eas.fm.mnt.app.service.IFundFlowDayReportBuilder;
import com.kingdee.eas.fm.mnt.utils.MNTUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransDetail2DayReportBuilderImpl
implements IFundFlowDayReportBuilder {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mnt.app.service.TransDetail2DayReportBuilderImpl");
    private Map<String, CompanyOrgUnitInfo> orgCache = null;

    @Override
    public CoreBaseCollection getFundFlowDayReportColl(Context ctx, Map<String, List<String>> aliasMap, Date beginDate, Date endDate) throws BOSException, EASBizException {
        CoreBaseCollection destColls = new CoreBaseCollection();
        Set<String> companyIds = aliasMap.keySet();
        TransDetailCollection srcColls = this.getTransDetailColl(ctx, companyIds, beginDate, endDate);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)srcColls)) {
            Map<String, FundFlowItemInfo> matchMap = MNTUtils.getFlowItemMatchMap(ctx, companyIds, "-2");
            if (this.orgCache == null) {
                this.orgCache = new HashMap<String, CompanyOrgUnitInfo>();
            }
            for (int i = 0; i < srcColls.size(); ++i) {
                TransDetailInfo srcInfo = srcColls.get(i);
                FundFlowDayReportInfo destInfo = this.convertReportInfo(ctx, srcInfo, matchMap, aliasMap);
                destColls.add((CoreBaseInfo)destInfo);
                ArrayList<String> srcIdList = new ArrayList<String>();
                srcIdList.add(srcInfo.getId().toString());
                BOTPUtil.saveBOTRelation((Context)ctx, srcIdList, (String)destInfo.getId().toString());
            }
        }
        return destColls;
    }

    private FundFlowDayReportInfo convertReportInfo(Context ctx, TransDetailInfo srcInfo, Map<String, FundFlowItemInfo> matchMap, Map<String, List<String>> aliasMap) throws EASBizException, BOSException {
        FundFlowDayReportInfo destInfo = new FundFlowDayReportInfo();
        destInfo.setId(BOSUuid.create((BOSObjectType)destInfo.getBOSType()));
        destInfo.setSourceBillId(srcInfo.getId().toString());
        destInfo.setCompany(srcInfo.getCompany());
        String number = MNTUtils.getNumberRule(ctx, (IObjectValue)destInfo, srcInfo.getCompany().getId().toString());
        if (number != null) {
            destInfo.setNumber(number);
        } else {
            destInfo.setNumber(srcInfo.getNumber());
        }
        Date currentDate = DateTimeUtils.truncateDate((Date)new Date());
        destInfo.setBizDate(currentDate);
        destInfo.setAccountBank(srcInfo.getBankAccount());
        destInfo.setCurrency(srcInfo.getCurrency());
        destInfo.setBizTime(srcInfo.getBizTime());
        destInfo.setDebitAmt(srcInfo.getCreditAmount());
        destInfo.setCreditAmt(srcInfo.getDebitAmount());
        destInfo.setReceiveDate(currentDate);
        destInfo.setIsByManual(false);
        BizTypeEnum srcBizType = srcInfo.getBizType();
        if (srcBizType != null) {
            if (srcBizType.getValue() == 1) {
                if (srcInfo.getDebitAmount().compareTo(BigDecimal.ZERO) > 0) {
                    destInfo.setBizType(BizBype.payment);
                } else {
                    destInfo.setBizType(BizBype.receive);
                }
            } else if (srcBizType.getValue() == 2) {
                destInfo.setBizType(BizBype.transUp);
            } else if (srcBizType.getValue() == 3) {
                destInfo.setBizType(BizBype.transDown);
            }
        }
        destInfo.setSourceBillType(SourBillType.transDetail);
        destInfo.setDcDirection(destInfo.getDebitAmt().compareTo(BigDecimal.ZERO) > 0 ? DcDirection.debit : DcDirection.credit);
        destInfo.setOppBankAcctNum(srcInfo.getOppBankNumber());
        destInfo.setOppBankName(srcInfo.getOppBank());
        AccountBankInfo acctBankInfo = this.getAccountBank(ctx, srcInfo.getOppBankNumber());
        if (acctBankInfo != null) {
            destInfo.setOppBankAcct(acctBankInfo);
            destInfo.setOppBankInfo(acctBankInfo.getBank());
        }
        destInfo.setOppCompanyStr(srcInfo.getOppUnit());
        CompanyOrgUnitInfo orgInfo = null;
        String alias = srcInfo.getOppUnit();
        if (this.orgCache.containsKey(alias)) {
            orgInfo = this.orgCache.get(alias);
        } else {
            orgInfo = MNTUtils.getCompany(ctx, alias, aliasMap);
            if (orgInfo != null) {
                this.orgCache.put(alias, orgInfo);
            }
        }
        destInfo.setOppCompanyOrg(orgInfo);
        destInfo.setDescription(srcInfo.getDescription());
        if (matchMap != null && destInfo.getBizType() != null) {
            String key = destInfo.getCompany().getId().toString() + destInfo.getBizType().getValue();
            if (destInfo.getAccountBank() != null) {
                String k = key + destInfo.getAccountBank().getId();
                destInfo.setFundFlowItem(matchMap.get(k));
            }
        }
        destInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        destInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        return destInfo;
    }

    private AccountBankInfo getAccountBank(Context ctx, String accountNumber) throws BOSException {
        AccountBankInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bank.*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)accountNumber, CompareType.EQUALS));
        view.setFilter(filter);
        AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    private TransDetailCollection getTransDetailColl(Context ctx, Set<String> companyIds, Date beginDate, Date endDate) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bankAccount.*"));
        sic.add(new SelectorItemInfo("bankInterfaceType.*"));
        sic.add(new SelectorItemInfo("bankAccount.bank.*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", companyIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isReced", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)endDate, CompareType.LESS_EQUALS));
        view.setFilter(filter);
        return TransDetailFactory.getLocalInstance((Context)ctx).getTransDetailCollection(view);
    }
}

