/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fm.fs.TransDownBillCollection;
import com.kingdee.eas.fm.fs.TransDownBillEntryCollection;
import com.kingdee.eas.fm.fs.TransDownBillEntryInfo;
import com.kingdee.eas.fm.fs.TransDownBillFactory;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.mnt.BizBype;
import com.kingdee.eas.fm.mnt.DcDirection;
import com.kingdee.eas.fm.mnt.FundFlowDayReportInfo;
import com.kingdee.eas.fm.mnt.SourBillType;
import com.kingdee.eas.fm.mnt.app.service.IFundFlowDayReportBuilder;
import com.kingdee.eas.fm.mnt.utils.MNTUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TransDown2DayReportBuilderImpl
implements IFundFlowDayReportBuilder {
    @Override
    public CoreBaseCollection getFundFlowDayReportColl(Context ctx, Map<String, List<String>> aliasMap, Date beginDate, Date endDate) throws BOSException, EASBizException {
        CoreBaseCollection destColls = new CoreBaseCollection();
        Set<String> companyIds = aliasMap.keySet();
        TransDownBillCollection srcColls = this.getTransDownBillColl(ctx, companyIds, beginDate, endDate);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)srcColls)) {
            Map<String, FundFlowItemInfo> matchMap = MNTUtils.getFlowItemMatchMap(ctx, companyIds, BizBype.transDown.getValue());
            for (int i = 0; i < srcColls.size(); ++i) {
                TransDownBillInfo srcInfo = srcColls.get(i);
                TransDownBillEntryCollection entryColls = srcInfo.getEntrys();
                for (int j = 0; j < entryColls.size(); ++j) {
                    TransDownBillEntryInfo entry = entryColls.get(j);
                    FundFlowDayReportInfo destInfo = this.convertReportInfo(ctx, srcInfo, entry, matchMap, aliasMap);
                    destColls.add((CoreBaseInfo)destInfo);
                    ArrayList<String> srcIdList = new ArrayList<String>();
                    srcIdList.add(srcInfo.getId().toString());
                    BOTPUtil.saveBOTRelation((Context)ctx, srcIdList, (String)destInfo.getId().toString());
                }
            }
        }
        return destColls;
    }

    private FundFlowDayReportInfo convertReportInfo(Context ctx, TransDownBillInfo srcInfo, TransDownBillEntryInfo entry, Map<String, FundFlowItemInfo> matchMap, Map<String, List<String>> aliasMap) throws EASBizException, BOSException {
        FundFlowDayReportInfo destInfo = new FundFlowDayReportInfo();
        destInfo.setId(BOSUuid.create((BOSObjectType)destInfo.getBOSType()));
        destInfo.setSourceBillId(srcInfo.getId().toString());
        destInfo.setSourceBillEntryId(entry.getId().toString());
        destInfo.setCompany(srcInfo.getCompany());
        String number = MNTUtils.getNumberRule(ctx, (IObjectValue)destInfo, srcInfo.getCompany().getId().toString());
        if (number != null) {
            destInfo.setNumber(number);
        } else {
            destInfo.setNumber(srcInfo.getNumber());
        }
        Date currentDate = DateTimeUtils.truncateDate((Date)new Date());
        destInfo.setBizDate(currentDate);
        destInfo.setAccountBank(srcInfo.getMotherAcctBank());
        destInfo.setCurrency(srcInfo.getCurrency());
        destInfo.setBizTime(srcInfo.getBizDate());
        destInfo.setDebitAmt(BigDecimal.ZERO);
        destInfo.setCreditAmt(entry.getAmount());
        destInfo.setReceiveDate(currentDate);
        destInfo.setIsByManual(false);
        destInfo.setBizType(BizBype.transDown);
        destInfo.setSourceBillType(SourBillType.transDownBill);
        destInfo.setDcDirection(DcDirection.credit);
        if (entry.getUnitAcctBank() != null) {
            String bankId;
            AccountBankInfo acctBank;
            destInfo.setOppBankAcct(entry.getUnitAcctBank());
            destInfo.setOppBankInfo(entry.getUnitAcctBank().getBank());
            if (entry.getUnitAcctBank().getId() != null && (acctBank = this.getAccountBankInfo(ctx, bankId = entry.getUnitAcctBank().getId().toString())) != null) {
                destInfo.setOppBankAcctNum(acctBank.getBankAccountNumber());
                if (acctBank.getBank() != null) {
                    destInfo.setOppBankName(acctBank.getBank().getName());
                }
            }
        }
        if (entry.getUnit() != null) {
            destInfo.setOppCompanyStr(entry.getUnit().getName());
            destInfo.setOppCompanyOrg(entry.getUnit());
        }
        destInfo.setDescription(srcInfo.getDescription());
        AsstActTypeInfo asstType = new AsstActTypeInfo();
        asstType.setId(BOSUuid.read((String)"YW3xsAEJEADgAAYBwKgTB0c4VZA="));
        destInfo.setOppCompanyType(asstType);
        destInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        destInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        if (entry.getFundFlowItem() != null) {
            destInfo.setFundFlowItem(entry.getFundFlowItem());
        } else if (srcInfo.getFundFlowItem() != null) {
            destInfo.setFundFlowItem(srcInfo.getFundFlowItem());
        }
        if (destInfo.getFundFlowItem() == null && matchMap != null && destInfo.getAccountBank() != null) {
            String key = destInfo.getCompany().getId().toString() + destInfo.getBizType().getValue() + destInfo.getAccountBank().getId().toString();
            destInfo.setFundFlowItem(matchMap.get(key));
        }
        return destInfo;
    }

    private TransDownBillCollection getTransDownBillColl(Context ctx, Set<String> companyIds, Date beginDate, Date endDate) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("motherAcctBank.*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.unit.name"));
        sic.add(new SelectorItemInfo("entrys.unitAcctBank.*"));
        sic.add(new SelectorItemInfo("entrys.unitAcctBank.bank.id"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", companyIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)4));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)endDate, CompareType.LESS_EQUALS));
        view.setFilter(filter);
        return TransDownBillFactory.getLocalInstance((Context)ctx).getTransDownBillCollection(view);
    }

    private AccountBankInfo getAccountBankInfo(Context ctx, String bankId) throws EASBizException, BOSException {
        AccountBankInfo info = null;
        if (bankId == null && bankId.length() <= 0) {
            return info;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("bankAccountNumber"));
        selector.add(new SelectorItemInfo("bank.name"));
        info = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankId), selector);
        return info;
    }
}

