/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.base;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.MockConfig;
import com.kingdee.eas.fm.mobile.app.base.AbstractGetOrgUnitTreeWithPermissionFacadeControllerBean;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FundReverseMockDataBuilder;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.PermissionCompanyTreeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;

public class GetOrgUnitTreeWithPermissionFacadeControllerBean
extends AbstractGetOrgUnitTreeWithPermissionFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.app.base.GetOrgUnitTreeWithPermissionFacadeControllerBean");

    @Override
    protected ResultInfo _execute(Context ctx, Map bizData) throws BOSException, EASBizException {
        if (MockConfig.isOpenFundFlowMock) {
            FundReverseMockDataBuilder.init();
        }
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.put("orgUnitTree", this.buildOrgUnitTree(ctx));
        return resultInfo;
    }

    private void putOtherData(ResultInfo resultInfo) {
        HttpSession session = ServletActionContext.getRequest().getSession();
        String eid = (String)session.getAttribute("eid");
        String openId = (String)session.getAttribute("openId");
        resultInfo.put("eid", eid);
        resultInfo.put("openId", openId);
    }

    private List buildOrgUnitTree(Context ctx) throws EASBizException, BOSException {
        ArrayList<Map> result = new ArrayList<Map>();
        CompanyOrgUnitCollection companyOrgUnitCollection = PermissionCompanyTreeUtil.getCompanyTreeWithPermission((Context)ctx);
        for (CompanyOrgUnitInfo companyOrgUnitInfo : companyOrgUnitCollection) {
            String id = companyOrgUnitInfo.getId().toString();
            String name = companyOrgUnitInfo.getName();
            String parentID = companyOrgUnitInfo.getParent() == null ? null : companyOrgUnitInfo.getParent().getId().toString();
            int level = companyOrgUnitInfo.getLevel();
            boolean isLeaf = companyOrgUnitInfo.isIsLeaf();
            String desc = companyOrgUnitInfo.getDescription();
            result.add(this.buildOrgUnit(id, name, parentID, level, isLeaf, desc));
        }
        this.resetIsLeaf(result);
        return result;
    }

    private void resetIsLeaf(List<Map> result) {
        for (Map orgUnitItem : result) {
            if (orgUnitItem.get("isLeaf") == null || !orgUnitItem.get("isLeaf").equals(Boolean.FALSE)) continue;
            orgUnitItem.put("isLeaf", this.fixedIsLeaf(orgUnitItem, result));
        }
    }

    private boolean fixedIsLeaf(Map orgUnit, List<Map> result) {
        for (Map orgUnitItem : result) {
            if (!orgUnit.get("id").equals(orgUnitItem.get("parentID"))) continue;
            return false;
        }
        return true;
    }

    private Map buildOrgUnit(String id, String name, String parentID, int level, boolean isLeaf, String desc) {
        HashMap<String, Object> orgUnit = new HashMap<String, Object>();
        orgUnit.put("id", id);
        orgUnit.put("name", name);
        orgUnit.put("parentID", parentID);
        orgUnit.put("level", level);
        orgUnit.put("isLeaf", isLeaf);
        orgUnit.put("desc", desc);
        return orgUnit;
    }
}

