/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.capitalinsight;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.FundFlowFacadeFactory;
import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.app.MockConfig;
import com.kingdee.eas.fm.mobile.app.capitalinsight.AbstractGetCashContributionRankingFacadeControllerBean;
import com.kingdee.eas.fm.mobile.app.capitalinsight.GetCashContributionRankingHelper;
import com.kingdee.eas.fm.mobile.app.capitalinsight.cashcontributionranking.periodparse.CashContributionRankingPeriodParsor;
import com.kingdee.eas.fm.mobile.app.capitalinsight.common.CompanyUtil;
import com.kingdee.eas.fm.mobile.app.capitalinsight.mock.FuncGetCashContributionRanking;
import com.kingdee.eas.fm.mobile.app.capitalinsight.mock.RankingMockDataBuilder;
import com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse.PeriodParsorFactory;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.BigDecimalUtils;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.PermissionUtil;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GetCashContributionRankingFacadeControllerBean
extends AbstractGetCashContributionRankingFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.app.capitalinsight.GetCashContributionRankingFacadeControllerBean");

    @Override
    protected ResultInfo _execute(Context ctx, Map bizData) throws BOSException, EASBizException {
        ValidateUtil.validateParam(bizData, "period");
        ValidateUtil.validateParam(bizData, "direction");
        String period = (String)bizData.get("period");
        String direction = (String)bizData.get("direction");
        if (MockConfig.isOpenFundReverseMock) {
            RankingMockDataBuilder.init();
            return new FuncGetCashContributionRanking().execute(period, direction);
        }
        PermissionUtil.validatePermission(ctx, "FUND_FLOW_RANKING");
        PeriodParsorFactory factory = new PeriodParsorFactory(bizData);
        CashContributionRankingPeriodParsor cashContributionRankingPeriodParsor = factory.makeCashContributionRankingPeriodParsor();
        ResultInfo resultInfo = new ResultInfo();
        try {
            resultInfo.put("listData", this.buildListData(ctx, period, direction, cashContributionRankingPeriodParsor));
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new FMMobileException(FMMobileException.COMMON, e, new Object[]{e.getMessage()});
        }
        BigDecimal total = this.calcTotal((List)resultInfo.getData().get("listData"));
        this.resetRate((List)resultInfo.getData().get("listData"), total);
        resultInfo.put("lastUpdateTime", DateUtils.getNow());
        return resultInfo;
    }

    private List<Map<String, Object>> buildListData(Context ctx, String period, String direction, CashContributionRankingPeriodParsor periodParsor) throws EASBizException, BOSException, SQLException {
        HashMap<String, String> filterParamMap = new HashMap<String, String>();
        filterParamMap.put("beginDate", DateUtils.formatDate(periodParsor.getBeginDate()));
        filterParamMap.put("endDate", DateUtils.formatDate(periodParsor.getEndDate()));
        filterParamMap.put("isOrgPermission", "false");
        filterParamMap.put("parentCompanyId", CompanyUtil.getTopLevelCompany(ctx).getId().toString());
        IRowSet rs = FundFlowFacadeFactory.getLocalInstance((Context)ctx).getFlowDataForMobile(filterParamMap, 6);
        GetCashContributionRankingHelper helper = new GetCashContributionRankingHelper();
        return helper.buildRows(rs, direction, 10);
    }

    private BigDecimal calcTotal(List<Map<String, Object>> listData) {
        BigDecimal total = BigDecimal.ZERO;
        for (Map<String, Object> row : listData) {
            total = total.add((BigDecimal)row.get("amount"));
        }
        return total;
    }

    private void resetRate(List<Map<String, Object>> list, BigDecimal total) {
        for (Map<String, Object> row : list) {
            BigDecimal amount = (BigDecimal)row.get("amount");
            row.put("rate", BigDecimalUtils.calcPercentage(amount, total));
        }
    }
}

