/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.capitalinsight;

import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetCashContributionRankingHelper {
    public List<Map<String, Object>> buildRows(IRowSet rs, final String direction, int size) throws SQLException {
        List<Map<String, Object>> rows = this.buildRows(rs);
        Collections.sort(rows, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                int compareBalance = this.compareBalance(o1, o2);
                if (compareBalance == 0) {
                    if (direction.equals("DESC_TOP_N")) {
                        return ((String)o2.get("orgName")).compareTo((String)o1.get("orgName"));
                    }
                    return ((String)o1.get("orgName")).compareTo((String)o2.get("orgName"));
                }
                return compareBalance;
            }

            private int compareBalance(Map<String, Object> o1, Map<String, Object> o2) {
                if (direction.equals("DESC_TOP_N")) {
                    return ((BigDecimal)o2.get("amount")).compareTo((BigDecimal)o1.get("amount"));
                }
                return ((BigDecimal)o1.get("amount")).compareTo((BigDecimal)o2.get("amount"));
            }
        });
        this.resetIndex(direction, rows);
        return rows.subList(0, Math.min(rows.size(), size));
    }

    private List<Map<String, Object>> buildRows(IRowSet rs) throws SQLException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            boolean index = false;
            String orgID = rs.getString("FCompanyId");
            String orgName = rs.getString("FCompanyName");
            BigDecimal amount = rs.getBigDecimal("FLocalIncomeAmount").subtract(rs.getBigDecimal("FLocalOutcomeAmount"));
            BigDecimal rate = BigDecimal.ZERO;
            rows.add(this.buildRow(0, orgID, orgName, amount, rate));
        }
        return rows;
    }

    private Map<String, Object> buildRow(int index, String orgID, String orgName, BigDecimal amount, BigDecimal rate) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("index", index);
        row.put("orgID", orgID);
        row.put("orgName", orgName);
        row.put("amount", amount);
        row.put("rate", rate);
        return row;
    }

    private void resetIndex(String direction, List<Map<String, Object>> rows) {
        int index = direction.equals("DESC_TOP_N") ? 1 : rows.size();
        for (Map<String, Object> row : rows) {
            row.put("index", index);
            index += direction.equals("DESC_TOP_N") ? 1 : -1;
        }
    }
}

