/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.capitalinsight;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.CompanyLiquidInfo;
import com.kingdee.eas.fm.liquid.MobileLiquidFacadeFactory;
import com.kingdee.eas.fm.mobile.app.MockConfig;
import com.kingdee.eas.fm.mobile.app.capitalinsight.AbstractGetFundReverseRankingFacadeControllerBean;
import com.kingdee.eas.fm.mobile.app.capitalinsight.mock.GetFundReverseRankingProcess;
import com.kingdee.eas.fm.mobile.app.fundreverse.FundReverseRankingComparator;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.BigDecimalUtils;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.PermissionUtil;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class GetFundReverseRankingFacadeControllerBean
extends AbstractGetFundReverseRankingFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.app.capitalinsight.GetFundReverseRankingFacadeControllerBean");

    @Override
    protected ResultInfo _execute(Context ctx, Map bizData) throws BOSException, EASBizException {
        ValidateUtil.validateParam(bizData, "direction");
        String direction = (String)bizData.get("direction");
        if (MockConfig.isOpenFundReverseMock) {
            return new GetFundReverseRankingProcess().execute(direction);
        }
        PermissionUtil.validatePermission(ctx, "FUND_REVERSE_RANKING");
        Map resultMap = MobileLiquidFacadeFactory.getLocalInstance((Context)ctx).getCompanyBalanceOrder(null, new Date());
        TreeSet<CompanyLiquidInfo> sortSet = new TreeSet<CompanyLiquidInfo>(new FundReverseRankingComparator(direction));
        sortSet.addAll(resultMap.values());
        BigDecimal total = this.totalBalance(sortSet);
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.put("listData", this.buildListData(total, new ArrayList<CompanyLiquidInfo>(sortSet), direction));
        resultInfo.put("lastUpdateTime", DateUtils.getNow());
        return resultInfo;
    }

    private BigDecimal totalBalance(Set<CompanyLiquidInfo> sortSet) {
        BigDecimal total = BigDecimal.ZERO;
        for (CompanyLiquidInfo companyLiquidInfo : sortSet) {
            total = total.add(companyLiquidInfo.getLocalBalance());
        }
        return total;
    }

    private List<Map<String, Object>> buildListData(BigDecimal total, List<CompanyLiquidInfo> listData, String direction) {
        int fixed;
        int index;
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        if (direction.equals("DESC_TOP_N")) {
            index = 1;
            fixed = 1;
        } else {
            index = listData.size();
            fixed = -1;
        }
        int count = 0;
        for (CompanyLiquidInfo companyLiquidInfo : listData) {
            if (count >= 10) break;
            BigDecimal rate = BigDecimalUtils.calcPercentage(companyLiquidInfo.getLocalBalance(), total);
            rows.add(this.buildRow(index, total, companyLiquidInfo.getCompanyid(), companyLiquidInfo.getCompanyName(), companyLiquidInfo.getLocalBalance(), rate));
            index += fixed;
            ++count;
        }
        return rows;
    }

    private Map<String, Object> buildRow(int index, BigDecimal total, String orgID, String orgName, BigDecimal balance, BigDecimal rate) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("index", index);
        row.put("orgID", orgID);
        row.put("orgName", orgName);
        row.put("balance", balance);
        row.put("rate", rate);
        return row;
    }
}

