/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.capitalinsight.mock;

import com.kingdee.eas.fm.mobile.app.capitalinsight.mock.RankingMockData;
import com.kingdee.eas.fm.mobile.app.capitalinsight.mock.SortableLine;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.BigDecimalUtils;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FuncGetCashContributionRanking {
    public ResultInfo execute(String period, String direction) {
        List<SortableLine> listData = null;
        BigDecimal total = null;
        if ("YEAR".equals(period)) {
            listData = RankingMockData.getInstance().getAmountYearList(direction);
            total = RankingMockData.getInstance().getAmountYearTotal();
        } else {
            listData = RankingMockData.getInstance().getAmountMonthList(direction);
            total = RankingMockData.getInstance().getAmountMonthTotal();
        }
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.put("listData", this.buildListData(total, listData, period, direction));
        resultInfo.put("totalAmount", total);
        resultInfo.put("lastUpdateTime", DateUtils.getNow());
        return resultInfo;
    }

    private List<Map<String, Object>> buildListData(BigDecimal total, List<SortableLine> listData, String period, String direction) {
        int fixed;
        int index;
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        if (direction.equals("DESC_TOP_N")) {
            index = 1;
            fixed = 1;
        } else {
            index = 43;
            fixed = -1;
        }
        int count = 0;
        for (SortableLine sortableLine : listData) {
            if (count >= 10) break;
            BigDecimal amount = period.equals("YEAR") ? sortableLine.getAmountYear() : sortableLine.getAmountMonth();
            BigDecimal rate = BigDecimalUtils.calcPercentage(amount, total);
            rows.add(this.buildRow(index, total, sortableLine.getOrgID(), sortableLine.getOrgName(), amount, rate));
            index += fixed;
            ++count;
        }
        return rows;
    }

    private Map<String, Object> buildRow(int index, BigDecimal total, String orgID, String orgName, BigDecimal amount, BigDecimal rate) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("index", index);
        row.put("orgID", orgID);
        row.put("orgName", orgName);
        row.put("amount", amount);
        row.put("rate", rate);
        return row;
    }
}

