/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.capitalinsight.mock;

import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.app.capitalinsight.mock.RankingMockData;
import com.kingdee.eas.fm.mobile.app.capitalinsight.mock.SortableLine;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FileLoader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class RankingMockDataBuilder {
    public static final int ORG_ID = 0;
    public static final int ORG_NAME = 1;
    public static final int YEAR_CASH_CONTRIBUTION = 2;
    public static final int MONTH_CASH_CONTRIBUTION = 3;
    public static final int FUND_REVERSE_BALANCE = 4;
    private static RankingMockDataBuilder instance = null;
    private List<Object[]> data = new ArrayList<Object[]>();

    private RankingMockDataBuilder() {
    }

    public static RankingMockDataBuilder init() throws FMMobileException {
        try {
            if (instance == null) {
                instance = new RankingMockDataBuilder();
                FileLoader loader = new FileLoader();
                RankingMockDataBuilder.instance.data = loader.readExcelFile(RankingMockDataBuilder.class.getClassLoader().getResourceAsStream("com/kingdee/eas/fm/mobile/app/capitalinsight/mock/ranking_mockdata.xls"));
                instance.build();
            }
            return instance;
        }
        catch (IOException e) {
            throw new FMMobileException(FMMobileException.DEVELOP_ERROR, e, new Object[]{e.getMessage()});
        }
    }

    private RankingMockData build() {
        RankingMockData mockData = RankingMockData.getInstance();
        for (int i = 0; i < this.data.size(); ++i) {
            Object[] row = this.data.get(i);
            String orgID = row[0].toString();
            String orgName = (String)row[1];
            BigDecimal amountYear = new BigDecimal(row[2].toString());
            BigDecimal amountMonth = new BigDecimal(row[3].toString());
            BigDecimal balance = new BigDecimal(row[4].toString());
            SortableLine line = new SortableLine(orgID, orgName, amountYear, amountMonth, balance);
            mockData.add(line);
        }
        mockData.build();
        return mockData;
    }
}

