/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundflow;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fm.liquid.FundFlowFacadeFactory;
import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.app.MockConfig;
import com.kingdee.eas.fm.mobile.app.fundflow.AbstractGetFlowComposeWithOrgUnitFacadeControllerBean;
import com.kingdee.eas.fm.mobile.app.fundflow.FlowItemDirectionUtils;
import com.kingdee.eas.fm.mobile.app.fundflow.mock.FuncGetFlowComposeWithOrgUnit;
import com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse.PeriodParsor;
import com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse.PeriodParsorFactory;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FundReverseMockDataBuilder;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.StringUtil;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GetFlowComposeWithOrgUnitFacadeControllerBean
extends AbstractGetFlowComposeWithOrgUnitFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.app.fundflow.GetFlowComposeWithOrgUnitFacadeControllerBean");

    @Override
    protected ResultInfo _execute(Context ctx, Map bizData) throws BOSException, EASBizException {
        ValidateUtil.validateParam(bizData, "period");
        ValidateUtil.validateParam(bizData, "orgID");
        String period = (String)bizData.get("period");
        String orgID = (String)bizData.get("orgID");
        String flowItemID = (String)bizData.get("flowItemID");
        if (MockConfig.isOpenFundFlowMock) {
            FundReverseMockDataBuilder.init();
            return new FuncGetFlowComposeWithOrgUnit().execute(period, orgID, flowItemID);
        }
        PeriodParsorFactory factory = new PeriodParsorFactory(bizData);
        PeriodParsor periodParsor = factory.makePeriodParsor();
        ResultInfo resultInfo = new ResultInfo();
        try {
            resultInfo.put("listData", this.buildListData(ctx, orgID, flowItemID, periodParsor));
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new FMMobileException(FMMobileException.COMMON, e, new Object[]{e.getMessage()});
        }
        resultInfo.put("lastUpdateTime", DateUtils.getNow());
        return resultInfo;
    }

    private List<Map<String, Object>> buildListData(Context ctx, String orgID, String flowItemID, PeriodParsor periodParsor) throws EASBizException, BOSException, SQLException {
        HashMap<String, String> filterParamMap = new HashMap<String, String>();
        filterParamMap.put("parentCompanyId", orgID);
        filterParamMap.put("flowParentItemId", flowItemID);
        filterParamMap.put("beginDate", DateUtils.formatDate(periodParsor.getBeginDate()));
        filterParamMap.put("endDate", DateUtils.formatDate(periodParsor.getEndDate()));
        filterParamMap.put("companyPermItem", "CAPITAL_INSIGHT_USE");
        IRowSet rs = FundFlowFacadeFactory.getLocalInstance((Context)ctx).getFlowDataForMobile(filterParamMap, 3);
        return this.buildRows(ctx, rs, flowItemID);
    }

    private List<Map<String, Object>> buildRows(Context ctx, IRowSet rs, String flowItemID) throws EASBizException, BOSException, SQLException {
        String type;
        if (StringUtil.isEmpty(flowItemID)) {
            type = FlowItemDirectionUtils.getFlowItemDirection(0);
        } else {
            FundFlowItemInfo fundFlowItemInfo = FundFlowItemFactory.getLocalInstance((Context)ctx).getFundFlowItemInfo("select direction where id='" + flowItemID + "'");
            type = FlowItemDirectionUtils.getFlowItemDirection(fundFlowItemInfo.getDirection().getValue());
        }
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            String orgID = rs.getString("FCompanyId");
            String orgName = rs.getString("FCompanyName");
            BigDecimal amount = FlowItemDirectionUtils.calcAmount(rs.getBigDecimal("FLocalIncomeAmount"), rs.getBigDecimal("FLocalOutcomeAmount"), type);
            rows.add(this.buildRow(orgID, orgName, amount));
        }
        return rows;
    }

    private Map<String, Object> buildRow(String orgID, String orgName, BigDecimal amount) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("orgID", orgID);
        row.put("orgName", orgName);
        row.put("amount", amount);
        return row;
    }
}

