/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.MobileLiquidFacadeFactory;
import com.kingdee.eas.fm.mobile.FundReverseException;
import com.kingdee.eas.fm.mobile.app.MockConfig;
import com.kingdee.eas.fm.mobile.app.fundreverse.AbstractGetListDataFacadeControllerBean;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FundReverseMockDataBuilder;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.listdata.FuncGetListData;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.BankListDataGetter;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.ListDataGetter;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.OrgUnitListDataGetter;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.BOSTypeUtil;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import java.util.Map;
import org.apache.log4j.Logger;

public class GetListDataFacadeControllerBean
extends AbstractGetListDataFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.app.fundreverse.GetListDataFacadeControllerBean");
    private static final String RECALCULATE = "IS_RECALCULATE_BALANCE_TABLE_FOR_USER";

    @Override
    protected ResultInfo _execute(Context ctx, Map bizData) throws BOSException, EASBizException {
        String superID = (String)bizData.get("superID");
        String mainID = (String)bizData.get("mainID");
        ValidateUtil.validateParam(bizData, "mainID");
        if (MockConfig.isOpenFundReverseMock) {
            FundReverseMockDataBuilder.init();
            return new FuncGetListData().execute(superID, mainID);
        }
        if (ctx.get((Object)RECALCULATE) == null || Boolean.FALSE == ctx.get((Object)RECALCULATE)) {
            MobileLiquidFacadeFactory.getLocalInstance((Context)ctx).recalculateBalanceTableForUser();
            ctx.put((Object)RECALCULATE, (Object)true);
        } else {
            MobileLiquidFacadeFactory.getLocalInstance((Context)ctx).recalculateBalanceTableForUser();
        }
        ListDataGetter listDataGetter = this.createListDataGetter(bizData);
        return listDataGetter.doGet(ctx, superID, mainID);
    }

    private ListDataGetter createListDataGetter(Map bizData) throws EASBizException {
        String mainID = (String)bizData.get("mainID");
        if (BOSTypeUtil.isOrgUnit(mainID)) {
            return new OrgUnitListDataGetter();
        }
        if (BOSTypeUtil.isBank(mainID)) {
            ValidateUtil.validateParam(bizData, "superID");
            return new BankListDataGetter();
        }
        throw new FundReverseException(FundReverseException.GETLISTDATA_MAINID_BOS_TYPE_ERROR, new Object[]{mainID, BOSTypeUtil.getBOSType(mainID)});
    }
}

