/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.CompanyLiquidInfo;
import com.kingdee.eas.fm.liquid.FundFlowFacadeFactory;
import com.kingdee.eas.fm.liquid.MobileLiquidFacadeFactory;
import com.kingdee.eas.fm.liquid.app.MobileFacadeHelper;
import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.app.MobileConfig;
import com.kingdee.eas.fm.mobile.app.MockConfig;
import com.kingdee.eas.fm.mobile.app.capitalinsight.GetCashContributionRankingHelper;
import com.kingdee.eas.fm.mobile.app.capitalinsight.common.CompanyUtil;
import com.kingdee.eas.fm.mobile.app.capitalinsight.mock.RankingMockDataBuilder;
import com.kingdee.eas.fm.mobile.app.fundreverse.AbstractGetMetroBoardFacadeControllerBean;
import com.kingdee.eas.fm.mobile.app.fundreverse.FundReverseRankingComparator;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FuncGetMetroBoard;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FundReverseMockDataBuilder;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageBuilderType;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageHelper;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageRelationCollection;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageRelationInfo;
import com.kingdee.eas.fm.mobile.app.message.mock.MessageMockDataBuilder;
import com.kingdee.eas.fm.mobile.model.MonetaryUnit;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.BigDecimalUtils;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.MonetaryUnitUtil;
import com.kingdee.eas.fm.mobile.util.NoPermissionException;
import com.kingdee.eas.fm.mobile.util.PermissionCompanyTreeUtil;
import com.kingdee.eas.fm.mobile.util.UserUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.File;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class GetMetroBoardFacadeControllerBean
extends AbstractGetMetroBoardFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.app.fundreverse.GetMetroBoardFacadeControllerBean");

    @Override
    protected ResultInfo _execute(Context ctx, Map bizData) throws BOSException, EASBizException {
        String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        String userRealName = UserUtil.getUserRealName(ctx, userID);
        this.proecessMockFileFlag();
        if (MockConfig.isOpenFundReverseMock) {
            FundReverseMockDataBuilder.init();
            MessageMockDataBuilder.init();
            RankingMockDataBuilder.init();
            return new FuncGetMetroBoard().execute(userRealName);
        }
        try {
            MobileFacadeHelper.createBalanceTableForUser((Context)ctx, (Date)new Date());
        }
        catch (NoPermissionException e) {
            logger.error((Object)(userRealName + "\u6ca1\u6709\u4efb\u4f55\u7ec4\u7ec7\u88ab\u5206\u914d\u4e86\u6743\u9650"), (Throwable)e);
            throw new FMMobileException(FMMobileException.NO_PERMISSION, new Object[]{userRealName});
        }
        CompanyOrgUnitInfo companyOrgUnitInfo = PermissionCompanyTreeUtil.getTopLevelCompanyWithPermission((Context)ctx);
        CompanyLiquidInfo companyLiquidInfo = this.accessDataWithTopLevelCompanyOrgUnit(ctx, companyOrgUnitInfo.getId().toString());
        return this.buildResult(ctx, userRealName, companyOrgUnitInfo, companyLiquidInfo);
    }

    private void proecessMockFileFlag() {
        if (this.isOpenMockFileFlag()) {
            MockConfig.isOpenFundReverseMock = true;
            MockConfig.isOpenFundFlowMock = true;
            MockConfig.isOpenMessageMock = true;
            MobileConfig.isOpenFundFlow = true;
            MobileConfig.isOpenEarlyWarning = true;
        }
    }

    private boolean isOpenMockFileFlag() {
        File winFlagFile = new File("c:/fm_mobile_demo_flag.txt");
        File linuxFlagFile = new File("/usr/EAS750/eas/admin/fm_mobile_demo_flag.txt");
        return winFlagFile.exists() || linuxFlagFile.exists();
    }

    private ResultInfo buildResult(Context ctx, String userRealName, CompanyOrgUnitInfo companyOrgUnitInfo, CompanyLiquidInfo companyLiquidInfo) throws EASBizException, BOSException {
        ResultInfo result = new ResultInfo();
        result.put("companyOrgUnitID", companyOrgUnitInfo.getId().toString());
        result.put("companyOrgUnitName", companyOrgUnitInfo.getName());
        result.put("userRealName", userRealName);
        result.put("balance", companyLiquidInfo.getLocalBalance());
        result.put("limitFund", companyLiquidInfo.getLocalLimitAmount());
        result.put("avaliableBalance", companyLiquidInfo.getLocalAvaliableBalance());
        MonetaryUnit monetaryUnit = MonetaryUnitUtil.getMonetaryUnit(ctx);
        result.put("currencyUnitName", monetaryUnit.getName());
        result.put("currencyUnitValue", monetaryUnit.getValue());
        result.put("fundReverse", this.buildFundReverse(companyLiquidInfo));
        result.put("fundFlow", this.buildFundFlow(ctx));
        result.put("earlyWarning", this.buildEarlyWarning(ctx));
        result.put("ranking", this.buildRanking(ctx));
        result.put("isOpenFundFlow", MobileConfig.isOpenFundFlow);
        result.put("isOpenEarlyWarning", MobileConfig.isOpenEarlyWarning);
        result.put("isOpenRanking", true);
        result.put("lastUpdateTime", this.getLastUpdateTime(ctx, companyOrgUnitInfo.getId().toString()));
        return result;
    }

    private String getLastUpdateTime(Context ctx, String companyId) throws EASBizException, BOSException {
        Map result = MobileLiquidFacadeFactory.getLocalInstance((Context)ctx).getNewestBizDate(companyId, new Date());
        return DateUtils.formatDateTime((Date)result.get("newestBizDate"));
    }

    private Map<String, Object> buildFundReverse(CompanyLiquidInfo companyLiquidInfo) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("balance", companyLiquidInfo.getLocalBalance());
        result.put("limitFund", companyLiquidInfo.getLocalLimitAmount());
        result.put("avaliableBalance", companyLiquidInfo.getLocalAvaliableBalance());
        return result;
    }

    private BigDecimal buildFundFlow(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo topCompany = this.getTopTreeCompanyUnitInfo(ctx);
        if (topCompany == null) {
            throw new FMMobileException(FMMobileException.COMMON, new Object[]{"\u83b7\u53d6\u7ec4\u7ec7\u6811\u7684\u672c\u7ea7\u7ec4\u7ec7\u5931\u8d25"});
        }
        HashMap<String, String> filterParamMap = new HashMap<String, String>();
        Date now = new Date();
        filterParamMap.put("parentCompanyId", topCompany.getId().toString());
        filterParamMap.put("beginDate", DateUtils.formatDate(DateUtils.getThisMonthBegin(now)));
        filterParamMap.put("endDate", DateUtils.formatDate(now));
        filterParamMap.put("companyPermItem", "CAPITAL_INSIGHT_USE");
        IRowSet rs = FundFlowFacadeFactory.getLocalInstance((Context)ctx).getFlowDataForMobile(filterParamMap, 1);
        try {
            if (rs.next()) {
                BigDecimal flowOut = rs.getBigDecimal("FLocalOutcomeAmount");
                BigDecimal flowIn = rs.getBigDecimal("FLocalIncomeAmount");
                return BigDecimalUtils.calcPercentage(flowOut, flowIn);
            }
            return BigDecimal.ZERO;
        }
        catch (SQLException e) {
            throw new FMMobileException(FMMobileException.COMMON, e, new Object[]{"\u83b7\u53d6\u6d41\u5165\u6d41\u51fa\u6bd4\u6570\u636e\u51fa\u9519"});
        }
    }

    private CompanyOrgUnitInfo getTopTreeCompanyUnitInfo(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitCollection companyOrgUnitCollection = PermissionCompanyTreeUtil.getCompanyTreeWithPermission((Context)ctx);
        for (CompanyOrgUnitInfo company : companyOrgUnitCollection) {
            if (company.getLevel() != 0) continue;
            return company;
        }
        throw new FMMobileException(FMMobileException.COMMON, new Object[]{"\u83b7\u53d6\u7ec4\u7ec7\u6811\u7684\u672c\u7ea7\u7ec4\u7ec7\u5931\u8d25"});
    }

    private Map<String, Object> buildEarlyWarning(Context ctx) throws EASBizException, BOSException {
        MobileMessageHelper helper = new MobileMessageHelper(ctx);
        helper.buildMobileMessageRelation();
        MobileMessageRelationCollection unreadMobileMessageRelationCollection = helper.getUnreadMobileMessageRelationCollection();
        int largePayment = 0;
        int flowOutInRateWithRed = 0;
        int flowOutInRateWithYellow = 0;
        Iterator it = unreadMobileMessageRelationCollection.iterator();
        while (it.hasNext()) {
            MobileMessageRelationInfo mobileMessageInfo = (MobileMessageRelationInfo)it.next();
            MobileMessageBuilderType builderType = mobileMessageInfo.getMessage().getBuilderType();
            if (MobileMessageBuilderType.LARGE_PAYMENT.equals((Object)builderType)) {
                ++largePayment;
                continue;
            }
            if (MobileMessageBuilderType.FLOW_OUT_IN_RATE_RED.equals((Object)builderType)) {
                ++flowOutInRateWithRed;
                continue;
            }
            if (!MobileMessageBuilderType.FLOW_OUT_IN_RATE_YELLOW.equals((Object)builderType)) continue;
            ++flowOutInRateWithYellow;
        }
        return this.buildResult(largePayment, flowOutInRateWithRed, flowOutInRateWithYellow);
    }

    private Map<String, Object> buildResult(int largePayment, int flowOutInRateWithRed, int flowOutInRateWithYellow) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("flowOutInRate", this.buildFlowOutInRate(flowOutInRateWithRed, flowOutInRateWithYellow));
        result.put("largePayment", largePayment);
        return result;
    }

    private Map<String, Object> buildFlowOutInRate(int flowOutInRateWithRed, int flowOutInRateWithYellow) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("RED", flowOutInRateWithRed);
        result.put("YELLOW", flowOutInRateWithYellow);
        return result;
    }

    private Map<String, Object> buildRanking(Context ctx) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("fundReverseRanking", this.buildFundReverseRanking(ctx));
        try {
            result.put("cashContributionRanking", this.buildCashContributionRanking(ctx));
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new FMMobileException(FMMobileException.COMMON, e, new Object[]{e.getMessage()});
        }
        return result;
    }

    private List<Map<String, Object>> buildFundReverseRanking(Context ctx) throws EASBizException, BOSException {
        Map resultMap = MobileLiquidFacadeFactory.getLocalInstance((Context)ctx).getCompanyBalanceOrder(null, new Date());
        TreeSet<CompanyLiquidInfo> sortSet = new TreeSet<CompanyLiquidInfo>(new FundReverseRankingComparator("DESC_TOP_N"));
        sortSet.addAll(resultMap.values());
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        int index = 0;
        for (CompanyLiquidInfo companyLiquidInfo : sortSet) {
            if (index == 3) break;
            result.add(this.buildOrgUnit(companyLiquidInfo.getCompanyName()));
            ++index;
        }
        return result;
    }

    private List<Map<String, Object>> buildCashContributionRanking(Context ctx) throws EASBizException, BOSException, SQLException {
        HashMap<String, String> filterParamMap = new HashMap<String, String>();
        filterParamMap.put("beginDate", DateUtils.formatDate(DateUtils.getThisMonthBegin(new Date())));
        filterParamMap.put("endDate", DateUtils.formatDate(new Date()));
        filterParamMap.put("isOrgPermission", "false");
        filterParamMap.put("parentCompanyId", CompanyUtil.getTopLevelCompany(ctx).getId().toString());
        IRowSet rs = FundFlowFacadeFactory.getLocalInstance((Context)ctx).getFlowDataForMobile(filterParamMap, 6);
        GetCashContributionRankingHelper helper = new GetCashContributionRankingHelper();
        List<Map<String, Object>> rows = helper.buildRows(rs, "DESC_TOP_N", 3);
        return this.fixedField(rows);
    }

    private List<Map<String, Object>> fixedField(List<Map<String, Object>> rows) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : rows) {
            result.add(this.buildOrgUnit((String)row.get("orgName")));
        }
        return result;
    }

    private Map<String, Object> buildOrgUnit(String orgName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("orgName", orgName);
        return result;
    }

    private CompanyLiquidInfo accessDataWithTopLevelCompanyOrgUnit(Context ctx, String companyID) throws BOSException, EASBizException {
        Map resultMap = MobileLiquidFacadeFactory.getLocalInstance((Context)ctx).getCompanyBalanceAndLimtsByCompamy(companyID, new Date());
        CompanyLiquidInfo companyLiquidInfo = (CompanyLiquidInfo)resultMap.get(companyID);
        return companyLiquidInfo;
    }
}

