/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.FundReverseException;
import com.kingdee.eas.fm.mobile.app.MockConfig;
import com.kingdee.eas.fm.mobile.app.fundreverse.AbstractGetReverseTrendFacadeControllerBean;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FuncGetReverseTrend;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.FundReverseMockDataBuilder;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.AccountBankTrendDataGetter;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.BankTrendDataGetter;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.OrgUnitTrendDataGetter;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.TrendDataGetter;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.BOSTypeUtil;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import java.util.Map;
import org.apache.log4j.Logger;

public class GetReverseTrendFacadeControllerBean
extends AbstractGetReverseTrendFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.app.fundreverse.GetReverseTrendFacadeControllerBean");

    @Override
    protected ResultInfo _execute(Context ctx, Map bizData) throws BOSException, EASBizException {
        if (MockConfig.isOpenFundReverseMock) {
            FundReverseMockDataBuilder.init();
            return new FuncGetReverseTrend().execute(bizData);
        }
        TrendDataGetter trendDataGetter = this.createTrendDataGetter(bizData);
        String superID = (String)bizData.get("superID");
        String mainID = (String)bizData.get("mainID");
        return trendDataGetter.doGet(ctx, superID, mainID);
    }

    private TrendDataGetter createTrendDataGetter(Map bizData) throws EASBizException {
        ValidateUtil.validateParam(bizData, "mainID");
        String mainID = (String)bizData.get("mainID");
        TrendDataGetter trendDataGetter = null;
        if (BOSTypeUtil.isOrgUnit(mainID)) {
            trendDataGetter = new OrgUnitTrendDataGetter();
        } else if (BOSTypeUtil.isBank(mainID)) {
            ValidateUtil.validateParam(bizData, "superID");
            trendDataGetter = new BankTrendDataGetter();
        } else if (BOSTypeUtil.isAccount(mainID)) {
            trendDataGetter = new AccountBankTrendDataGetter();
        } else {
            throw new FundReverseException(FundReverseException.GETLISTDATA_MAINID_BOS_TYPE_ERROR, new Object[]{mainID, BOSTypeUtil.getBOSType(mainID)});
        }
        return trendDataGetter;
    }
}

