/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse.PeriodParsor;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import java.util.Date;
import java.util.Map;

public class APeriodOfTenDaysParsor
implements PeriodParsor {
    private final int year;
    private final int month;
    private final int aPeriodOfTenDaysType;

    private APeriodOfTenDaysParsor(int year, int month, int aPeriodOfTenDaysType) {
        this.year = year;
        this.month = month;
        this.aPeriodOfTenDaysType = aPeriodOfTenDaysType;
    }

    public APeriodOfTenDaysParsor(Map bizData) throws EASBizException {
        if (this.isValidate()) {
            ValidateUtil.validateParam(bizData, "year");
            ValidateUtil.validateParam(bizData, "month");
            ValidateUtil.validateParam(bizData, "aPeriodOfTenDaysType");
            this.year = (Integer)bizData.get("year");
            this.month = (Integer)bizData.get("month") - 1;
            this.aPeriodOfTenDaysType = (Integer)bizData.get("aPeriodOfTenDaysType") + 1;
        } else {
            Date now = new Date();
            this.year = DateUtils.getYear(now);
            this.month = DateUtils.getMonth(now);
            this.aPeriodOfTenDaysType = DateUtils.getAPeriodOfTenDaysType(now) + 1;
        }
    }

    @Override
    public boolean isValidate() {
        return true;
    }

    @Override
    public Date getBeginDate() {
        return BgPeriodHelper.getTenDaysFirstDay((int)this.year, (int)(this.month + 1), (int)this.aPeriodOfTenDaysType);
    }

    @Override
    public Date getEndDate() {
        return DateUtils.truncate(BgPeriodHelper.getTenDaysLastDay((int)this.year, (int)(this.month + 1), (int)this.aPeriodOfTenDaysType));
    }

    @Override
    public PeriodParsor previousPeriod() {
        return new APeriodOfTenDaysParsor(this.year - 1, this.month, this.aPeriodOfTenDaysType);
    }

    @Override
    public int getBgPeriod() {
        return 9;
    }
}

