/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse.PeriodParsor;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class CustomParsor
implements PeriodParsor {
    private final Date beginDate;
    private final Date endDate;

    private CustomParsor(Date beginDate, Date endDate) {
        this.beginDate = beginDate;
        this.endDate = endDate;
    }

    public CustomParsor(Map bizData) throws EASBizException {
        ValidateUtil.validateParam(bizData, "beginDate");
        ValidateUtil.validateParam(bizData, "endDate");
        this.beginDate = DateUtils.makeDate((String)bizData.get("beginDate"));
        this.endDate = DateUtils.makeDate((String)bizData.get("endDate"));
    }

    @Override
    public boolean isValidate() {
        return true;
    }

    @Override
    public Date getBeginDate() {
        return this.beginDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public PeriodParsor previousPeriod() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.beginDate);
        cal.add(1, -1);
        Date beforeBeginDate = cal.getTime();
        cal.setTime(this.endDate);
        cal.add(1, -1);
        Date beforeEndDate = cal.getTime();
        return new CustomParsor(beforeBeginDate, beforeEndDate);
    }

    @Override
    public int getBgPeriod() {
        return 8;
    }
}

