/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.fundreverse.datalist.periodparse.PeriodParsor;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class YearParsor
implements PeriodParsor {
    protected final int year;

    protected YearParsor(int year) {
        this.year = year;
    }

    public YearParsor(Map bizData) throws EASBizException {
        if (this.isValidate()) {
            ValidateUtil.validateParam(bizData, "year");
            this.year = (Integer)bizData.get("year");
        } else {
            Date now = new Date();
            this.year = DateUtils.getYear(now);
        }
    }

    @Override
    public boolean isValidate() {
        return true;
    }

    @Override
    public Date getBeginDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(this.year, 0, 1);
        return cal.getTime();
    }

    @Override
    public Date getEndDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(this.year, 11, 31);
        return cal.getTime();
    }

    @Override
    public PeriodParsor previousPeriod() {
        return new YearParsor(this.year - 1);
    }

    @Override
    public int getBgPeriod() {
        return 1;
    }
}

