/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.mock;

import com.kingdee.eas.fm.mobile.app.fundreverse.mock.AccountInfo;
import java.math.BigDecimal;
import java.util.Map;
import java.util.TreeMap;

public class BankInfo {
    private String id;
    private String name;
    private boolean isLeaf;
    private BigDecimal balance;
    private BigDecimal limitFund;
    private BigDecimal avaliableBalance;
    private Map<String, AccountInfo> mapByID = new TreeMap<String, AccountInfo>();
    private Map<String, AccountInfo> mapByName = new TreeMap<String, AccountInfo>();

    public BankInfo(int row, int level, String name) {
        String id;
        this.id = id = row + "_" + level;
        this.name = name;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getLimitFund() {
        return this.limitFund;
    }

    public void setLimitFund(BigDecimal limitFund) {
        this.limitFund = limitFund;
    }

    public BigDecimal getAvaliableBalance() {
        return this.avaliableBalance;
    }

    public void setAvaliableBalance(BigDecimal avaliableBalance) {
        this.avaliableBalance = avaliableBalance;
    }

    public AccountInfo getSubAccountByName(String key, String accountName) {
        AccountInfo accountInfo = this.mapByName.get(accountName);
        if (accountInfo == null) {
            accountInfo = new AccountInfo(key, accountName);
            this.mapByID.put(key, accountInfo);
            this.mapByName.put(accountName, accountInfo);
        }
        return accountInfo;
    }

    public AccountInfo[] getChildrenByAccount() {
        return this.mapByID.values().toArray(new AccountInfo[0]);
    }

    public BigDecimal calculateBalance() {
        BigDecimal sum = new BigDecimal("0");
        for (AccountInfo accountInfo : this.mapByID.values()) {
            sum = sum.add(accountInfo.getDescBalance());
        }
        this.balance = sum;
        return sum;
    }

    public BigDecimal calculateLimitFund() {
        BigDecimal sum = new BigDecimal("0");
        for (AccountInfo accountInfo : this.mapByID.values()) {
            sum = sum.add(accountInfo.getDescLimitFund());
        }
        this.limitFund = sum;
        this.avaliableBalance = this.balance.subtract(this.limitFund);
        return sum;
    }
}

