/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.mock;

import com.kingdee.eas.fm.mobile.app.fundreverse.mock.AccountInfo;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.BankInfo;
import com.kingdee.eas.fm.mobile.app.fundreverse.mock.OrgInfo;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class FundReverseMockData {
    private static FundReverseMockData instance = null;
    private Map<String, OrgInfo> mapByID = new TreeMap<String, OrgInfo>();
    private Map<String, OrgInfo> mapByName = new TreeMap<String, OrgInfo>();
    private Map<String, OrgInfo> orgMap = new TreeMap<String, OrgInfo>();
    private Map<String, BankInfo> bankMap = new TreeMap<String, BankInfo>();
    private Map<String, AccountInfo> accountMap = new TreeMap<String, AccountInfo>();

    private FundReverseMockData() {
    }

    public static FundReverseMockData getInstance() {
        if (instance == null) {
            instance = new FundReverseMockData();
        }
        return instance;
    }

    public OrgInfo getTopOrg() {
        Iterator<OrgInfo> it = this.mapByName.values().iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public OrgInfo getByOrgID(String mainID) {
        return this.orgMap.get(mainID);
    }

    public BankInfo getByBankID(String mainID) {
        return this.bankMap.get(mainID);
    }

    public AccountInfo getAccountID(String mainID) {
        return this.accountMap.get(mainID);
    }

    public OrgInfo getOrgL1ByName(int row, int level, String orgName) {
        String key = row + "_" + level;
        OrgInfo orgInfo = this.mapByName.get(orgName);
        if (orgInfo == null) {
            orgInfo = new OrgInfo(row, level, orgName);
            this.mapByID.put(key, orgInfo);
            this.mapByName.put(orgName, orgInfo);
        }
        return orgInfo;
    }

    public void addOrg(OrgInfo orgInfo) {
        this.orgMap.put(orgInfo.getID(), orgInfo);
    }

    public void addBank(BankInfo bankInfo) {
        this.bankMap.put(bankInfo.getID(), bankInfo);
    }

    public void addAccount(AccountInfo accountInfo) {
        this.accountMap.put(accountInfo.getID(), accountInfo);
    }

    public void build() {
        this.getTopOrg().calculateBalance();
        this.getTopOrg().calculateLimitFund();
    }
}

