/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.CompanyLiquidInfo;
import com.kingdee.eas.fm.liquid.MobileLiquidFacadeFactory;
import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.AbstractListDataGetter;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.AccountBankItemBuilder;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.AccountNumberComparator;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.CashAccountItemBuilder;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.FundReverseListDataItemBuilder;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.CashBankUtil;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class BankListDataGetter
extends AbstractListDataGetter {
    private Context ctx;
    private String superID;
    private String mainID;

    @Override
    public ResultInfo doGet(Context ctx, String superID, String mainID) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.superID = superID;
        this.mainID = mainID;
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.put("listData", this.buildListData());
        resultInfo.put("lastUpdateTime", DateUtils.getNow());
        return resultInfo;
    }

    private List<Map> buildListData() throws EASBizException, BOSException {
        ArrayList<Map> listData = new ArrayList<Map>();
        listData.add(this.buildTitleRow());
        listData.addAll(this.buildAccountRows());
        return listData;
    }

    private Map buildTitleRow() throws EASBizException, BOSException {
        Map resultMap = MobileLiquidFacadeFactory.getLocalInstance((Context)this.ctx).getAllBankBalanceAndLimtsByCompamy(this.superID, new Date());
        for (CompanyLiquidInfo companyLiquidInfoWithSubBankInfo : resultMap.values()) {
            if (!companyLiquidInfoWithSubBankInfo.getBankId().equals(this.mainID)) continue;
            String objID = companyLiquidInfoWithSubBankInfo.getBankId();
            String objName = CashBankUtil.getObjectName(companyLiquidInfoWithSubBankInfo);
            boolean isLeaf = true;
            BigDecimal balance = companyLiquidInfoWithSubBankInfo.getLocalBalance();
            BigDecimal limitFund = companyLiquidInfoWithSubBankInfo.getLocalLimitAmount();
            BigDecimal avaliableBalance = companyLiquidInfoWithSubBankInfo.getLocalAvaliableBalance();
            return this.buildBankRow(objID, objName, true, balance, limitFund, avaliableBalance);
        }
        throw new FMMobileException(FMMobileException.COMMON, new Object[]{String.format("\u94f6\u884c\u8d26\u6237ID\u65e0\u6cd5\u83b7\u53d6\u5bf9\u5e94\u7684\u5b58\u6b3e\u4f59\u989d\uff0cID\u4e3a\u3010%s\u3011", this.mainID)});
    }

    private List<Map> buildAccountRows() throws EASBizException, BOSException {
        Map resultMap = MobileLiquidFacadeFactory.getLocalInstance((Context)this.ctx).getAllAcctBalanceAndLimtsByCompanyAndBank(this.superID, this.mainID, new Date());
        TreeSet<CompanyLiquidInfo> sortSet = new TreeSet<CompanyLiquidInfo>(new AccountNumberComparator());
        sortSet.addAll(resultMap.values());
        ArrayList<Map> rows = new ArrayList<Map>();
        FundReverseListDataItemBuilder itemBuilter = this.createFundReverseListDataItemBuilter(this.mainID);
        for (CompanyLiquidInfo account : sortSet) {
            if (!itemBuilter.isSendData(account)) continue;
            String objID = account.getAccountBankID() + "$ACCOUNT_CURRENCY_ID_SPLITOR$" + account.getCurrencyId();
            String objName = itemBuilter.buildObjName(account);
            String accountNumber = itemBuilter.buildAccountNumber(account);
            String openBankID = account.getBankId();
            String openBankName = itemBuilter.buildOpenBankName(account);
            String type = itemBuilter.buildType(account);
            boolean isLeaf = true;
            String srcCurrency = account.getSrcCurrencyName();
            String descCurrency = account.getDescCurrencyName();
            BigDecimal srcBalance = account.getBalance();
            BigDecimal descBalance = account.getLocalBalance();
            BigDecimal srcLimitFund = account.getLimitAmount();
            BigDecimal descLimitFund = account.getLocalLimitAmount();
            BigDecimal srcAvaliableBalance = account.getAvaliableBalance();
            BigDecimal descAvaliableBalance = account.getLocalAvaliableBalance();
            String accountProperty = account.getAccountProperty();
            boolean isLimit = account.isLimit();
            rows.add(this.buildAccountBankRow(objID, objName, accountNumber, openBankID, openBankName, type, true, srcCurrency, descCurrency, srcBalance, descBalance, srcLimitFund, descLimitFund, srcAvaliableBalance, descAvaliableBalance, accountProperty, isLimit));
        }
        return rows;
    }

    private FundReverseListDataItemBuilder createFundReverseListDataItemBuilter(String bosUuid) {
        if (CashBankUtil.isCashBank(bosUuid)) {
            return new CashAccountItemBuilder();
        }
        return new AccountBankItemBuilder();
    }
}

