/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.fundreverse.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.CompanyLiquidInfo;
import com.kingdee.eas.fm.mobile.app.fundreverse.model.QueryDateComparator;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.TimestampSetUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class TrendDataGetter {
    private static final String[] week_day = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
    private static final String[] month_week = new String[]{"\u7b2c\u4e00\u5468", "\u7b2c\u4e8c\u5468", "\u7b2c\u4e09\u5468", "\u7b2c\u56db\u5468", "\u7b2c\u4e94\u5468", "\u7b2c\u516d\u5468"};
    private static final String[] quarter_month = new String[]{"1\u6708", "2\u6708", "3\u6708", "4\u6708", "5\u6708", "6\u6708", "7\u6708", "8\u6708", "9\u6708", "10\u6708", "11\u6708", "12\u6708"};
    private static final String[] year_month = new String[]{"1\u6708", "2\u6708", "3\u6708", "4\u6708", "5\u6708", "6\u6708", "7\u6708", "8\u6708", "9\u6708", "10\u6708", "11\u6708", "12\u6708"};
    private String superID;
    private String mainID;

    public ResultInfo doGet(Context ctx, String superID, String mainID) throws EASBizException, BOSException {
        this.superID = superID;
        this.mainID = mainID;
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.put("trendDataCollection", this.buildTrendDataCollection(ctx));
        return resultInfo;
    }

    private List<Map<String, Object>> buildTrendDataCollection(Context ctx) throws EASBizException, BOSException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        list.add(this.buildTrendData(ctx, "WEEK_DAY"));
        list.add(this.buildTrendData(ctx, "MONTH_WEEK"));
        list.add(this.buildTrendData(ctx, "QUARTER_MONTH"));
        list.add(this.buildTrendData(ctx, "YEAR_MONTH"));
        return list;
    }

    private Map<String, Object> buildTrendData(Context ctx, String dateSolution) throws EASBizException, BOSException {
        TimestampSetUtil timestampSetUtil = new TimestampSetUtil(new Date());
        HashMap<String, Object> trendData = new HashMap<String, Object>();
        trendData.put("dateSolution", dateSolution);
        if (dateSolution.equals("WEEK_DAY")) {
            Map changeByCompany = this.bizAccessData(ctx, this.superID, this.mainID, new HashSet<Date>(timestampSetUtil.getDaysWithDayOfWeek()));
            this.makeData(changeByCompany, week_day, 0, trendData);
        } else if (dateSolution.equals("MONTH_WEEK")) {
            Map changeByCompany = this.bizAccessData(ctx, this.superID, this.mainID, new HashSet<Date>(timestampSetUtil.getDaysWithWeekOfMonth()));
            this.makeData(changeByCompany, month_week, 0, trendData);
        } else if (dateSolution.equals("QUARTER_MONTH")) {
            Map changeByCompany = this.bizAccessData(ctx, this.superID, this.mainID, new HashSet<Date>(timestampSetUtil.getDaysWithMonthOfQuarter()));
            this.makeData(changeByCompany, quarter_month, timestampSetUtil.getFirstMonthWithQuarter(), trendData);
        } else {
            Map changeByCompany = this.bizAccessData(ctx, this.superID, this.mainID, new HashSet<Date>(timestampSetUtil.getDaysWithMonthOfYear()));
            this.makeData(changeByCompany, year_month, 0, trendData);
        }
        return trendData;
    }

    protected abstract Map bizAccessData(Context var1, String var2, String var3, Set<Date> var4) throws EASBizException, BOSException;

    private void makeData(Map changeByCompany, String[] titles, int beginIdx, Map<String, Object> trendData) {
        TreeSet<CompanyLiquidInfo> sortSet = new TreeSet<CompanyLiquidInfo>(new QueryDateComparator());
        sortSet.addAll(changeByCompany.values());
        int days = changeByCompany.size();
        BigDecimal balanceSum = new BigDecimal("0");
        BigDecimal limitFundSum = new BigDecimal("0");
        BigDecimal avaliableBalanceSum = new BigDecimal("0");
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        int i = beginIdx;
        for (CompanyLiquidInfo companyLiquidInfo : sortSet) {
            BigDecimal balance = companyLiquidInfo.getLocalBalance() == null ? BigDecimal.ZERO : companyLiquidInfo.getLocalBalance();
            BigDecimal limitFund = companyLiquidInfo.getLocalLimitAmount() == null ? BigDecimal.ZERO : companyLiquidInfo.getLocalLimitAmount();
            BigDecimal avaliableBalance = companyLiquidInfo.getLocalAvaliableBalance() == null ? BigDecimal.ZERO : companyLiquidInfo.getLocalAvaliableBalance();
            balanceSum = balanceSum.add(balance);
            limitFundSum = limitFundSum.add(balance);
            avaliableBalanceSum = avaliableBalanceSum.add(balance);
            arrayList.add(this.buildPoint(titles[i], balance, limitFund, avaliableBalance));
            ++i;
        }
        trendData.put("balanceAverage", balanceSum.divide(new BigDecimal(days), RoundingMode.HALF_UP));
        trendData.put("limitFundAverage", limitFundSum.divide(new BigDecimal(days), RoundingMode.HALF_UP));
        trendData.put("avaliableBalanceAverage", avaliableBalanceSum.divide(new BigDecimal(days), RoundingMode.HALF_UP));
        trendData.put("values", arrayList);
    }

    private Map<String, Object> buildPoint(String name, BigDecimal balance, BigDecimal limitFund, BigDecimal avaliableBalance) {
        HashMap<String, Object> point = new HashMap<String, Object>();
        point.put("name", name);
        point.put("balance", balance);
        point.put("limitFund", limitFund);
        point.put("avaliableBalance", avaliableBalance);
        return point;
    }
}

