/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.message;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.MockConfig;
import com.kingdee.eas.fm.mobile.app.message.AbstractGetMessageListFacadeControllerBean;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageHelper;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageRelationCollection;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageRelationInfo;
import com.kingdee.eas.fm.mobile.app.message.mock.MessageMockUtil;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GetMessageListFacadeControllerBean
extends AbstractGetMessageListFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.app.message.GetMessageListFacadeControllerBean");

    @Override
    protected ResultInfo _execute(Context ctx, Map bizData) throws BOSException, EASBizException {
        String builderType = (String)bizData.get("builderType");
        if (MockConfig.isOpenMessageMock) {
            return MessageMockUtil.getMessageList();
        }
        MobileMessageHelper helper = new MobileMessageHelper(ctx);
        helper.buildMobileMessageRelation(builderType);
        MobileMessageRelationCollection msgColl = helper.getMobileMessageRelationCollection(builderType);
        return this.buildResultInfo(msgColl);
    }

    private ResultInfo buildResultInfo(MobileMessageRelationCollection msgColl) throws BOSException {
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.put("messageList", this.buildMessageList(msgColl));
        resultInfo.put("lastUpdateTime", DateUtils.getNow());
        return resultInfo;
    }

    private List<Map<String, Object>> buildMessageList(MobileMessageRelationCollection msgColl) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Iterator it = msgColl.iterator();
        while (it.hasNext()) {
            MobileMessageRelationInfo mobileMessageInfo = (MobileMessageRelationInfo)it.next();
            result.add(GetMessageListFacadeControllerBean.buildMessageInfo(mobileMessageInfo));
        }
        return result;
    }

    private static Map<String, Object> buildMessageInfo(MobileMessageRelationInfo mobileMessageRelationInfo) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("messageID", mobileMessageRelationInfo.getMessage().getId().toString());
        result.put("type", mobileMessageRelationInfo.getMessage().getBuilderType().getValue());
        result.put("title", mobileMessageRelationInfo.getMessage().getDetail());
        result.put("detail", mobileMessageRelationInfo.getMessage().getDetail());
        result.put("senderName", mobileMessageRelationInfo.getMessage().getSender());
        result.put("date", DateUtils.formatDate(mobileMessageRelationInfo.getMessage().getCreateTime()));
        result.put("status", mobileMessageRelationInfo.getStatus().getValue());
        result.put("flag", mobileMessageRelationInfo.getFlag().getValue());
        return result;
    }
}

