/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.message;

import com.kingdee.eas.fm.mobile.app.message.MobileMessageBuilderType;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class ImageMessageAdapter
implements IMessageAdapter {
    private final String title;
    private final String summary;
    private final String imgText;
    private final MobileMessageBuilderType builderType;
    private final List<String> personIDs;

    public ImageMessageAdapter(String title, String summary, String imgText, MobileMessageBuilderType builderType, List<String> personIDs) {
        this.title = title;
        this.summary = summary;
        this.imgText = imgText;
        this.builderType = builderType;
        this.personIDs = personIDs;
    }

    public void clearTemporary() {
    }

    public Map<String, Object> getContent() {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("date", new SimpleDateFormat("yyyy-MM-dd").format(this.getUpdateTime()));
        message.put("title", this.title);
        message.put("text", this.summary);
        message.put("name", this.getPictureName());
        message.put("pic", this.getPictureData());
        return message;
    }

    private String getPictureData() {
        try {
            BufferedImage img = this.loadImage();
            this.drawText(img);
            return this.makeBase64(img);
        }
        catch (IOException e) {
            throw new RuntimeException("\u65e0\u6cd5\u751f\u6210\u4e91\u4e4b\u5bb6\u6d88\u606f\u7684\u56fe\u7247", e);
        }
    }

    private BufferedImage loadImage() throws IOException {
        File picFile = new File(this.getPicturePath(this.getPictureName()));
        return ImageIO.read(picFile);
    }

    private String makeBase64(BufferedImage img) throws IOException {
        byte[] byteArray = this.toByteArray(img);
        return StringUtil.getBase64FromByte((byte[])byteArray);
    }

    private byte[] toByteArray(BufferedImage img) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
        ImageIO.write((RenderedImage)img, "jpg", out);
        byte[] pictureData = out.toByteArray();
        return pictureData;
    }

    private void drawText(BufferedImage img) {
        Graphics g = img.getGraphics();
        g.setColor(Color.WHITE);
        g.setFont(new Font("\u534e\u6587\u7ec6\u9ed1", 0, 60));
        int strWidth = g.getFontMetrics().stringWidth(this.imgText);
        g.drawString(this.imgText, img.getWidth() / 2 - strWidth / 2, img.getHeight() / 2 + 25);
    }

    private String getPictureName() {
        if (MobileMessageBuilderType.FLOW_OUT_IN_RATE_RED == this.builderType) {
            return "bg_flow_out_in_rate_warning_red.jpg";
        }
        if (MobileMessageBuilderType.FLOW_OUT_IN_RATE_YELLOW == this.builderType) {
            return "bg_flow_out_in_rate_warning_yellow.jpg";
        }
        return "bg_large_payment.jpg";
    }

    private String getPicturePath(String filename) {
        String webAppPath = System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "deploy" + File.separator + "eas.ear" + File.separator;
        String relativePath = File.separator + "fmlight" + File.separator + "message" + File.separator + "images" + File.separator + filename;
        String mainWebModelName = "fm_mobile.war";
        String bakWebModelName = "mobile.war";
        String path = webAppPath + "fm_mobile.war" + relativePath;
        if (new File(path).exists()) {
            return path;
        }
        return webAppPath + "mobile.war" + relativePath;
    }

    public MessageModelEnum getModel() {
        return MessageModelEnum.SINGLEGRAPHIC;
    }

    public MessageTypeEnum getType() {
        return MessageTypeEnum.GRAPHIC;
    }

    public Date getUpdateTime() {
        return new Date();
    }

    public List<String> getUsers() {
        return this.personIDs;
    }

    public boolean isNeedSendXT() {
        return true;
    }
}

