/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.message.mock;

import com.kingdee.eas.fm.mobile.app.message.mock.DoIt;
import com.kingdee.eas.fm.mobile.app.message.mock.MessageInfoMock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MessageMockData {
    private static MessageMockData instance = null;
    private List<MessageInfoMock> messages = new ArrayList<MessageInfoMock>();

    private MessageMockData() {
    }

    public static MessageMockData getInstance() {
        if (instance == null) {
            instance = new MessageMockData();
        }
        return instance;
    }

    public void addMessage(MessageInfoMock mobileMessageInfoMock) {
        this.messages.add(mobileMessageInfoMock);
    }

    public List<MessageInfoMock> getMessages() {
        return this.messages;
    }

    public void deleteMessages(String messageIDs) {
        this.doItem(new DoIt(){

            @Override
            public void doIt(Iterator it, MessageInfoMock message) {
                it.remove();
            }
        }, messageIDs);
    }

    public void readMessages(String messageIDs) {
        this.doItem(new DoIt(){

            @Override
            public void doIt(Iterator it, MessageInfoMock message) {
                message.setReadFlag(true);
            }
        }, messageIDs);
    }

    public void unreadMessages(String messageIDs) {
        this.doItem(new DoIt(){

            @Override
            public void doIt(Iterator it, MessageInfoMock message) {
                message.setReadFlag(false);
            }
        }, messageIDs);
    }

    private void doItem(DoIt doIt, String messageIDs) {
        String[] arrID = messageIDs.split(",");
        Iterator<MessageInfoMock> it = this.messages.iterator();
        while (it.hasNext()) {
            MessageInfoMock message = it.next();
            if (!this.match(message.getMessageID(), arrID)) continue;
            doIt.doIt(it, message);
        }
    }

    private boolean match(String id, String[] arrID) {
        for (String idItem : arrID) {
            if (!id.equals(idItem)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.messages.clear();
    }

    public MessageInfoMock getMessagesByID(String messageID) {
        for (MessageInfoMock message : this.messages) {
            if (!message.getMessageID().equals(messageID)) continue;
            return message;
        }
        return null;
    }

    public int size(String type) {
        int count = 0;
        for (MessageInfoMock message : this.messages) {
            if (!message.getType().equals(type) || !this.unRead(message)) continue;
            ++count;
        }
        return count;
    }

    private boolean unRead(MessageInfoMock message) {
        return !message.isReadFlag();
    }
}

