/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.app.tools;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.app.MobileConfig;
import com.kingdee.eas.fm.mobile.app.MockConfig;
import com.kingdee.eas.fm.mobile.app.datarecorder.DataRecorder;
import com.kingdee.eas.fm.mobile.app.datarecorder.RecordList;
import com.kingdee.eas.fm.mobile.app.tools.AbstractConfigureParameterFacadeControllerBean;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConfigureParameterFacadeControllerBean
extends AbstractConfigureParameterFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.app.tools.ConfigureParameterFacadeControllerBean");

    @Override
    protected ResultInfo _execute(Context ctx, Map bizData) throws BOSException, EASBizException {
        String command = (String)bizData.get("command");
        if (StringUtil.isEmpty(command) || "help".equals(command)) {
            return this.buildHelp();
        }
        if (command.equals("isOpenDebugExceptionMessage")) {
            MobileConfig.isOpenDebugExceptionMessage = this.getValue(bizData);
        } else if (command.equals("isOpenFundFlow")) {
            MobileConfig.isOpenFundFlow = this.getValue(bizData);
        } else if (command.equals("isOpenEarlyWarning")) {
            MobileConfig.isOpenEarlyWarning = this.getValue(bizData);
        } else if (command.equals("isOpenFundReverseMock")) {
            MockConfig.isOpenFundReverseMock = this.getValue(bizData);
        } else if (command.equals("isOpenFundFlowMock")) {
            MockConfig.isOpenFundFlowMock = this.getValue(bizData);
        } else if (command.equals("isOpenMessageMock")) {
            MockConfig.isOpenMessageMock = this.getValue(bizData);
        } else {
            if (command.equals("listClient")) {
                ResultInfo resultInfo = new ResultInfo();
                Map<String, RecordList> dataRecorder = DataRecorder.getInstance().getDataRecorder();
                resultInfo.put("allClient", this.buildAllClient(dataRecorder));
                return resultInfo;
            }
            if (command.equals("listRecord")) {
                String value = (String)bizData.get("value");
                if (value == null) {
                    ResultInfo resultInfo = new ResultInfo();
                    resultInfo.put("allRecord", DataRecorder.getInstance().getDataRecorder());
                    return resultInfo;
                }
                ResultInfo resultInfo = new ResultInfo();
                resultInfo.put("record", DataRecorder.getInstance().getRecordListByKey(value));
                return resultInfo;
            }
            if (command.equals("clearRecord")) {
                DataRecorder.getInstance().clearData();
            }
        }
        return null;
    }

    private List<Map<String, Object>> buildAllClient(Map<String, RecordList> dataRecorder) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (String key : dataRecorder.keySet()) {
            RecordList value = dataRecorder.get(key);
            result.add(this.buildClientItem(key, value));
        }
        return result;
    }

    private Map<String, Object> buildClientItem(String key, RecordList value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("clientID", key);
        result.put("firstRequestDate", value.getFirstRequestDate());
        result.put("recordSize", value.size());
        return result;
    }

    private boolean getValue(Map bizData) {
        String value = (String)bizData.get("value");
        return "true".equals(value);
    }

    private ResultInfo buildHelp() {
        ResultInfo result = new ResultInfo();
        result.put("configure parameter command list", this.commandList());
        return result;
    }

    private List<String> commandList() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("isOpenDebugExceptionMessage=" + MobileConfig.isOpenDebugExceptionMessage);
        result.add("isOpenFundFlow=" + MobileConfig.isOpenFundFlow);
        result.add("isOpenEarlyWarning=" + MobileConfig.isOpenEarlyWarning);
        result.add("isOpenFundReverseMock=" + MockConfig.isOpenFundReverseMock);
        result.add("isOpenFundFlowMock=" + MockConfig.isOpenFundFlowMock);
        result.add("isOpenMessageMock=" + MockConfig.isOpenMessageMock);
        result.add("listClient");
        result.add("listRecord");
        result.add("clearRecord");
        return result;
    }
}

