/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.process;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.process.ProcessorInfo;
import com.kingdee.eas.fm.mobile.process.ProcessorMapping;
import com.kingdee.eas.fm.mobile.process.ResultInfo;
import com.kingdee.eas.fm.mobile.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBException;
import net.sf.json.JSONObject;

public class CenterProcessor {
    private static ProcessorMapping mapping = new ProcessorMapping();
    private ProcessorInfo processorInfo;

    public CenterProcessor(String appName, String deviceType, String bizName, String version) throws FMMobileException {
        this.processorInfo = mapping.get(appName, deviceType, bizName, version);
        if (this.processorInfo == null || !deviceType.equals("IOS") && !deviceType.equals("Android")) {
            String msg = String.format("\u4e1a\u52a1\u6620\u5c04\u5668\u3010%s\u3011\u672a\u627e\u5230\u4e1a\u52a1\u5904\u7406\u7c7b\uff0c\u8bf7\u6c42\u4fe1\u606f\u5305\u62ec\uff1aappName\uff1a\u3010%s\u3011\uff1adeviceType\u3010%s\u3011\uff1abizName\u3010%s\u3011version\uff1a\u3010%s\u3011", this.getClass().getName(), appName, deviceType, bizName, version);
            throw new FMMobileException(FMMobileException.DEVELOP_ERROR, new Object[]{msg});
        }
    }

    public ResultInfo doProcess(Context ctx, String bizData) throws EASBizException {
        Map paramMap;
        Method bizMethod;
        Class<?> factoryClass = this.makeFactoryClass(this.processorInfo.getClassName());
        Object homeInterface = this.makeHomeInterface(ctx, factoryClass);
        ResultInfo resultInfo = this.doBizProcess(homeInterface, bizMethod = this.makeMethod(homeInterface, this.processorInfo.getMethodName()), paramMap = this.transform(bizData));
        return resultInfo == null ? new ResultInfo() : resultInfo;
    }

    private ResultInfo doBizProcess(Object homeInterface, Method bizMethod, Map paramMap) throws EASBizException {
        try {
            if (bizMethod.getParameterTypes().length == 0) {
                bizMethod.invoke(homeInterface, new Object[0]);
                return new ResultInfo();
            }
            return (ResultInfo)bizMethod.invoke(homeInterface, paramMap);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof EASBizException) {
                throw (EASBizException)cause;
            }
            if (cause instanceof BOSException) {
                this.specialEJBExceptionProcess(cause);
                throw new FMMobileException(FMMobileException.BOS_EXCEPTION_ERROR, cause, new Object[]{cause.getMessage(), Arrays.toString((Object[])cause.getStackTrace())});
            }
            throw new FMMobileException(FMMobileException.UNKNOW_EXCEPTION_ERROR, cause, new Object[]{cause.getMessage(), Arrays.toString((Object[])cause.getStackTrace())});
        }
        catch (IllegalAccessException e) {
            String msg = String.format("\u4e1a\u52a1\u65b9\u6cd5\u4e0d\u53ef\u8bbf\u95ee\uff0c\u8bf7\u5c06\u65b9\u6cd5\u7684\u8bbf\u95ee\u6027\u6539\u4e3apublic\uff01\u5f02\u5e38\u4fe1\u606f\uff1a\u3010%s\u3011", Arrays.toString((Object[])e.getStackTrace()));
            throw new FMMobileException(FMMobileException.DEVELOP_ERROR, new Object[]{msg});
        }
        catch (IllegalArgumentException e) {
            String msg = String.format("\u4e1a\u52a1\u65b9\u6cd5\u53c2\u6570\u5f02\u5e38\uff01\u5f02\u5e38\u4fe1\u606f\uff1a\u3010%s\u3011", Arrays.toString((Object[])e.getStackTrace()));
            throw new FMMobileException(FMMobileException.DEVELOP_ERROR, new Object[]{msg});
        }
    }

    private void specialEJBExceptionProcess(Throwable cause) throws FMMobileException {
        Throwable throwable;
        EJBException ejbEx;
        if (cause != null && cause.getCause() instanceof EJBException && (ejbEx = (EJBException)cause.getCause()) != null && ejbEx.getCausedByException() != null && (throwable = ejbEx.getCausedByException().getCause()) != null) {
            throw new FMMobileException(FMMobileException.BOS_EXCEPTION_ERROR, throwable, new Object[]{throwable.getClass().getName(), Arrays.toString((Object[])throwable.getStackTrace())});
        }
    }

    private Map transform(String bizData) throws FMMobileException {
        if (StringUtil.isEmpty(bizData)) {
            return new HashMap();
        }
        try {
            JSONObject jsonObject = JSONObject.fromObject((Object)bizData);
            Map mapBean = (Map)JSONObject.toBean((JSONObject)jsonObject, Map.class);
            return mapBean;
        }
        catch (Exception e) {
            String msg = String.format("JSON\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u5185\u5bb9\u4e3a\u3010%s\u3011\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a\u3010%s\u3011", bizData, e.getMessage());
            throw new FMMobileException(FMMobileException.DEVELOP_ERROR, new Object[]{msg});
        }
    }

    private Method makeMethod(Object homeInterface, String methodName) throws FMMobileException {
        try {
            return homeInterface.getClass().getMethod(methodName, Map.class);
        }
        catch (Exception e) {
            try {
                return homeInterface.getClass().getMethod(methodName, new Class[0]);
            }
            catch (Exception exception) {
                String msg = String.format("\u3010%s\u3011\u7c7b\u7684\u3010%s\u3011\u65b9\u6cd5\u6267\u884c\u9519\u8bef\uff0c\u8bf7\u5728BIM\u4e2d\u5b9a\u4e49Facade\u5e76\u5b9e\u73b0\u8be5\u65b9\u6cd5\uff01\u5177\u4f53\u4fe1\u606f\uff1a\u3010%s\u3011", homeInterface.getClass(), this.processorInfo.getMethodName(), e.getMessage());
                throw new FMMobileException(FMMobileException.DEVELOP_ERROR, new Object[]{msg});
            }
        }
    }

    private Object makeHomeInterface(Context ctx, Class<?> factoryClass) throws FMMobileException {
        String factoryMethodName = "getLocalInstance";
        try {
            Method factoryMethod = factoryClass.getMethod("getLocalInstance", ctx.getClass());
            return factoryMethod.invoke(factoryClass, ctx);
        }
        catch (Exception e) {
            String msg = String.format("\u3010%s\u3011\u7c7b\u7684\u3010%s\u3011\u65b9\u6cd5\u6267\u884c\u9519\u8bef\uff0c\u8bf7\u5728BIM\u4e2d\u5b9a\u4e49Facade\u5e76\u5b9e\u73b0\u8be5\u65b9\u6cd5\uff01\u5177\u4f53\u4fe1\u606f\uff1a\u3010%s\u3011", factoryClass.getName(), "getLocalInstance", e.getMessage());
            throw new FMMobileException(FMMobileException.DEVELOP_ERROR, new Object[]{msg});
        }
    }

    private Class<?> makeFactoryClass(String className) throws FMMobileException {
        String factoryClassName = className + "Factory";
        try {
            return Class.forName(factoryClassName);
        }
        catch (ClassNotFoundException e) {
            String msg = String.format("\u672a\u627e\u5230\u7c7b\u3010%s\u3011\uff0c\u8bf7\u5728BIM\u4e2d\u5b9a\u4e49Facade\u5e76\u5b9e\u73b0execute()\u65b9\u6cd5\uff01\u5177\u4f53\u4fe1\u606f\uff1a\u3010%s\u3011", factoryClassName, e.getMessage());
            throw new FMMobileException(FMMobileException.DEVELOP_ERROR, new Object[]{msg});
        }
    }

    static {
        mapping.add("CapitalInsight", "IOS", "getMetroBoard", "1.0", "com.kingdee.eas.fm.mobile.app.fundreverse.GetMetroBoardFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "getFundReverseListData", "1.0", "com.kingdee.eas.fm.mobile.app.fundreverse.GetListDataFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "getFundReverseTrend", "1.0", "com.kingdee.eas.fm.mobile.app.fundreverse.GetReverseTrendFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "getOrgUnitTreeWithPermission", "1.0", "com.kingdee.eas.fm.mobile.app.base.GetOrgUnitTreeWithPermissionFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "getFundFlowListData", "1.0", "com.kingdee.eas.fm.mobile.app.fundflow.GetListDataFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "getFlowTrend", "1.0", "com.kingdee.eas.fm.mobile.app.fundflow.GetFlowTrendFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "getFlowComposeWithOrgUnit", "1.0", "com.kingdee.eas.fm.mobile.app.fundflow.GetFlowComposeWithOrgUnitFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "getBizBillWithTopN", "1.0", "com.kingdee.eas.fm.mobile.app.fundflow.GetBizBillWithTopNFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "getFundReverseRanking", "1.0", "com.kingdee.eas.fm.mobile.app.capitalinsight.GetFundReverseRankingFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "getCashContributionRanking", "1.0", "com.kingdee.eas.fm.mobile.app.capitalinsight.GetCashContributionRankingFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "getMessage", "1.0", "com.kingdee.eas.fm.mobile.app.message.GetMessageListFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "setMessageStatus", "1.0", "com.kingdee.eas.fm.mobile.app.message.SetMessageStatusFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "setMessageFlag", "1.0", "com.kingdee.eas.fm.mobile.app.message.SetMessageFlagFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "deleteMessage", "1.0", "com.kingdee.eas.fm.mobile.app.message.DeleteMessageListFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "readMessage", "1.0", "com.kingdee.eas.fm.mobile.app.message.ReadMessageListFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "unreadMessage", "1.0", "com.kingdee.eas.fm.mobile.app.message.UnreadMessageListFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "configureParameter", "1.0", "com.kingdee.eas.fm.mobile.app.tools.ConfigureParameterFacade", "execute");
        mapping.add("CapitalInsight", "IOS", "buildLargePaymentMessage", "1.0", "com.kingdee.eas.fm.mobile.app.message.MessageBuilderFacade", "buildLargePaymentMessage");
        mapping.add("CapitalInsight", "IOS", "buildFlowOutInRateMessage", "1.0", "com.kingdee.eas.fm.mobile.app.message.MessageBuilderFacade", "buildFlowOutInRateMessage");
    }
}

