/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.service.OrgPermissionService;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.util.UserUtil;

public class PermissionUtil {
    public static FullOrgUnitCollection getFullOrgUnitCollection(Context ctx, String userID, String permItemName) throws BOSException {
        return FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(PermissionUtil.getEntityView(userID, permItemName));
    }

    public static CompanyOrgUnitCollection getCompanyOrgUnitCollection(Context ctx, String userID, String permItemName) throws BOSException {
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(PermissionUtil.getEntityView(userID, permItemName));
    }

    private static EntityViewInfo getEntityView(String userID, String permItemName) {
        EntityViewInfo ev = new EntityViewInfo();
        ev.setSelector(PermissionUtil.getSelectors());
        ev.setFilter(PermissionUtil.getFilterInfo(userID, permItemName));
        return ev;
    }

    private static FilterInfo getFilterInfo(String userID, String permItemName) {
        String formatSql = "\tselect forgid from t_pm_userorgperm where fowner = '%1$s' and fpermitemid = ( \t\tselect fid from T_PM_PermItem where fnumber = '%2$s' \t) \tunion \tselect forgid from t_pm_userroleorg where froleid in ( \t\tselect froleid from t_pm_roleperm where fpermitemid = ( \t\t\tselect fid from T_PM_PermItem where fnumber = '%2$s' \t\t) \t) \tand fuserid = '%1$s'";
        String sql = String.format(formatSql, userID, permItemName);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        return filterInfo;
    }

    private static SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("name");
        selectors.add("number");
        selectors.add("longNumber");
        return selectors;
    }

    public static boolean hasCompanyPermission(Context ctx, String userID, String permItemName) throws EASBizException, BOSException {
        String treeID = "00000000-0000-0000-0000-0000000000024F2827FD";
        OrgPermissionService service = new OrgPermissionService(ctx);
        FullOrgUnitCollection fullOrgUnitCollection = service.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userID), (IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-0000000000024F2827FD"), permItemName);
        return fullOrgUnitCollection != null && fullOrgUnitCollection.size() > 0;
    }

    public static void validatePermission(Context ctx, String permissionItem) throws EASBizException, BOSException, FMMobileException {
        String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        String userRealName = UserUtil.getUserRealName(ctx, userID);
        if (!PermissionUtil.hasCompanyPermission(ctx, userID, permissionItem)) {
            throw new FMMobileException(FMMobileException.NO_PERMISSION, new Object[]{userRealName});
        }
    }
}

