/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util.period;

import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.period.PeriodFilter;
import java.util.Calendar;
import java.util.Date;

public class DayPeriodFilter
implements PeriodFilter {
    private final int year;
    private final int month;
    private final int day;
    private Calendar currentCalendar;

    public DayPeriodFilter(Date date) {
        this.year = DateUtils.getYear(date);
        this.month = DateUtils.getMonth(date);
        this.day = DateUtils.getDay(date);
        this.currentCalendar = Calendar.getInstance();
        this.currentCalendar.setTime(date);
    }

    @Override
    public String getText() {
        return String.format("%d\u5e74%d\u6708%d\u65e5", DateUtils.getYear(this.currentCalendar.getTime()), DateUtils.getMonth(this.currentCalendar.getTime()) + 1, DateUtils.getDay(this.currentCalendar.getTime()));
    }

    @Override
    public boolean hasNext() {
        return this.year != DateUtils.getYear(this.currentCalendar.getTime()) || this.month != DateUtils.getMonth(this.currentCalendar.getTime()) || this.day != DateUtils.getDay(this.currentCalendar.getTime());
    }

    @Override
    public void previous() {
        this.currentCalendar.add(5, -1);
    }

    @Override
    public void next() {
        this.currentCalendar.add(5, 1);
    }

    @Override
    public String getURLParameters() {
        return null;
    }
}

