/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util.period;

import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.period.PeriodFilter;
import java.util.Date;

public class MonthPeriodFilter
implements PeriodFilter {
    private final int year;
    private final int month;
    private int currentYear;
    private int currentMonth;

    public MonthPeriodFilter(Date date) {
        this.year = DateUtils.getYear(date);
        this.month = DateUtils.getMonth(date);
        this.currentYear = this.year;
        this.currentMonth = this.month;
    }

    @Override
    public String getText() {
        return String.format("%d\u5e74%d\u6708", this.currentYear, this.currentMonth + 1);
    }

    @Override
    public boolean hasNext() {
        return this.year != this.currentYear || this.month != this.currentMonth;
    }

    @Override
    public void previous() {
        --this.currentMonth;
        if (this.currentMonth < 0) {
            --this.currentYear;
            this.currentMonth = 11;
        }
    }

    @Override
    public void next() {
        ++this.currentMonth;
        if (this.currentMonth > 11) {
            ++this.currentYear;
            this.currentMonth = 0;
        }
    }

    @Override
    public String getURLParameters() {
        return null;
    }
}

