/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util.period;

import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.period.PeriodFilter;
import java.util.Date;

public class WeekOfYearPeriodFilter
implements PeriodFilter {
    private final int year;
    private final int weekOfYear;
    private int currentYear;
    private int currentWeekOfYear;
    private int calResultWeekOfYear;

    public WeekOfYearPeriodFilter(Date date) {
        this.year = DateUtils.getYear(date);
        this.weekOfYear = DateUtils.getWeekOfYearCountFixed(date);
        this.currentYear = this.year;
        this.currentWeekOfYear = this.weekOfYear;
        this.calResultWeekOfYear = this.weekOfYear;
    }

    @Override
    public String getText() {
        return String.format("%d\u5e74\u7b2c%d\u5468", this.currentYear, this.currentWeekOfYear);
    }

    @Override
    public boolean hasNext() {
        return this.year != this.currentYear || this.weekOfYear != this.currentWeekOfYear;
    }

    @Override
    public void previous() {
        --this.currentWeekOfYear;
        if (this.currentWeekOfYear <= 0) {
            --this.currentYear;
            this.currentWeekOfYear = this.calResultWeekOfYear = DateUtils.getWeekOfYearCountFixed(this.currentYear);
        }
    }

    @Override
    public void next() {
        ++this.currentWeekOfYear;
        if (this.currentWeekOfYear > this.calResultWeekOfYear) {
            ++this.currentYear;
            this.calResultWeekOfYear = DateUtils.getWeekOfYearCountFixed(this.currentYear);
            this.currentWeekOfYear = 1;
        }
    }

    @Override
    public String getURLParameters() {
        return null;
    }
}

