/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.nc.BizBillTypeEnum;
import com.kingdee.eas.fm.nc.ClaimBillEntryCollection;
import com.kingdee.eas.fm.nc.ClaimBillEntryInfo;
import com.kingdee.eas.fm.nc.ClaimBillInfo;
import com.kingdee.eas.fm.nc.NCException;
import com.kingdee.eas.fm.nc.NoticeBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;

public class ArClaimBillCommonUtils {
    protected static final String NC_RESOURCE = "com.kingdee.eas.fm.nc.NCResource";

    public static String transIdSet2String4Sql(Set idSet) {
        StringBuffer sb = new StringBuffer(idSet.size() * 30);
        for (Object id : idSet) {
            sb.append("'").append(id).append("',");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static void verifyClaimBill(Context ctx, ClaimBillInfo info) throws BOSException, EASBizException {
        ClaimBillEntryCollection entryColl = info.getEntrys();
        HashMap<String, ClaimBillEntryInfo> orderMap = new HashMap<String, ClaimBillEntryInfo>();
        HashMap<String, ClaimBillEntryInfo> contractMap = new HashMap<String, ClaimBillEntryInfo>();
        HashMap<String, ClaimBillEntryInfo> bizEntryIdMap = new HashMap<String, ClaimBillEntryInfo>();
        for (int i = 0; i < entryColl.size(); ++i) {
            String billId;
            ClaimBillEntryInfo entry = entryColl.get(i);
            if (StringUtils.isEmpty((String)entry.getBizBillId())) continue;
            if (BizBillTypeEnum.AR_SaleOrderBill.equals((Object)entry.getBizBillType())) {
                billId = entry.getBizBillId();
                if (orderMap.get(billId) == null) {
                    orderMap.put(billId, entry);
                }
            } else if (BizBillTypeEnum.AR_SaleContractBill.equals((Object)entry.getBizBillType()) && contractMap.get(billId = entry.getBizBillId()) == null) {
                contractMap.put(billId, entry);
            }
            bizEntryIdMap.put(entry.getBizBillEntryId(), entry);
        }
        if (orderMap.size() == 0 && contractMap.size() == 0 && bizEntryIdMap.size() == 0) {
            return;
        }
        String orderIds = ArClaimBillCommonUtils.transIdSet2String4Sql(orderMap.keySet());
        String contractIds = ArClaimBillCommonUtils.transIdSet2String4Sql(contractMap.keySet());
        StringBuffer verifySql = new StringBuffer(100);
        Boolean isErr = false;
        StringBuffer errMsg = new StringBuffer(100);
        try {
            if (orderMap.size() != 0 && contractMap.size() != 0) {
                verifySql.append(" select distinct FParentID,FSourceBillID from T_SD_SaleOrderEntry where ").append(" FParentID in (").append(orderIds).append(")").append(" and FSourceBillID in (").append(contractIds).append(")");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)verifySql.toString());
                errMsg.append(CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"SAME_ORDER_CONTRACT_IN_ONE_BILL"));
                while (rs.next()) {
                    isErr = true;
                    String orderId = rs.getString("FParentID");
                    String contractId = rs.getString("FSourceBillID");
                    ClaimBillEntryInfo orderEntry = (ClaimBillEntryInfo)orderMap.get(orderId);
                    ClaimBillEntryInfo contractEntry = (ClaimBillEntryInfo)contractMap.get(contractId);
                    if (!LoginType.GUI.equals(ctx.get((Object)"LOGIN_TYPE"))) {
                        errMsg.append("<br>");
                    } else {
                        errMsg.append("\n");
                    }
                    errMsg.append(CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"SALE_ORDER_CONTRACT_NUMBER", (String[])new String[]{orderEntry.getBizBillNumber(), contractEntry.getBizBillNumber()}));
                }
            }
            verifySql.setLength(0);
            String bizBillEntryIds = ArClaimBillCommonUtils.transIdSet2String4Sql(bizEntryIdMap.keySet());
            verifySql.append(" select FBizBillEntryId,MAX(FCanClaimAmt) maxAmt,SUM(FAmount) sumAmt from T_NC_ClaimBillEntry ").append(" where FBizBillEntryId in (").append(bizBillEntryIds).append(") ");
            if (info.getId() != null) {
                verifySql.append(" and FClaimBillID <> '").append(info.getId().toString()).append("'");
            }
            verifySql.append(" group by FBizBillEntryId ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)verifySql.toString());
            while (rs.next()) {
                String bizBillEntryId = rs.getString("FBizBillEntryId");
                ClaimBillEntryInfo entry = (ClaimBillEntryInfo)bizEntryIdMap.get(bizBillEntryId);
                BigDecimal maxAmt = rs.getBigDecimal("maxAmt");
                BigDecimal sumAmt = rs.getBigDecimal("sumAmt");
                BigDecimal thisAmt = entry.getAmount();
                thisAmt = thisAmt == null ? BigDecimal.ZERO : thisAmt;
                if (thisAmt.add(sumAmt).compareTo(maxAmt) <= 0) continue;
                isErr = true;
                errMsg.append(CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"ENTRY_AMT_GT_BIZ_AMT", (String[])new String[]{entry.getBizBillNumber(), Integer.toString(entry.getBizBillEntryNo()), maxAmt.subtract(sumAmt).toString()}));
                if (!LoginType.GUI.equals(ctx.get((Object)"LOGIN_TYPE"))) {
                    errMsg.append("<br>");
                    continue;
                }
                errMsg.append("\n");
            }
            if (isErr.booleanValue()) {
                throw new NCException(NCException.COMMON, new Object[]{errMsg});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NCException e) {
            throw e;
        }
    }

    public static void removeEmptyEntry(Context ctx, ClaimBillInfo info) {
        for (int i = info.getEntrys().size() - 1; i >= 0; --i) {
            ClaimBillEntryInfo entry = info.getEntrys().get(i);
            if (entry.getRecBillType() != null || entry.getBizBillType() != null && !entry.getBizBillType().equals((Object)BizBillTypeEnum.NULL) || !ArClaimBillCommonUtils.isBigDecimalNull(entry.getAmount()).booleanValue() || !ArClaimBillCommonUtils.isBigDecimalNull(entry.getRebate()).booleanValue() || !ArClaimBillCommonUtils.isBigDecimalNull(entry.getCommission()).booleanValue()) continue;
            info.getEntrys().remove(entry);
        }
    }

    public static Boolean isBigDecimalNull(BigDecimal value) {
        if (value == null || value.compareTo(BigDecimal.ZERO) == 0) {
            return true;
        }
        return false;
    }

    public static void setRecBillAfterTransform(Context ctx, ReceivingBillInfo recBill, NoticeBillInfo noticeBill) {
        int i;
        HashMap<String, ClaimBillEntryInfo> claimEntryMap = new HashMap<String, ClaimBillEntryInfo>();
        for (i = 0; i < noticeBill.getClaimEntrys().size(); ++i) {
            ClaimBillEntryInfo entry = noticeBill.getClaimEntrys().get(i);
            claimEntryMap.put(entry.getId().toString(), entry);
        }
        for (i = 0; i < recBill.getEntries().size(); ++i) {
            ReceivingBillEntryInfo recEntry = recBill.getEntries().get(i);
            String claimEntryId = recEntry.getSourceBillEntryId();
            ClaimBillEntryInfo claimEntry = (ClaimBillEntryInfo)claimEntryMap.get(claimEntryId);
            if (claimEntry.getBizBillType().equals((Object)BizBillTypeEnum.AR_OtherBill)) {
                recEntry.setSourceBillId(claimEntry.getBizBillId());
                recEntry.setSourceBillEntryId(claimEntry.getBizBillEntryId());
                continue;
            }
            if (claimEntry.getBizBillType().equals((Object)BizBillTypeEnum.AR_SaleContractBill)) {
                recEntry.setSourceBillId(claimEntry.getBizBillId());
                recEntry.setSourceBillEntryId(claimEntry.getBizBillEntryId());
                recEntry.setContractBillID(claimEntry.getBizBillId());
                recEntry.setContractEntryID(claimEntry.getBizBillEntryId());
                recEntry.setContractNum(claimEntry.getBizBillNumber());
                recEntry.setContractEntrySeq(claimEntry.getBizBillEntryNo());
                continue;
            }
            if (!claimEntry.getBizBillType().equals((Object)BizBillTypeEnum.AR_SaleOrderBill)) continue;
            recEntry.setSourceBillId(claimEntry.getBizBillId());
            recEntry.setSourceBillEntryId(claimEntry.getBizBillEntryId());
            recEntry.setCoreBillId(claimEntry.getBizBillId());
            recEntry.setCoreBillEntryId(claimEntry.getBizBillEntryId());
            recEntry.setCoreBillNumber(claimEntry.getBizBillNumber());
            recEntry.setCoreBillEntrySeq(claimEntry.getBizBillEntryNo());
            BillTypeInfo orderType = new BillTypeInfo();
            orderType.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0113c0a812fd463ED552"));
            recEntry.setCoreBillType(orderType);
        }
    }
}

