/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.nc.ClaimBillInfo;
import com.kingdee.eas.fm.nc.ClaimBillSatusEnum;
import com.kingdee.eas.fm.nc.NCException;
import com.kingdee.eas.fm.nc.NoticeBillFactory;
import com.kingdee.eas.fm.nc.NoticeBillInfo;
import com.kingdee.eas.fm.nc.NoticeBillSatusEnum;
import com.kingdee.eas.fm.nc.app.AbstractClaimBillControllerBean;
import com.kingdee.eas.fm.nc.app.service.ClaimAddNewServiceFactory;
import com.kingdee.eas.fm.nc.app.service.ClaimSaveServiceFactory;
import com.kingdee.eas.fm.nc.app.service.ClaimSubmitServiceFactory;
import com.kingdee.eas.fm.nc.app.service.IClaimAddNewService;
import com.kingdee.eas.fm.nc.app.service.IClaimSaveService;
import com.kingdee.eas.fm.nc.app.service.IClaimSubmitService;
import com.kingdee.eas.fm.nc.app.service.ServiceHandler;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class ClaimBillControllerBean
extends AbstractClaimBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nc.app.ClaimBillControllerBean");
    private static final String NC_RESOURCE = "com.kingdee.eas.fm.nc.NCResource";
    private static final String NOTICEBILL_BOSTYPE = new NoticeBillInfo().getBOSType().toString();
    private ServiceHandler serviceHandler = new ServiceHandler();

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ClaimBillInfo info = (ClaimBillInfo)model;
        IClaimAddNewService claimAddNewService = ClaimAddNewServiceFactory.getInstance(info.getClaimType());
        claimAddNewService.initService(ctx, info);
        claimAddNewService.beforeAddNew();
        IObjectPK pk = super._addnew(ctx, model);
        claimAddNewService.afterAddNew(pk);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ClaimBillInfo info = (ClaimBillInfo)model;
        IClaimSaveService claimSaveService = ClaimSaveServiceFactory.getInstance(info.getClaimType());
        claimSaveService.initService(ctx, info);
        claimSaveService.beforeSave();
        IObjectPK pk = super._save(ctx, model);
        claimSaveService.afterSave(pk);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ClaimBillInfo info = (ClaimBillInfo)model;
        IClaimSubmitService claimSubmitService = ClaimSubmitServiceFactory.getInstance(info.getClaimType());
        claimSubmitService.initService(ctx, info);
        claimSubmitService.beforeSubmit();
        IObjectPK pk = super._submit(ctx, model);
        claimSubmitService.afterSubmit(pk);
        return pk;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.id");
        sic.add("company.name");
        ClaimBillInfo info = this.getClaimBillInfo(ctx, pk, sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"claimBill_delete_06");
        if (!isPermission) {
            throw new NCException(NCException.NOT_DELETE_PERMISSION, new Object[]{info.getCompany().getName()});
        }
        if (info.getBillStatus() != ClaimBillSatusEnum.SAVE && info.getBillStatus() != ClaimBillSatusEnum.SUBMIT) {
            throw new NCException(NCException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"Only_SAVE_SUBIT_Delete")});
        }
        if (!info.getCreator().getId().toString().equals(ctx.getCaller().toString())) {
            throw new NCException(NCException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"Only_Self_Delete")});
        }
        NoticeBillInfo noticeBill = NoticeBillFactory.getLocalInstance(ctx).getNoticeBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
        if (noticeBill.getBillStatus() == NoticeBillSatusEnum.CONFIRMED) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"Already_CONFIRM_NOT_Delete")});
        }
        super._delete(ctx, pk);
        this.serviceHandler.reverseNoticeBill(ctx, info);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"nc_claimBill_delete");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.id");
        sic.add("company.name");
        ClaimBillInfo info = this.getClaimBillInfo(ctx, pk, sic);
        if (info.getBillStatus() != ClaimBillSatusEnum.SUBMIT) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"Only_SUBIT_Audit")});
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        String sql = "UPDATE T_NC_ClaimBill SET FAuditorID = ?, FAuditDate = ?, FBillStatus = ? WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString(), currTime, 3, pk.toString()});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"nc_claimBill_audit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.id");
        sic.add("company.name");
        ClaimBillInfo info = this.getClaimBillInfo(ctx, pk, sic);
        if (info.getBillStatus() != ClaimBillSatusEnum.AUDITED) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"Only_AUDITED_UnAudit")});
        }
        NoticeBillInfo noticeBill = NoticeBillFactory.getLocalInstance(ctx).getNoticeBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
        if (noticeBill.getBillStatus() == NoticeBillSatusEnum.CONFIRMED) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"Already_CONFIRM_NOT_UnAudit")});
        }
        String sql = "UPDATE T_NC_ClaimBill SET FAuditorID = null, FAuditDate = null, FBillStatus = ? WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{1, pk.toString()});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"nc_claimBill_unAudit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }
}

