/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nc.ClaimBillCollection;
import com.kingdee.eas.fm.nc.ClaimBillFactory;
import com.kingdee.eas.fm.nc.ClaimBillInfo;
import com.kingdee.eas.fm.nc.ClaimBillSatusEnum;
import com.kingdee.eas.fm.nc.IClaimBill;
import com.kingdee.eas.fm.nc.NCException;
import com.kingdee.eas.fm.nc.app.AbstractClaimBillWebFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ClaimBillWebFacadeControllerBean
extends AbstractClaimBillWebFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nc.app.ClaimBillWebFacadeControllerBean");
    private static final String NC_RESOURCE = "com.kingdee.eas.fm.nc.NCResource";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchSubmit(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        IClaimBill iClaimBill = ClaimBillFactory.getLocalInstance(ctx);
        Map requestResult = iMutex.batchRequestObjIDForUpdate(new ArrayList<String>(Arrays.asList(ids)));
        ClaimBillCollection coll = this.getClaimColls(ctx, ids);
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            ClaimBillInfo info = coll.get(i);
            boolean isCanUpdate = (Boolean)requestResult.get(info.getId().toString());
            try {
                this.checkPermission(ctx, info.getCompany(), "claimBill_submit_03", "Permission_NO_Submit", permissionSet);
                if (!isCanUpdate) {
                    throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{CASWebUtil.getResource((Context)ctx, (String)"HAS_LOCKED")});
                }
                if (info.getBillStatus() != ClaimBillSatusEnum.SAVE && info.getBillStatus() != ClaimBillSatusEnum.SUBMIT) {
                    throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"Only_SAVE_SUBIT_Submit")});
                }
                info.setBillStatus(ClaimBillSatusEnum.SUBMIT);
                iClaimBill.submit((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"nc_claimBill_submit");
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"ClaimBill_SUBMIT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"ClaimBill_SUBMIT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
                continue;
            }
            finally {
                if (isCanUpdate) {
                    iMutex.releaseObjIDForUpdate(info.getId().toString());
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_SUBMIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"SUBMIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        IClaimBill iClaimBill = ClaimBillFactory.getLocalInstance(ctx);
        Map requestResult = iMutex.batchRequestObjIDForUpdate(new ArrayList<String>(Arrays.asList(ids)));
        ClaimBillCollection coll = this.getClaimColls(ctx, ids);
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            ClaimBillInfo info = coll.get(i);
            boolean isCanUpdate = (Boolean)requestResult.get(info.getId().toString());
            try {
                this.checkPermission(ctx, info.getCompany(), "claimBill_audit_04", "Permission_NO_Audit", permissionSet);
                if (!isCanUpdate) {
                    throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{CASWebUtil.getResource((Context)ctx, (String)"HAS_LOCKED")});
                }
                if (info.getBillStatus() != ClaimBillSatusEnum.SUBMIT) {
                    throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"Only_SUBIT_Audit")});
                }
                iClaimBill.audit((IObjectPK)new ObjectUuidPK(info.getId()));
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"ClaimBill_Audit_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"ClaimBill_Audit_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
                continue;
            }
            finally {
                if (isCanUpdate) {
                    iMutex.releaseObjIDForUpdate(info.getId().toString());
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"ALL_Audit_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"Audit_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchUnAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        IClaimBill iClaimBill = ClaimBillFactory.getLocalInstance(ctx);
        Map requestResult = iMutex.batchRequestObjIDForUpdate(new ArrayList<String>(Arrays.asList(ids)));
        ClaimBillCollection coll = this.getClaimColls(ctx, ids);
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            ClaimBillInfo info = coll.get(i);
            boolean isCanUpdate = (Boolean)requestResult.get(info.getId().toString());
            try {
                this.checkPermission(ctx, info.getCompany(), "claimBill_unAudit_05", "Permission_NO_UnAudit", permissionSet);
                if (!isCanUpdate) {
                    throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{CASWebUtil.getResource((Context)ctx, (String)"HAS_LOCKED")});
                }
                if (info.getBillStatus() != ClaimBillSatusEnum.AUDITED) {
                    throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"Only_AUDITED_UnAudit")});
                }
                iClaimBill.unAudit((IObjectPK)new ObjectUuidPK(info.getId()));
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"ClaimBill_UNAUDIT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"ClaimBill_UNAUDIT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
                continue;
            }
            finally {
                if (isCanUpdate) {
                    iMutex.releaseObjIDForUpdate(info.getId().toString());
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"ALL_UNAUDIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"UNAUDIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    protected ClaimBillCollection getClaimColls(Context ctx, String[] ids) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        view.setFilter(filter);
        return ClaimBillFactory.getLocalInstance(ctx).getClaimBillCollection(view);
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        return sic;
    }

    protected void checkPermission(Context ctx, CompanyOrgUnitInfo company, String checkPermissionName, String exceptionResource, Set<String> permissionSet) throws EASBizException, BOSException {
        if (!permissionSet.contains(company.getId().toString())) {
            this.checkPermission(ctx, company, checkPermissionName, exceptionResource);
            permissionSet.add(company.getId().toString());
        }
    }

    protected void checkPermission(Context ctx, CompanyOrgUnitInfo company, String checkPermissionName, String exceptionResource) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId()), (String)checkPermissionName);
        if (!isPermission) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)exceptionResource, (String[])new String[]{company.getName()})});
        }
    }
}

