/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CASCommonWebFacadeFactory;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.nc.BizTypeEnum;
import com.kingdee.eas.fm.nc.ClaimBillEntryCollection;
import com.kingdee.eas.fm.nc.ClaimBillEntryFactory;
import com.kingdee.eas.fm.nc.ClaimBillEntryInfo;
import com.kingdee.eas.fm.nc.NCException;
import com.kingdee.eas.fm.nc.NoticeBillFactory;
import com.kingdee.eas.fm.nc.NoticeBillInfo;
import com.kingdee.eas.fm.nc.NoticeBillSatusEnum;
import com.kingdee.eas.fm.nc.NoticeEntryTransDetailCollection;
import com.kingdee.eas.fm.nc.NoticeEntryTransDetailFactory;
import com.kingdee.eas.fm.nc.NoticeEntryTransDetailInfo;
import com.kingdee.eas.fm.nc.app.AbstractNoticeBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class NoticeBillControllerBean
extends AbstractNoticeBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nc.app.NoticeBillControllerBean");
    private static final String NC_RESOURCE = "com.kingdee.eas.fm.nc.NCResource";
    private static final String TRNASDETAIL_BOSTYPE = new TransDetailInfo().getBOSType().toString();

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        NoticeBillInfo info = (NoticeBillInfo)model;
        this.verifyRequired(ctx, info);
        this.initNumber(ctx, info);
        this.checkNumberDup(ctx, info);
        this.setCommonPropertyValue(ctx, info);
        this.initAmout(ctx, info);
        this.checkDetailDup(ctx, info);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"nc_noticeBill_addnew");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return super._addnew(ctx, model);
    }

    public void verifyRequired(Context ctx, NoticeBillInfo info) throws BOSException, EASBizException {
        NoticeEntryTransDetailCollection entrys;
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"company");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"bizType");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"bizDate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"currency");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"amount");
        if (info.getBizType() == BizTypeEnum.RECEIVING && ((entrys = info.getTransDetailEntrys()) == null || entrys.size() == 0)) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"EntryTransDetail_Not_Null")});
        }
    }

    public void checkDetailDup(Context ctx, NoticeBillInfo info) throws BOSException, EASBizException {
        NoticeEntryTransDetailCollection entrys = info.getTransDetailEntrys();
        if (entrys != null && entrys.size() > 0) {
            NoticeEntryTransDetailInfo detailEntry = entrys.get(0);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("transDetailBillID", (Object)detailEntry.getTransDetailBillID()));
            if (NoticeEntryTransDetailFactory.getLocalInstance(ctx).exists(filter)) {
                throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"checkDetailDup", (String[])new String[]{detailEntry.getNumber()})});
            }
        }
    }

    public void initNumber(Context ctx, NoticeBillInfo info) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            return;
        }
        int i = 0;
        do {
            String numberSilent = null;
            try {
                numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            }
            catch (CodingRuleException e) {
                logger.info((Object)e);
            }
            if (EmptyUtil.isEmpty(numberSilent)) {
                return;
            }
            info.setNumber(numberSilent);
            filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)info, (boolean)true);
            ++i;
        } while (NoticeBillFactory.getLocalInstance(ctx).exists(filter));
    }

    public void checkNumberDup(Context ctx, NoticeBillInfo info) throws BOSException, EASBizException {
        String number = info.getNumber();
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        info.setNumber(info.getNumber().trim());
        FilterInfo filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)info, (boolean)true);
        if (this.exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{info.getNumber(), ""});
        }
    }

    public void setCommonPropertyValue(Context ctx, NoticeBillInfo info) throws EASBizException, BOSException {
        if (EmptyUtil.isEmpty((Object)((Object)info.getBillStatus()))) {
            info.setBillStatus(NoticeBillSatusEnum.UNCLAIM);
        }
        info.setIsGenClaim(false);
        info.setIsGenReceiving(false);
    }

    public void initAmout(Context ctx, NoticeBillInfo info) throws EASBizException, BOSException {
        String companyId = info.getCompany().getId().toString();
        String currencyId = info.getCurrency().getId().toString();
        info.setClaimedAmt(BigDecimal.ZERO);
        info.setUnClaimAmt(info.getAmount());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        if (currencyId.equals(company.getBaseCurrency().getId())) {
            info.setExchangeRate(BigDecimal.ONE);
            info.setLocalAmount(info.getAmount());
            info.setClaimedLocAmt(info.getClaimedAmt());
            info.setUnClaimLocAmt(info.getUnClaimAmt());
            return;
        }
        Date date = DateTimeUtils.truncateDate((Date)new Date());
        Map exchangeRate = CASCommonWebFacadeFactory.getLocalInstance((Context)ctx).getExchangeRate(companyId, currencyId, date);
        BigDecimal value = (BigDecimal)exchangeRate.get("exchangeRate");
        if (value.doubleValue() == 0.0) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"Please_Set_ExchangeRate")});
        }
        info.setExchangeRate(value);
        boolean isIndirectRate = (Integer)exchangeRate.get("isIndirectRate") == Integer.valueOf(1);
        int precision = company.getBaseCurrency().getPrecision();
        if (isIndirectRate) {
            info.setLocalAmount(info.getAmount().divide(value, precision, 4));
        } else {
            info.setLocalAmount(info.getAmount().multiply(value).setScale(precision, 4));
        }
        info.setClaimedLocAmt(BigDecimal.ZERO);
        info.setUnClaimLocAmt(info.getLocalAmount());
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        NoticeBillInfo info = (NoticeBillInfo)model;
        if (info.getUnClaimAmt().compareTo(BigDecimal.ZERO) < 0) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"UnClaimAmt_Less_Zero")});
        }
        ClaimBillEntryCollection entrys = info.getClaimEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            ClaimBillEntryInfo entry = entrys.get(i);
            if (entry.getActualAmt().compareTo(BigDecimal.ZERO) <= 0) {
                throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"EntryActualAmt_Less_Zero")});
            }
            if (entry.getRebate() == null) {
                entry.setRebate(BigDecimal.ZERO);
                entry.setRebateLocAmt(BigDecimal.ZERO);
            }
            if (entry.getCommission() != null) continue;
            entry.setCommission(BigDecimal.ZERO);
            entry.setCommissionLocAmt(BigDecimal.ZERO);
        }
        if (info.getUnClaimAmt().compareTo(BigDecimal.ZERO) == 0) {
            info.setBillStatus(NoticeBillSatusEnum.CLAIMED);
        }
        if (info.getUnClaimAmt().compareTo(BigDecimal.ZERO) > 0) {
            info.setBillStatus(NoticeBillSatusEnum.PARTCLAIM);
        }
        if (info.getCommissionTotal() == null) {
            info.setCommissionTotal(BigDecimal.ZERO);
        }
        this.reverseClaim(ctx, info);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"nc_noticeBill_save");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return super._save(ctx, (IObjectValue)info);
    }

    protected void reverseClaim(Context ctx, NoticeBillInfo info) throws BOSException, NCException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("noticeBill.id", (Object)info.getId().toString()));
        view.setFilter(filter);
        ClaimBillEntryCollection coll = ClaimBillEntryFactory.getLocalInstance(ctx).getClaimBillEntryCollection(view);
        if (coll.size() > info.getClaimEntrys().size()) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"ClaimEntry_add")});
        }
        HashMap<String, String> entryId_claimId = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            ClaimBillEntryInfo entry = coll.get(i);
            entryId_claimId.put(entry.getId().toString(), entry.getClaimBill().getId().toString());
        }
        ClaimBillEntryCollection entrys = info.getClaimEntrys();
        HashMap<String, BigDecimal> claimId_sumAmtMap = new HashMap<String, BigDecimal>();
        for (int i = 0; i < entrys.size(); ++i) {
            ClaimBillEntryInfo entry = entrys.get(i);
            String claimId = (String)entryId_claimId.get(entry.getId().toString());
            if (claimId == null) {
                throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"ClaimEntry_delete")});
            }
            BigDecimal commission = entry.getCommission();
            BigDecimal sumAmt = (BigDecimal)claimId_sumAmtMap.get(claimId);
            if (sumAmt == null) {
                sumAmt = BigDecimal.ZERO;
            }
            sumAmt = sumAmt.add(commission);
            claimId_sumAmtMap.put(claimId, sumAmt);
        }
        for (String claimId : claimId_sumAmtMap.keySet()) {
            BigDecimal sumAmt = (BigDecimal)claimId_sumAmtMap.get(claimId);
            String sql = " update T_NC_ClaimBill set FCommissionTotal=? where FID=? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{sumAmt, claimId});
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.id");
        sic.add("company.name");
        NoticeBillInfo info = this.getNoticeBillInfo(ctx, pk, sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"transDetailMatch_cancelNoticeClaim");
        if (!isPermission) {
            throw new NCException(NCException.NOT_DELETE_PERMISSION, new Object[]{info.getCompany().getName()});
        }
        if (info.getBillStatus() != NoticeBillSatusEnum.UNCLAIM) {
            throw new NCException(NCException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"Only_UNCLAIM_Delete")});
        }
        this.reverseDelete(ctx, info);
        super._delete(ctx, pk);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"nc_noticeBill_delete");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    protected void reverseDelete(Context ctx, NoticeBillInfo info) throws BOSException, EASBizException {
        ArrayList srcIdList = BOTRelationFactory.getLocalInstance((Context)ctx).getSrcObjIdBySrcType(info.getId().toString(), TRNASDETAIL_BOSTYPE);
        String deleteTransDetailSql = "";
        if (srcIdList.size() > 1) {
            deleteTransDetailSql = "update T_BE_TransDetail set FIsReced = ?, FrecedBillType = null, FRecedBillNumber = null where fid in " + FMHelper.setTran2String(new HashSet(srcIdList));
        } else if (srcIdList.size() == 1) {
            deleteTransDetailSql = "update T_BE_TransDetail set FIsReced = ?, FrecedBillType = null, FRecedBillNumber = null where fid = '" + srcIdList.get(0) + "'";
        }
        DbUtil.execute((Context)ctx, (String)deleteTransDetailSql, (Object[])new Object[]{0});
    }

    private void deleteBotpRelation(Context ctx, List<String> srcIdList, String destObjectId) throws BOSException {
        String sql = "delete T_BOT_Relation WHERE FDestObjectID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{destObjectId});
    }
}

