/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractBaseObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserRolePermCollection;
import com.kingdee.eas.base.permission.UserRolePermFactory;
import com.kingdee.eas.base.permission.UserRolePermInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.be.TransDetailRecedEnum;
import com.kingdee.eas.fm.be.TransdetailRecedBillTypeEnum;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nc.AbstractNoticeBillInfo;
import com.kingdee.eas.fm.nc.ClaimBillCollection;
import com.kingdee.eas.fm.nc.ClaimBillEntryCollection;
import com.kingdee.eas.fm.nc.ClaimBillEntryFactory;
import com.kingdee.eas.fm.nc.ClaimBillEntryInfo;
import com.kingdee.eas.fm.nc.ClaimBillInfo;
import com.kingdee.eas.fm.nc.ClaimBillSatusEnum;
import com.kingdee.eas.fm.nc.ClaimTypeEnum;
import com.kingdee.eas.fm.nc.INoticeBill;
import com.kingdee.eas.fm.nc.INoticeBillWebFacade;
import com.kingdee.eas.fm.nc.NCException;
import com.kingdee.eas.fm.nc.NoticeBillCollection;
import com.kingdee.eas.fm.nc.NoticeBillCompanysInfo;
import com.kingdee.eas.fm.nc.NoticeBillFactory;
import com.kingdee.eas.fm.nc.NoticeBillInfo;
import com.kingdee.eas.fm.nc.NoticeBillRolesInfo;
import com.kingdee.eas.fm.nc.NoticeBillSatusEnum;
import com.kingdee.eas.fm.nc.NoticeBillUsersCollection;
import com.kingdee.eas.fm.nc.NoticeBillUsersFactory;
import com.kingdee.eas.fm.nc.NoticeBillUsersInfo;
import com.kingdee.eas.fm.nc.NoticeBillWebFacadeFactory;
import com.kingdee.eas.fm.nc.NoticeEntryTransDetailCollection;
import com.kingdee.eas.fm.nc.NoticeEntryTransDetailInfo;
import com.kingdee.eas.fm.nc.app.AbstractNoticeBillWebFacadeControllerBean;
import com.kingdee.eas.fm.nc.app.ArClaimBillCommonUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class NoticeBillWebFacadeControllerBean
extends AbstractNoticeBillWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nc.app.NoticeBillWebFacadeControllerBean");
    private static final String NC_RESOURCE = "com.kingdee.eas.fm.nc.NCResource";
    private static String NOTICEBILL_BOSTYPE = new NoticeBillInfo().getBOSType().toString();
    private static String TRNASDETAIL_BOSTYPE = new TransDetailInfo().getBOSType().toString();
    private static String CLAIMBILL_BOSTYPE = new ClaimBillInfo().getBOSType().toString();
    private static String RECEIVING_BOSTYPE = new ReceivingBillInfo().getBOSType().toString();
    private String number = "";

    @Override
    protected Map _beforeARClaim(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        NoticeBillInfo info = NoticeBillFactory.getLocalInstance(ctx).getNoticeBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelector());
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), (String)"noticeBill_ar_claim_03");
        if (!isPermission) {
            throw new NCException(NCException.NO_AR_CLAIM_PERMISSION, new Object[]{info.getCompany().getName()});
        }
        if (info.getBillStatus() != NoticeBillSatusEnum.PARTCLAIM && info.getBillStatus() != NoticeBillSatusEnum.UNCLAIM) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"PART_UN_Can_EDIT")});
        }
        result.setError(0);
        return result;
    }

    @Override
    protected Map _beforeFMClaim(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        NoticeBillInfo info = NoticeBillFactory.getLocalInstance(ctx).getNoticeBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelector());
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), (String)"noticeBill_fm_claim_04");
        if (!isPermission) {
            throw new NCException(NCException.NO_FM_CLAIM_PERMISSION, new Object[]{info.getCompany().getName()});
        }
        if (info.getBillStatus() != NoticeBillSatusEnum.PARTCLAIM && info.getBillStatus() != NoticeBillSatusEnum.UNCLAIM) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"PART_UN_Can_EDIT")});
        }
        result.setError(0);
        return result;
    }

    @Override
    protected Map _beforeCash(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        NoticeBillInfo info = NoticeBillFactory.getLocalInstance(ctx).getNoticeBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelector());
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), (String)"noticeBill_edit_06");
        if (!isPermission) {
            throw new NCException(NCException.NO_CASH_PERMISSION, new Object[]{info.getCompany().getName()});
        }
        if (info.getBillStatus() != NoticeBillSatusEnum.PARTCLAIM && info.getBillStatus() != NoticeBillSatusEnum.CLAIMED) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"PART_ALL_Can_EDIT")});
        }
        result.setError(0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _noticeClaim(Context ctx, List idList, Map paramMap) throws BOSException, EASBizException {
        List sourceIdList = idList;
        BatchExecuteResult result = new BatchExecuteResult();
        int success = 0;
        String bosType = BOSUuid.read((String)((String)sourceIdList.get(0))).getType().toString();
        INoticeBillWebFacade iNoticeBillWebFacade = NoticeBillWebFacadeFactory.getLocalInstance(ctx);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isCanUpdate = false;
        for (int i = 0; i < sourceIdList.size(); ++i) {
            String sourceId = (String)sourceIdList.get(i);
            try {
                isCanUpdate = iMutex.requestObjIDForUpdate(sourceId);
                CoreBillBaseInfo sourceBill = this.getSourceBillInfo(ctx, bosType, sourceId);
                if (!isCanUpdate) {
                    throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{CASWebUtil.getResource((Context)ctx, (String)"HAS_LOCKED")});
                }
                iNoticeBillWebFacade.genOneNoticeBill(sourceBill, paramMap);
                ++success;
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\u751f\u6210\u901a\u77e5\u5355\u62a5\u9519\uff1a" + this.number));
                logger.error((Object)e);
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"NoticeClaim_FAIL", (String[])new String[]{this.number}) + e.getMessage());
                continue;
            }
            finally {
                if (isCanUpdate) {
                    iMutex.releaseObjIDForUpdate(sourceId);
                }
            }
        }
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{String.valueOf(idList.size())});
        summary = success == idList.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"ALL_CAOZUO_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"CAOZUO_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(idList.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    protected CoreBillBaseInfo getSourceBillInfo(Context ctx, String bosType, String sourceId) throws EASBizException, BOSException {
        TransDetailInfo info = null;
        if (TRNASDETAIL_BOSTYPE.equals(bosType)) {
            info = this.getTransDetailInfo(ctx, sourceId);
        }
        return info;
    }

    protected TransDetailInfo getTransDetailInfo(Context ctx, String sourceId) throws EASBizException, BOSException {
        TransDetailInfo info = TransDetailFactory.getLocalInstance((Context)ctx).getTransDetailInfo((IObjectPK)new ObjectUuidPK(sourceId), this.getSelector());
        this.number = info.getNumber();
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"transDetailMatch_noticeClaim");
        if (!isPermission) {
            throw new NCException(NCException.NO_NOTICECLAIM_PERMISSION, new Object[]{info.getCompany().getName()});
        }
        if (info.getIsReced() != TransDetailRecedEnum.toBeReced || info.isIsDebit()) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"NOT_Can_NoticeClaim")});
        }
        if (info.getCreditAmount().compareTo(BigDecimal.ZERO) < 0) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"NOT_Can_NoticeClaim")});
        }
        return info;
    }

    @Override
    protected void _genOneNoticeBill(Context ctx, CoreBillBaseInfo sourceBill, Map paramMap) throws BOSException, EASBizException {
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        sourceBillCollection.add(sourceBill);
        BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform(sourceBillCollection, NOTICEBILL_BOSTYPE);
        NoticeBillCollection noticeColl = (NoticeBillCollection)btpResult.getBills();
        if (noticeColl.size() == 0) {
            throw new NCException(NCException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"TRANS_Notice_Fail")});
        }
        NoticeBillInfo info = noticeColl.get(0);
        this.fillNoticeBillUsers(info, paramMap);
        NoticeBillFactory.getLocalInstance(ctx).addnew(info);
        String srcBosType = sourceBill.getBOSType().toString();
        if (TRNASDETAIL_BOSTYPE.equals(srcBosType)) {
            String sql = "update T_BE_TransDetail set FIsReced = ?, FrecedBillType = ?, FRecedBillNumber = ? where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{1, "6E18C7C3", info.getNumber(), sourceBill.getId().toString()});
        }
        this.saveBOTRelation(ctx, sourceBill.getId().toString(), info.getId().toString());
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)sourceBill.getBOSType(), null, (String)sourceBill.getId().toString(), (String)"nc_sourceBill_noticeClaim");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    private void fillNoticeBillUsers(NoticeBillInfo info, Map paramMap) {
        Set userIdSet = (Set)paramMap.get("userIdSet");
        Set roleIdSet = (Set)paramMap.get("roleIdSet");
        Set companyIdSet = (Set)paramMap.get("companyIdSet");
        for (String userId : userIdSet) {
            NoticeBillUsersInfo noticeBillUser = new NoticeBillUsersInfo();
            UserInfo user = new UserInfo();
            user.setId(BOSUuid.read((String)userId));
            noticeBillUser.setUser(user);
            info.getCanClaimUsers().add(noticeBillUser);
        }
        for (String roleId : roleIdSet) {
            NoticeBillRolesInfo noticeBillRole = new NoticeBillRolesInfo();
            RoleInfo role = new RoleInfo();
            role.setId(BOSUuid.read((String)roleId));
            noticeBillRole.setRole(role);
            info.getCanClaimRoles().add(noticeBillRole);
        }
        for (String companyId : companyIdSet) {
            NoticeBillCompanysInfo noticeBillCompany = new NoticeBillCompanysInfo();
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyId));
            noticeBillCompany.setCompany(company);
            info.getCanClaimCompanys().add(noticeBillCompany);
        }
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.name"));
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _cancelNoticeClaim(Context ctx, List idList) throws BOSException, EASBizException {
        List sourceIdList = idList;
        BatchExecuteResult result = new BatchExecuteResult();
        int success = 0;
        BOSObjectType bosType = BOSUuid.read((String)((String)sourceIdList.get(0))).getType();
        INoticeBill iNoticeBill = NoticeBillFactory.getLocalInstance(ctx);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        boolean isCanUpdate = false;
        for (int i = 0; i < sourceIdList.size(); ++i) {
            String sourceId = (String)sourceIdList.get(i);
            try {
                isCanUpdate = iMutex.requestObjIDForUpdate(sourceId);
                this.verifySourceBillInfo(ctx, bosType.toString(), sourceId);
                if (!isCanUpdate) {
                    throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{CASWebUtil.getResource((Context)ctx, (String)"HAS_LOCKED")});
                }
                ArrayList destIdList = iBOTRelation.getDestObjIdByDestType(sourceId, NOTICEBILL_BOSTYPE);
                if (destIdList == null || destIdList.size() == 0) {
                    throw new NCException(NCException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"DOWN_NOT_NOTICE")});
                }
                String noticeBillId = (String)destIdList.get(0);
                iNoticeBill.delete((IObjectPK)new ObjectUuidPK(noticeBillId));
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)bosType, null, (String)sourceId, (String)"nc_sourceBill_unNoticeClaim");
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                ++success;
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\u53d6\u6d88\u901a\u77e5\u5355\u62a5\u9519\uff1a" + this.number));
                logger.error((Object)e);
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"CancelNoticeClaim_FAIL", (String[])new String[]{this.number}) + e.getMessage());
                continue;
            }
            finally {
                if (isCanUpdate) {
                    iMutex.releaseObjIDForUpdate(sourceId);
                }
            }
        }
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{String.valueOf(idList.size())});
        summary = success == idList.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"ALL_CAOZUO_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"CAOZUO_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(idList.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    protected void verifySourceBillInfo(Context ctx, String bosType, String sourceId) throws EASBizException, BOSException {
        if (TRNASDETAIL_BOSTYPE.equals(bosType)) {
            this.verifyTransDetailInfo(ctx, sourceId);
        }
    }

    protected void verifyTransDetailInfo(Context ctx, String sourceId) throws EASBizException, BOSException {
        TransDetailInfo info = TransDetailFactory.getLocalInstance((Context)ctx).getTransDetailInfo((IObjectPK)new ObjectUuidPK(sourceId), this.getSelector());
        this.number = info.getNumber();
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"transDetailMatch_cancelNoticeClaim");
        if (!isPermission) {
            throw new NCException(NCException.NO_CANCELNOTICECLAIM_PERMISSION, new Object[]{info.getCompany().getName()});
        }
        if (info.getIsReced() != TransDetailRecedEnum.reced || info.getRecedBillType() != TransdetailRecedBillTypeEnum.NOTICE_BILL) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"NOT_Can_CancelNoticeClaim")});
        }
    }

    @Override
    protected Set _getBillIdSetByCurrentUser(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        UserInfo currentUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String currentUserId = currentUser.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        Set billIdSet = null;
        try {
            view.setFilter(filter);
            NoticeBillCollection coll = NoticeBillFactory.getLocalInstance(ctx).getNoticeBillCollection(view);
            billIdSet = CASWebUtil.collectionId2Set((AbstractBaseObjectCollection)coll);
            if (billIdSet.size() == 0) {
                return idSet;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        FilterInfo usersFilter = new FilterInfo();
        usersFilter.getFilterItems().add(new FilterItemInfo("user.id", (Object)currentUserId));
        if (billIdSet != null && billIdSet.size() > 0) {
            usersFilter.getFilterItems().add(new FilterItemInfo("noticeBill.id", (Object)billIdSet, CompareType.INCLUDE));
        }
        view.setFilter(usersFilter);
        NoticeBillUsersCollection usersColl = NoticeBillUsersFactory.getLocalInstance(ctx).getNoticeBillUsersCollection(view);
        for (int i = 0; i < usersColl.size(); ++i) {
            NoticeBillUsersInfo billUser = usersColl.get(i);
            idSet.add(billUser.getNoticeBill().getId().toString());
        }
        UserRolePermCollection UserRolePermColl = UserRolePermFactory.getLocalInstance((Context)ctx).getCollection(" where userId.id = '" + currentUserId + "'");
        for (int i = 0; i < UserRolePermColl.size(); ++i) {
            UserRolePermInfo userRolePerm = UserRolePermColl.get(i);
            String roleId = userRolePerm.getRoleId().getId().toString();
            String orgId = userRolePerm.getOrgId().getId().toString();
            StringBuffer sb = new StringBuffer();
            sb.append(" select head.FID as Fid from T_NC_NoticeBill head ");
            sb.append(" inner join T_NC_NoticeBillRoles role  on head.FID = role.FNoticeBillID ");
            sb.append(" inner join T_NC_NoticeBillCompanys com  on head.FID = com.FNoticeBillID ");
            sb.append(" where   role.FRoleID = ? ");
            sb.append(" and   com.FCompanyID = ? ");
            if (billIdSet != null && billIdSet.size() > 0) {
                sb.append(" and head.fid in ").append(FMHelper.setTran2String((Set)billIdSet));
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{roleId, orgId});
            try {
                while (rowSet.next()) {
                    idSet.add(rowSet.getString("Fid"));
                }
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return idSet;
    }

    @Override
    protected ClaimBillInfo _createClaimInfoByNoticeBill(Context ctx, String noticeBillId, String claimType) throws BOSException, EASBizException {
        NoticeBillInfo noticeBill = NoticeBillFactory.getLocalInstance(ctx).getNoticeBillInfo((IObjectPK)new ObjectUuidPK(noticeBillId));
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        sourceBillCollection.add((CoreBillBaseInfo)noticeBill);
        BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform(sourceBillCollection, CLAIMBILL_BOSTYPE);
        ClaimBillCollection claimColl = (ClaimBillCollection)btpResult.getBills();
        if (claimColl.size() == 0) {
            throw new NCException(NCException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"TRANS_Claim_Fail")});
        }
        ClaimBillInfo info = claimColl.get(0);
        info.setSourceBillId(noticeBill.getId().toString());
        info.setNoticeBillNumber(noticeBill.getNumber());
        info.setCompany(noticeBill.getCompany());
        info.setClaimType(ClaimTypeEnum.getEnum(claimType));
        info.setAmount(BigDecimal.ZERO);
        info.setLocalAmount(BigDecimal.ZERO);
        info.setBillStatus(ClaimBillSatusEnum.SAVE);
        NoticeEntryTransDetailCollection detailEntrys = noticeBill.getTransDetailEntrys();
        if (detailEntrys != null && detailEntrys.size() > 0) {
            NoticeEntryTransDetailInfo detailEntry = detailEntrys.get(0);
            String oppBankNumber = detailEntry.getOppBankNumber();
            String oppUnit = detailEntry.getOppUnit();
            CustomerInfo customer = null;
            customer = this.getCustomerByBankAccount(ctx, oppBankNumber, info);
            if (customer == null) {
                customer = this.getCustomerByName(ctx, oppUnit);
            }
            if (customer != null) {
                info.setAsstActType(this.getAsstActTypeCustomer(ctx));
                info.setAsstActId(customer.getId().toString());
                info.setAsstActName(customer.getName());
                info.setAsstActNumber(customer.getNumber());
            }
        }
        return info;
    }

    private CustomerInfo getCustomerByBankAccount(Context ctx, String bankAccount, ClaimBillInfo info) throws BOSException {
        if (EmptyUtil.isEmpty((String)bankAccount)) {
            return null;
        }
        CustomerInfo customerInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("customerCompanyInfo.customer.id"));
        sic.add(new SelectorItemInfo("customerCompanyInfo.customer.number"));
        sic.add(new SelectorItemInfo("customerCompanyInfo.customer.name"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccount", (Object)bankAccount));
        filter.getFilterItems().add(new FilterItemInfo("customerCompanyInfo.companyOrgUnit.id", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("customerCompanyInfo.customer.usedStatus", (Object)1));
        view.setFilter(filter);
        CustomerCompanyBankCollection coll = CustomerCompanyBankFactory.getLocalInstance((Context)ctx).getCustomerCompanyBankCollection(view);
        if (coll != null && coll.size() > 0) {
            customerInfo = coll.get(0).getCustomerCompanyInfo().getCustomer();
        }
        return customerInfo;
    }

    private CustomerInfo getCustomerByName(Context ctx, String name) throws BOSException {
        if (EmptyUtil.isEmpty((String)name)) {
            return null;
        }
        CustomerInfo customerInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)name));
        view.setFilter(filter);
        CustomerCollection coll = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection(view);
        if (coll != null && coll.size() > 0) {
            customerInfo = coll.get(0);
        }
        return customerInfo;
    }

    private AsstActTypeInfo getAsstActTypeCustomer(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("AsstHGAttribute", (Object)"customer", CompareType.EQUALS));
        view.setFilter(filter);
        AsstActTypeCollection asstActTypeCollection = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(view);
        return asstActTypeCollection.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _confirm(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        INoticeBillWebFacade noticeWebFacade = NoticeBillWebFacadeFactory.getLocalInstance(ctx);
        Map requestResult = iMutex.batchRequestObjIDForUpdate(new ArrayList<String>(Arrays.asList(ids)));
        NoticeBillCollection coll = this.getNoticeColls(ctx, ids);
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            NoticeBillInfo info = coll.get(i);
            boolean isCanUpdate = (Boolean)requestResult.get(info.getId().toString());
            try {
                this.checkPermission(ctx, info.getCompany(), "noticeBill_confirm_07", "Permission_NO_Confirm", permissionSet);
                if (!isCanUpdate) {
                    throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{CASWebUtil.getResource((Context)ctx, (String)"HAS_LOCKED")});
                }
                this.verifyConfirm(ctx, info);
                noticeWebFacade.genReceivingBill(info);
                ++success;
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"NoticeBill_CONFIRM_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
                continue;
            }
            finally {
                if (isCanUpdate) {
                    iMutex.releaseObjIDForUpdate(info.getId().toString());
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"ALL_CONFIRM_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"CONFIRM_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected void _genReceivingBill(Context ctx, NoticeBillInfo noticeBill) throws BOSException, EASBizException {
        String sql = " update T_NC_NoticeBill set FLastUpdateUserID = ? , FLastUpdateTime = ? where FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{ctx.getCaller().toString(), new Timestamp(System.currentTimeMillis()), noticeBill.getId().toString()});
        noticeBill = NoticeBillFactory.getLocalInstance(ctx).getNoticeBillInfo((IObjectPK)new ObjectUuidPK(noticeBill.getId()));
        this.verifyConfirm(ctx, noticeBill);
        HashMap<Integer, Object> biz_InfoMap = new HashMap<Integer, Object>();
        ClaimBillEntryCollection entrys = noticeBill.getClaimEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            ClaimBillEntryInfo entry = entrys.get(i);
            Integer bizBillType = entry.getBizBillType().getValue();
            Object info = (NoticeBillInfo)biz_InfoMap.get(bizBillType);
            if (info == null) {
                info = (NoticeBillInfo)noticeBill.clone();
                ((AbstractNoticeBillInfo)info).getClaimEntrys().clear();
                biz_InfoMap.put(bizBillType, info);
            }
            ((AbstractNoticeBillInfo)info).getClaimEntrys().add(entry);
        }
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        IReceivingBill iReceiving = ReceivingBillFactory.getLocalInstance((Context)ctx);
        StringBuffer numbers = new StringBuffer();
        for (Integer bizBillType : biz_InfoMap.keySet()) {
            NoticeBillInfo noticeInfo = (NoticeBillInfo)biz_InfoMap.get(bizBillType);
            CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
            sourceBillCollection.add((CoreBillBaseInfo)noticeInfo);
            BTPTransformResult btpResult = iBTPManager.transform(sourceBillCollection, RECEIVING_BOSTYPE);
            ReceivingBillCollection recColl = (ReceivingBillCollection)btpResult.getBills();
            if (recColl.size() == 0) {
                throw new NCException(NCException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"Trans_Receiving_Fail")});
            }
            ReceivingBillInfo info = recColl.get(0);
            info.setSourceBillId(noticeInfo.getId().toString());
            info.setBillStatus(BillStatusEnum.SAVE);
            ArClaimBillCommonUtils.setRecBillAfterTransform(ctx, info, noticeBill);
            iReceiving.save((CoreBaseInfo)info);
            this.saveRecRelaiton(ctx, noticeInfo, info, bizBillType);
            numbers.append(info.getNumber());
            numbers.append(";");
        }
        sql = "update T_NC_NoticeBill set FBillStatus = ?, FIsGenReceiving = ?, FConfirmerID = ?, FConfirmDate = ? where fid = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{4, true, ctx.getCaller().toString(), new Timestamp(System.currentTimeMillis()), noticeBill.getId().toString()});
        String bosType = BOSUuid.read((String)noticeBill.getSourceBillId()).getType().toString();
        if (TRNASDETAIL_BOSTYPE.equals(bosType)) {
            sql = "update T_BE_TransDetail set FIsReced = ?, FrecedBillType = ?, FRecedBillNumber = ? where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{1, "FA44FD5B", numbers.toString(), noticeBill.getSourceBillId()});
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)noticeBill.getBOSType(), null, (String)noticeBill.getNumber(), (String)"nc_noticeBill_confirm");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    protected void verifyConfirm(Context ctx, NoticeBillInfo noticeBill) throws EASBizException, BOSException {
        if (noticeBill.getBillStatus() != NoticeBillSatusEnum.PARTCLAIM && noticeBill.getBillStatus() != NoticeBillSatusEnum.CLAIMED) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"Only_PART_ALL_Confirm")});
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("noticeBill.id", (Object)noticeBill.getId()));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("claimBill.billStatus"));
        view.setSelector(sic);
        ClaimBillEntryCollection coll = ClaimBillEntryFactory.getLocalInstance(ctx).getClaimBillEntryCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            ClaimBillInfo claimBill = coll.get(i).getClaimBill();
            if (claimBill.getBillStatus() == ClaimBillSatusEnum.AUDITED) continue;
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"AllAudit_Can_Confirm")});
        }
    }

    protected void saveRecRelaiton(Context ctx, NoticeBillInfo noticeInfo, ReceivingBillInfo info, int bizBillType) throws BOSException {
        this.saveBOTRelation(ctx, noticeInfo.getId().toString(), info.getId().toString());
        this.saveBOTRelation(ctx, noticeInfo.getSourceBillId(), info.getId().toString());
        if (bizBillType != 1) {
            HashMap<String, String> relationMap = new HashMap<String, String>();
            ClaimBillEntryCollection claimEntrys = noticeInfo.getClaimEntrys();
            for (int i = 0; i < claimEntrys.size(); ++i) {
                relationMap.put(claimEntrys.get(i).getBizBillId(), info.getId().toString());
            }
            BOTPUtil.saveBOTRelation((Context)ctx, relationMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _unConfirm(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        INoticeBillWebFacade noticeWebFacade = NoticeBillWebFacadeFactory.getLocalInstance(ctx);
        Map requestResult = iMutex.batchRequestObjIDForUpdate(new ArrayList<String>(Arrays.asList(ids)));
        NoticeBillCollection coll = this.getNoticeColls(ctx, ids);
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            NoticeBillInfo info = coll.get(i);
            boolean isCanUpdate = (Boolean)requestResult.get(info.getId().toString());
            try {
                this.checkPermission(ctx, info.getCompany(), "noticeBill_unConfirm_08", "Permission_NO_UnConfirm", permissionSet);
                if (!isCanUpdate) {
                    throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{CASWebUtil.getResource((Context)ctx, (String)"HAS_LOCKED")});
                }
                if (info.getBillStatus() != NoticeBillSatusEnum.CONFIRMED) {
                    throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"Only_confirm_UnConfirm")});
                }
                noticeWebFacade.deleteRecBill(info);
                ++success;
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"NoticeBill_UNCONFIRM_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
                continue;
            }
            finally {
                if (isCanUpdate) {
                    iMutex.releaseObjIDForUpdate(info.getId().toString());
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"ALL_UNCONFIRM_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"UNCONFIRM_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected void _deleteRecBill(Context ctx, NoticeBillInfo noticeBill) throws BOSException, EASBizException {
        ArrayList srcIdList = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(noticeBill.getId().toString(), RECEIVING_BOSTYPE);
        HashSet idSet = new HashSet(srcIdList);
        ArrayList<String> requestList = new ArrayList<String>();
        IReceivingBill iReceiving = ReceivingBillFactory.getLocalInstance((Context)ctx);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            ctx.put((Object)"fromNoticeDelete", (Object)true);
            Map resultRequest = iMutex.batchRequestObjIDForUpdate((List)srcIdList);
            for (int i = 0; i < srcIdList.size(); ++i) {
                Boolean boolResult = (Boolean)resultRequest.get(srcIdList.get(i));
                if (!boolResult.booleanValue()) {
                    throw new Exception(CASWebUtil.getResource((Context)ctx, (String)"610_CantOpreateWhileOtherUse"));
                }
                requestList.add((String)srcIdList.get(i));
            }
            for (String receivingId : idSet) {
                iReceiving.delete((IObjectPK)new ObjectUuidPK(receivingId));
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u901a\u77e5\u5355\u53d6\u6d88\u786e\u8ba4\u8ba4\u9886\u7ed3\u679c\uff0c\u5220\u9664\u6536\u6b3e\u5355\u5931\u8d25\uff1a");
            logger.error((Object)e);
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"DELETE_RECBILL_FAIL") + e.getMessage()});
        }
        finally {
            ctx.remove((Object)"fromNoticeDelete");
            iMutex.batchReleaseObjIDForUpdate(requestList);
        }
        int status = 2;
        if (noticeBill.getUnClaimAmt().compareTo(BigDecimal.ZERO) == 0) {
            status = 3;
        }
        String sql = "update T_NC_NoticeBill set FBillStatus = ?, FIsGenReceiving = ?, FConfirmerID = null, FConfirmDate = null where fid = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{status, false, noticeBill.getId().toString()});
        String bosType = BOSUuid.read((String)noticeBill.getSourceBillId()).getType().toString();
        if (TRNASDETAIL_BOSTYPE.equals(bosType)) {
            sql = "update T_BE_TransDetail set FIsReced = ?, FrecedBillType = ?, FRecedBillNumber = ? where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{1, "6E18C7C3", noticeBill.getNumber(), noticeBill.getSourceBillId()});
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)noticeBill.getBOSType(), null, (String)noticeBill.getNumber(), (String)"nc_noticeBill_unConfirm");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    protected NoticeBillCollection getNoticeColls(Context ctx, String[] ids) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        view.setFilter(filter);
        return NoticeBillFactory.getLocalInstance(ctx).getNoticeBillCollection(view);
    }

    protected void saveBOTRelation(Context ctx, String sourceBillId, String destBillId) throws BOSException {
        HashMap<String, String> relationMap = new HashMap<String, String>();
        relationMap.put(sourceBillId, destBillId);
        BOTPUtil.saveBOTRelation((Context)ctx, relationMap);
    }

    protected void checkPermission(Context ctx, CompanyOrgUnitInfo company, String checkPermissionName, String exceptionResource, Set<String> permissionSet) throws EASBizException, BOSException {
        if (!permissionSet.contains(company.getId().toString())) {
            this.checkPermission(ctx, company, checkPermissionName, exceptionResource);
            permissionSet.add(company.getId().toString());
        }
    }

    protected void checkPermission(Context ctx, CompanyOrgUnitInfo company, String checkPermissionName, String exceptionResource) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId()), (String)checkPermissionName);
        if (!isPermission) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)exceptionResource, (String[])new String[]{company.getName()})});
        }
    }
}

