/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nc.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.nc.ClaimBillFactory;
import com.kingdee.eas.fm.nc.ClaimBillInfo;
import com.kingdee.eas.fm.nc.app.service.IClaimAddNewService;
import com.kingdee.eas.fm.nc.app.service.ServiceHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ClaimAddNewService
implements IClaimAddNewService {
    private static Logger logger = Logger.getLogger((String)ClaimAddNewService.class.getName());
    protected Context ctx;
    protected ClaimBillInfo info;
    protected ServiceHandler serviceHandler;
    protected static final String NC_RESOURCE = "com.kingdee.eas.fm.nc.NCResource";

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, ClaimBillInfo info) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.info = info;
        this.serviceHandler = this.getServiceHandler();
    }

    @Override
    public void beforeAddNew() throws EASBizException, BOSException {
        this.initNumber(this.ctx, this.info);
        this.checkNumberDup(this.ctx, this.info);
        this.serviceHandler.defaultData(this.ctx, this.info);
    }

    public void initNumber(Context ctx, ClaimBillInfo info) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            return;
        }
        int i = 0;
        do {
            String numberSilent = null;
            try {
                numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            }
            catch (CodingRuleException e) {
                logger.info((Object)e);
            }
            if (EmptyUtil.isEmpty(numberSilent)) {
                return;
            }
            info.setNumber(numberSilent);
            filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)info, (boolean)true);
            ++i;
        } while (ClaimBillFactory.getLocalInstance(ctx).exists(filter));
    }

    public void checkNumberDup(Context ctx, ClaimBillInfo info) throws BOSException, EASBizException {
        String number = info.getNumber();
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        info.setNumber(info.getNumber().trim());
        FilterInfo filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)info, (boolean)true);
        if (ClaimBillFactory.getLocalInstance(ctx).exists(filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{info.getNumber(), ""});
        }
    }

    @Override
    public void afterAddNew(IObjectPK pk) throws EASBizException, BOSException {
        String sql = " update T_NC_NoticeBill set FIsGenClaim = 1 where FID = ? ";
        DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{this.info.getSourceBillId()});
        this.saveBOTRelation();
        IObjectPK pkOut = LogUtil.beginLog((Context)this.ctx, null, (BOSObjectType)this.info.getBOSType(), null, (String)this.info.getNumber(), (String)"nc_claimBill_addnew");
        LogUtil.afterLog((Context)this.ctx, (IObjectPK)pkOut);
    }

    public void saveBOTRelation() throws BOSException {
        HashMap<String, String> relationMap = new HashMap<String, String>();
        relationMap.put(this.info.getSourceBillId(), this.info.getId().toString());
        BOTPUtil.saveBOTRelation((Context)this.ctx, relationMap);
    }
}

