/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nc.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.nc.ClaimBillInfo;
import com.kingdee.eas.fm.nc.ClaimBillSatusEnum;
import com.kingdee.eas.fm.nc.NCException;
import com.kingdee.eas.fm.nc.app.service.IClaimSubmitService;
import com.kingdee.eas.fm.nc.app.service.ServiceHandler;
import org.apache.log4j.Logger;

public class ClaimSubmitService
implements IClaimSubmitService {
    private static Logger logger = Logger.getLogger((String)ClaimSubmitService.class.getName());
    protected Context ctx;
    protected ClaimBillInfo info;
    protected ServiceHandler serviceHandler;
    private static final String NC_RESOURCE = "com.kingdee.eas.fm.nc.NCResource";

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, ClaimBillInfo info) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.info = info;
        this.serviceHandler = this.getServiceHandler();
    }

    @Override
    public void beforeSubmit() throws EASBizException, BOSException {
        this.hasFunctionPermission();
        this.verifyBillStatus();
        this.serviceHandler.verifyHead(this.ctx, this.info);
        this.serviceHandler.verifyEntry(this.ctx, this.info);
        this.serviceHandler.verifyAmount(this.ctx, this.info);
        this.serviceHandler.defaultData(this.ctx, this.info);
    }

    protected void hasFunctionPermission() throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)this.ctx, (IObjectPK)this.ctx.getCaller(), (IObjectPK)new ObjectUuidPK(this.info.getCompany().getId()), (String)"claimBill_submit_03");
        if (!isPermission) {
            throw new NCException(NCException.NO_CLAIMSUMIT_PERMISSION, new Object[]{this.info.getCompany().getName()});
        }
    }

    protected void verifyBillStatus() throws NCException {
        if (this.info.getBillStatus() != ClaimBillSatusEnum.SAVE && this.info.getBillStatus() != ClaimBillSatusEnum.SUBMIT) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)this.ctx, (String)NC_RESOURCE, (String)"Only_SAVE_SUBIT_Submit")});
        }
        this.info.setBillStatus(ClaimBillSatusEnum.SUBMIT);
    }

    @Override
    public void afterSubmit(IObjectPK pk) throws EASBizException, BOSException {
        this.serviceHandler.reverseNoticeBill(this.ctx, this.info);
        IObjectPK pkOut = LogUtil.beginLog((Context)this.ctx, null, (BOSObjectType)this.info.getBOSType(), null, (String)this.info.getNumber(), (String)"nc_claimBill_submit");
        LogUtil.afterLog((Context)this.ctx, (IObjectPK)pkOut);
    }
}

