/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nc.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.nc.BizBillTypeEnum;
import com.kingdee.eas.fm.nc.ClaimBillEntryCollection;
import com.kingdee.eas.fm.nc.ClaimBillEntryFactory;
import com.kingdee.eas.fm.nc.ClaimBillEntryInfo;
import com.kingdee.eas.fm.nc.ClaimBillInfo;
import com.kingdee.eas.fm.nc.NCException;
import com.kingdee.eas.fm.nc.NoticeBillFactory;
import com.kingdee.eas.fm.nc.NoticeBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServiceHandler {
    private static Logger logger = Logger.getLogger((String)ServiceHandler.class.getName());
    protected static final String NC_RESOURCE = "com.kingdee.eas.fm.nc.NCResource";

    public void verifyHead(Context ctx, ClaimBillInfo info) throws BOSException, EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"company");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"asstActType");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"asstActId");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"currency");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"exchangeRate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"noticeBillNumber");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"noticeBillAmt");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"noticeBillLocAmt");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"noticeUnClaimAmt");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"noticeUnClaimLocAmt");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"amount");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"localAmount");
    }

    public void verifyEntry(Context ctx, ClaimBillInfo info) throws BOSException, EASBizException {
        ClaimBillEntryCollection entrys = info.getEntrys();
        if (entrys == null || entrys.size() == 0) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"Entry_Not_Null")});
        }
        for (int i = 0; i < entrys.size(); ++i) {
            ClaimBillEntryInfo entry = entrys.get(i);
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)entry, (String)"recBillType");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)entry, (String)"amount");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)entry, (String)"localAmount");
            if (entry.getAmount().compareTo(BigDecimal.ZERO) <= 0) {
                throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"EntryAmt_Less_Zero", (String[])new String[]{String.valueOf(i + 1)})});
            }
            if (entry.getRebate() == null) {
                entry.setRebate(BigDecimal.ZERO);
                entry.setRebateLocAmt(BigDecimal.ZERO);
            }
            if (entry.getCommission() == null) {
                entry.setCommission(BigDecimal.ZERO);
                entry.setCommissionLocAmt(BigDecimal.ZERO);
            }
            entry.setActualAmt(entry.getAmount().subtract(entry.getRebate()).subtract(entry.getCommission()));
            entry.setActualLocAmt(entry.getLocalAmount().subtract(entry.getRebateLocAmt()).subtract(entry.getCommissionLocAmt()));
            if (entry.getActualAmt().compareTo(BigDecimal.ZERO) <= 0) {
                throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"EntryActualAmt_Less_Zero")});
            }
            if (entry.getCanClaimAmt() == null) {
                entry.setCanClaimAmt(BigDecimal.ZERO);
                entry.setCanClaimLocAmt(BigDecimal.ZERO);
            }
            if (!EmptyUtil.isEmpty((String)entry.getBizBillNumber()) && entry.getAmount().compareTo(entry.getCanClaimAmt()) > 0) {
                throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"EntryAmt_GreaterThan_CanClaimAmt")});
            }
            if (EmptyUtil.isEmpty((Object)((Object)entry.getBizBillType()))) {
                entry.setBizBillType(BizBillTypeEnum.NULL);
            }
            if (entry.getBizBillType() == BizBillTypeEnum.NULL || !EmptyUtil.isEmpty((String)entry.getBizBillId())) continue;
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"EntryBizBill_Not_Null")});
        }
    }

    public void verifyAmount(Context ctx, ClaimBillInfo info) throws EASBizException, BOSException {
        ClaimBillEntryCollection currentClaimEntrys = info.getEntrys();
        Map<String, BigDecimal> sumEntryAmt = this.sumEntryAmt(currentClaimEntrys);
        BigDecimal sumAmount = sumEntryAmt.get("sumAmount");
        BigDecimal sumRebate = sumEntryAmt.get("sumRebate");
        BigDecimal sumCommission = sumEntryAmt.get("sumCommission");
        this.lockNoticeBill(ctx, info);
        NoticeBillInfo noticeBill = NoticeBillFactory.getLocalInstance(ctx).getNoticeBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("noticeBill.id", (Object)noticeBill.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("claimBill.id", (Object)info.getId(), CompareType.NOTEQUALS));
        view.setFilter(filter);
        ClaimBillEntryCollection otherClaimEntrys = ClaimBillEntryFactory.getLocalInstance(ctx).getClaimBillEntryCollection(view);
        Map<String, BigDecimal> sumOtherEntryAmt = this.sumEntryAmt(otherClaimEntrys);
        sumAmount = sumAmount.add(sumOtherEntryAmt.get("sumAmount"));
        sumRebate = sumRebate.add(sumOtherEntryAmt.get("sumRebate"));
        sumCommission = sumCommission.add(sumOtherEntryAmt.get("sumCommission"));
        BigDecimal canClaimAmt = noticeBill.getAmount().add(sumRebate).add(sumCommission);
        if (sumAmount.compareTo(canClaimAmt) > 0) {
            throw new NCException(NCException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NC_RESOURCE, (String)"ARClaimAmt_GreaterThan_unClaimAmt", (String[])new String[]{sumAmount.toString(), canClaimAmt.toString()})});
        }
    }

    public void lockNoticeBill(Context ctx, ClaimBillInfo info) throws BOSException {
        String sql = " update T_NC_NoticeBill set FLastUpdateUserID = ? , FLastUpdateTime = ? where FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{ctx.getCaller().toString(), new Timestamp(System.currentTimeMillis()), info.getSourceBillId()});
    }

    public void defaultData(Context ctx, ClaimBillInfo info) throws BOSException, EASBizException {
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        NoticeBillInfo noticeBill = NoticeBillFactory.getLocalInstance(ctx).getNoticeBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            ClaimBillEntryInfo entry = info.getEntrys().get(i);
            entry.setClaimBillNumber(info.getNumber());
            entry.setCreator(user);
            entry.setNoticeBill(noticeBill);
        }
    }

    public void reverseNoticeBill(Context ctx, ClaimBillInfo info) throws BOSException, EASBizException {
        NoticeBillInfo noticeBill = NoticeBillFactory.getLocalInstance(ctx).getNoticeBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
        ClaimBillEntryCollection entrys = noticeBill.getClaimEntrys();
        Map<String, BigDecimal> sumEntryAmt = this.sumEntryAmt(entrys);
        BigDecimal sumAmount = sumEntryAmt.get("sumAmount");
        BigDecimal sumLocalAmount = sumEntryAmt.get("sumLocalAmount");
        BigDecimal sumRebate = sumEntryAmt.get("sumRebate");
        BigDecimal sumRebateLocAmt = sumEntryAmt.get("sumRebateLocAmt");
        BigDecimal sumCommission = sumEntryAmt.get("sumCommission");
        BigDecimal sumCommissionLocAmt = sumEntryAmt.get("sumCommissionLocAmt");
        BigDecimal claimedAmt = sumAmount;
        BigDecimal claimedLocAmt = sumLocalAmount;
        BigDecimal unClaimAmt = noticeBill.getAmount().add(sumRebate).add(sumCommission).subtract(claimedAmt);
        BigDecimal unClaimLocAmt = noticeBill.getLocalAmount().add(sumRebateLocAmt).add(sumCommissionLocAmt).subtract(claimedLocAmt);
        boolean isGenClaim = true;
        int status = 2;
        if (unClaimAmt.compareTo(BigDecimal.ZERO) == 0) {
            status = 3;
        }
        if (claimedAmt.compareTo(BigDecimal.ZERO) == 0) {
            status = 1;
            isGenClaim = false;
        }
        String sql = "update T_NC_NoticeBill set FCommissionTotal=?,FClaimedAmt=?,FClaimedLocAmt=?,FUnClaimAmt=?,FUnClaimLocAmt=?,FBillStatus=?,FIsGenClaim=? where FID=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{sumCommission, claimedAmt, claimedLocAmt, unClaimAmt, unClaimLocAmt, status, isGenClaim, info.getSourceBillId()});
    }

    protected Map<String, BigDecimal> sumEntryAmt(ClaimBillEntryCollection entrys) {
        HashMap<String, BigDecimal> sumAmtMap = new HashMap<String, BigDecimal>();
        BigDecimal sumAmount = BigDecimal.ZERO;
        BigDecimal sumLocalAmount = BigDecimal.ZERO;
        BigDecimal sumRebate = BigDecimal.ZERO;
        BigDecimal sumRebateLocAmt = BigDecimal.ZERO;
        BigDecimal sumCommission = BigDecimal.ZERO;
        BigDecimal sumCommissionLocAmt = BigDecimal.ZERO;
        for (int i = 0; i < entrys.size(); ++i) {
            ClaimBillEntryInfo entry = entrys.get(i);
            BigDecimal amount = entry.getAmount();
            sumAmount = sumAmount.add(amount);
            BigDecimal localAmount = entry.getLocalAmount();
            sumLocalAmount = sumLocalAmount.add(localAmount);
            BigDecimal rebate = entry.getRebate();
            sumRebate = sumRebate.add(rebate);
            BigDecimal rebateLocAmt = entry.getRebateLocAmt();
            sumRebateLocAmt = sumRebateLocAmt.add(rebateLocAmt);
            BigDecimal commission = entry.getCommission();
            sumCommission = sumCommission.add(commission);
            BigDecimal commissionLocAmt = entry.getCommissionLocAmt();
            sumCommissionLocAmt = sumCommissionLocAmt.add(commissionLocAmt);
        }
        sumAmtMap.put("sumAmount", sumAmount);
        sumAmtMap.put("sumLocalAmount", sumLocalAmount);
        sumAmtMap.put("sumRebate", sumRebate);
        sumAmtMap.put("sumRebateLocAmt", sumRebateLocAmt);
        sumAmtMap.put("sumCommission", sumCommission);
        sumAmtMap.put("sumCommissionLocAmt", sumCommissionLocAmt);
        return sumAmtMap;
    }
}

