/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.IBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.nt.AssureAmountFactory;
import com.kingdee.eas.fm.nt.AssureAmountInfo;
import com.kingdee.eas.fm.nt.IAssureAmount;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class AssureAmountBookNotifyBuilder
implements IBookNotifyBuilder {
    private SelectorItemCollection getSelector() {
        SelectorItemCollection cel = new SelectorItemCollection();
        cel.add("*");
        cel.add("company.id");
        cel.add("payAcct.*");
        cel.add("assureAcct.*");
        return cel;
    }

    private AssureAmountInfo getAssureAmountInfo(Context ctx, String billId) throws BOSException, EASBizException {
        IAssureAmount AssureAmount2 = AssureAmountFactory.getLocalInstance(ctx);
        AssureAmountInfo AssureAmountInfo2 = AssureAmount2.getAssureAmountInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return AssureAmountInfo2;
    }

    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        JournalCollection journalCollection = new JournalCollection();
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        AssureAmountInfo aaInfo = this.getAssureAmountInfo(ctx, billId);
        JournalInfo creditJournalInfo = this.createJournal(ctx, aaInfo);
        JournalInfo deditJournalInfo = (JournalInfo)creditJournalInfo.clone();
        deditJournalInfo.setAccountBank(aaInfo.getAssureAcct());
        deditJournalInfo.setCreditAmount(Constants.ZERO);
        deditJournalInfo.setDebitAmount(aaInfo.getAmount());
        deditJournalInfo.setAccountView(aaInfo.getAssureAcct().getAccount());
        journalCollection.add(creditJournalInfo);
        journalCollection.add(deditJournalInfo);
        AssureAmountBookNotifyBuilder.insertCashier(ctx, userInfo.getId().toString(), aaInfo.getId().toString());
        return journalCollection;
    }

    private JournalInfo createJournal(Context ctx, AssureAmountInfo aaInfo) throws BOSException, EASBizException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setCompany(aaInfo.getCompany());
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(aaInfo.getId().toString());
        journalInfo.setAccountBank(aaInfo.getPayAcct());
        journalInfo.setCurrency(aaInfo.getCurrency());
        CompanyOrgUnitInfo companyInfo1 = aaInfo.getCompany();
        Date bookDate = this.getBookDate(ctx, aaInfo, companyInfo1);
        journalInfo.setCreateDate(bookDate);
        journalInfo.setDebitAmount(Constants.ZERO);
        journalInfo.setCreditAmount(aaInfo.getAmount());
        journalInfo.setBillType(BillTypeEnum.caution);
        journalInfo.setBillNumber(aaInfo.getPayablebill());
        journalInfo.setBizDate(aaInfo.getBizDate());
        journalInfo.setAccountView(aaInfo.getPayAcct().getAccount());
        journalInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"136_AssureAmountBookNotifyBuilder", (Locale)ctx.getLocale()));
        journalInfo.setType(JournalTypeEnum.BANK);
        PeriodInfo bookPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bookDate, (CompanyOrgUnitInfo)companyInfo1);
        journalInfo.setPeriod(bookPeriodInfo);
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        journalInfo.setCashier(userInfo);
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        return journalInfo;
    }

    private Date getBookDate(Context ctx, AssureAmountInfo manageInfo, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriodInfo == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"current Period"});
        }
        Date bookDate = manageInfo.getBizDate();
        if (bookDate.before(currPeriodInfo.getBeginDate())) {
            bookDate = currPeriodInfo.getBeginDate();
        }
        return bookDate;
    }

    public static void insertCashier(Context ctx, String userId, String feeId) throws BOSException {
        String strSql = "update t_nt_AssureAmount set FCashierID = ";
        strSql = userId == null ? strSql + userId + " where fid = '" + feeId + "'" : strSql + "'" + userId + "' where fid = '" + feeId + "'";
        DbUtil.execute((Context)ctx, (String)strSql);
    }

    public JournalCollection getJournalColl(Context ctx, Set idSet) throws BOSException, EASBizException {
        JournalCollection journalCollection = new JournalCollection();
        if (idSet == null || idSet.size() == 0) {
            return journalCollection;
        }
        Iterator iterator = idSet.iterator();
        while (iterator.hasNext()) {
            journalCollection.addCollection(this.getJournalColl(ctx, iterator.next().toString()));
        }
        return journalCollection;
    }
}

