/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.nt.AssureAmountReturnBillFactory;
import com.kingdee.eas.fm.nt.AssureAmountReturnBillInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Date;
import java.util.Locale;

public class AssureAmountReturnBillBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        AssureAmountReturnBillInfo info = this.getAssureAmountReturnBillInfo(ctx, billId);
        JournalCollection journalColl = new JournalCollection();
        JournalInfo journalInfoDebit = this.createJournalInfoAmtDebit(ctx, info);
        JournalInfo journalInfoCredit = this.createJournalInfoAmtCredit(ctx, info);
        journalColl.add(journalInfoDebit);
        journalColl.add(journalInfoCredit);
        return journalColl;
    }

    private JournalInfo createJournalInfoAmtCredit(Context ctx, AssureAmountReturnBillInfo info) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(info.getAssureAccount());
        journalInfo.setCurrency(info.getCurrency());
        journalInfo.setCreateDate(new Date());
        journalInfo.setDebitAmount(Constants.ZERO);
        journalInfo.setCreditAmount(info.getTotalAmount());
        journalInfo.setIsDebit(false);
        journalInfo.setBizDate(info.getCreateDate());
        journalInfo.setAccountView(info.getAssureAccount().getAccount());
        journalInfo.setBillType(BillTypeEnum.assureReturn);
        journalInfo.setBillId(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        journalInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"431_AssureAmountReturnBillBook", (Locale)ctx.getLocale()));
        journalInfo.setCompany(info.getCompany());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        return journalInfo;
    }

    private JournalInfo createJournalInfoAmtDebit(Context ctx, AssureAmountReturnBillInfo info) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(info.getRecAccount());
        journalInfo.setCurrency(info.getCurrency());
        journalInfo.setCreateDate(new Date());
        journalInfo.setDebitAmount(info.getTotalAmount());
        journalInfo.setCreditAmount(Constants.ZERO);
        journalInfo.setIsDebit(true);
        journalInfo.setBizDate(info.getCreateDate());
        journalInfo.setAccountView(info.getRecAccount().getAccount());
        journalInfo.setBillType(BillTypeEnum.assureReturn);
        journalInfo.setBillId(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        journalInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"431_AssureAmountReturnBillBook", (Locale)ctx.getLocale()));
        journalInfo.setCompany(info.getCompany());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        return journalInfo;
    }

    private AssureAmountReturnBillInfo getAssureAmountReturnBillInfo(Context ctx, String billId) throws EASBizException, BOSException {
        AssureAmountReturnBillInfo info = AssureAmountReturnBillFactory.getLocalInstance(ctx).getAssureAmountReturnBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return info;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("assureAccount.account.*");
        sic.add("recAccount.account.*");
        return sic;
    }
}

