/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ICheque;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.Date;

public class ChequeDisposer
implements IPaymentDisposer {
    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        PaymentBillInfo paymentInfo = (PaymentBillInfo)action.getDestBill();
        PaymentBillEntryCollection entries = paymentInfo.getEntries();
        if (paymentInfo == null || entries == null || entries.size() < 1) {
            return;
        }
        DisposerActionEnum actionType = action.getActionType();
        int l = entries.size();
        for (int i = 0; i < l; ++i) {
            String sourceBillId = entries.get(i).getSourceBillId();
            if (sourceBillId == null) continue;
            this.doDispose(ctx, paymentInfo, sourceBillId, actionType);
        }
    }

    private void doDispose(Context ctx, PaymentBillInfo paymentInfo, String sourceBillId, DisposerActionEnum actionType) throws BOSException, EASBizException {
        IContextHelper ctxHelper;
        int val;
        if (DisposerActionEnum.DELETE.equals((Object)actionType)) {
            String sql = "update T_NT_Cheque set FPaymentBillNum =null where fid= ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{sourceBillId});
        } else if (DisposerActionEnum.SAVE.equals((Object)actionType)) {
            String sql = "UPDATE T_NT_CHEQUE SET FPAYMENTBILLNUM = ? WHERE FID = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{paymentInfo.getNumber(), sourceBillId});
        } else if (DisposerActionEnum.SUBMIT.equals((Object)actionType)) {
            String sql = "UPDATE T_NT_CHEQUE SET FPAYMENTBILLNUM = ? WHERE FID = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{paymentInfo.getNumber(), sourceBillId});
        } else if (DisposerActionEnum.PAY.equals((Object)actionType)) {
            ChequeInfo chequeInfo = ChequeFactory.getLocalInstance(ctx).getChequeInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
            IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
            int val2 = localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(localInstance.getCurrentCompany().getId()));
            if (val2 == 0) {
                JournalInfo jInfo;
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("billid", (Object)paymentInfo.getId()));
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filterInfo);
                JournalCollection journalCol = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
                if (journalCol.size() > 0 && (jInfo = journalCol.get(0)) != null) {
                    ICheque icheque = ChequeFactory.getLocalInstance(ctx);
                    icheque.vc(chequeInfo.getId().toString(), jInfo);
                }
            }
        } else if (actionType.equals((Object)DisposerActionEnum.CANCEL_PAY) && (val = (ctxHelper = ContextHelperFactory.getLocalInstance((Context)ctx)).getIntParam("CS001", (IObjectPK)new ObjectUuidPK(ctxHelper.getCurrentCompany().getId()))) == 0) {
            StringBuffer sql = new StringBuffer();
            sql.append(" update T_NT_Cheque set FIsVC = 0,");
            sql.append(" FJournalID = null ");
            sql.append(" where fid ='").append(sourceBillId).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    public BigDecimal getCashRebate(Date billDate, BigDecimal apAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }
}

