/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;

public class ChequeHelper {
    public static boolean isCanDistribute(ChequeInfo info) {
        boolean flag = false;
        if (ChequeStatusEnum.STORE.equals((Object)info.getState()) && info.getCashier() == null && info.getPaymentBillNum() == null && !info.isIsVC()) {
            flag = true;
        }
        return flag;
    }

    public static boolean isCanCancelDistribute(ChequeInfo info) {
        return ChequeStatusEnum.NEW.equals((Object)info.getState());
    }

    public static boolean isCanApply(ChequeInfo info) {
        return ChequeStatusEnum.NEW.equals((Object)info.getState());
    }

    public static boolean isCanCancelApply(ChequeInfo info) {
        if (ChequeStatusEnum.APPLIED.equals((Object)info.getState())) {
            return !ChequeHelper.isAlreadyGenBill(info);
        }
        return false;
    }

    public static boolean isCanWriteOff(ChequeInfo info) {
        boolean flag = false;
        if ((ChequeStatusEnum.WRITTEN_OFF.equals((Object)info.getState()) || ChequeStatusEnum.NEW.equals((Object)info.getState()) || ChequeStatusEnum.APPLIED.equals((Object)info.getState())) && info.getPaymentBillNum() == null && !info.isFiVouchered() && !info.isIsVC()) {
            flag = true;
        }
        return flag;
    }

    public static boolean isCanCancelWriteOff(ChequeInfo info) {
        boolean flag = false;
        if (ChequeStatusEnum.WRITTEN_OFF.equals((Object)info.getState()) && info.getPaymentBillNum() == null && !info.isFiVouchered() && !info.isIsVC()) {
            flag = true;
        }
        return flag;
    }

    public static boolean isCanAbandon(ChequeInfo info) {
        boolean flag = false;
        if (info.getPaymentBillNum() == null && !info.isFiVouchered() && !info.isIsVC()) {
            flag = true;
        }
        return flag;
    }

    public static boolean isCanCancelAbandon(ChequeInfo info) {
        return ChequeStatusEnum.Canceled.equals((Object)info.getState());
    }

    public static boolean isCanRecord(ChequeInfo info) {
        boolean flag = false;
        NTTypeInfo nt = info.getNtType();
        if (nt != null && nt.getGroup().equals((Object)NTTypeGroupEnum.CHEQUE) && ChequeStatusEnum.WRITTEN_OFF.equals((Object)info.getState()) && info.getCashier() == null && info.getPaymentBillNum() == null && !info.isIsVC()) {
            flag = true;
        }
        if (nt != null && nt.getGroup().equals((Object)NTTypeGroupEnum.TELE_ORDER) && ChequeStatusEnum.APPLIED.equals((Object)info.getState()) && info.getPaymentBillNum() == null && info.getCashier() == null && !info.isIsVC()) {
            flag = true;
        }
        return flag;
    }

    public static boolean isCanCancelRecord(ChequeInfo info) {
        boolean flag = false;
        NTTypeInfo nt = info.getNtType();
        if (nt != null && nt.getGroup().equals((Object)NTTypeGroupEnum.CHEQUE) && ChequeStatusEnum.WRITTEN_OFF.equals((Object)info.getState()) && info.getCashier() != null && info.getPaymentBillNum() == null && info.isIsVC()) {
            flag = true;
        }
        if (nt != null && nt.getGroup().equals((Object)NTTypeGroupEnum.TELE_ORDER) && ChequeStatusEnum.APPLIED.equals((Object)info.getState()) && info.getCashier() != null && info.getPaymentBillNum() == null) {
            flag = true;
        }
        return flag;
    }

    public static boolean isCanVoucher(ChequeInfo info) {
        boolean flag = false;
        NTTypeInfo nt = info.getNtType();
        if (nt != null && nt.getGroup().equals((Object)NTTypeGroupEnum.CHEQUE) && ChequeStatusEnum.WRITTEN_OFF.equals((Object)info.getState()) && info.getPaymentBillNum() == null && info.getCashier() == null && !info.isIsVC()) {
            flag = true;
        }
        if (nt != null && nt.getGroup().equals((Object)NTTypeGroupEnum.TELE_ORDER) && ChequeStatusEnum.APPLIED.equals((Object)info.getState()) && info.getPaymentBillNum() == null && info.getCashier() == null && !info.isIsVC()) {
            flag = true;
        }
        return flag;
    }

    public static boolean isCanCancelVoucher(ChequeInfo info) {
        return info.isIsVC();
    }

    public static boolean isCanCreateTo(ChequeInfo info) {
        boolean flag = false;
        NTTypeInfo nt = info.getNtType();
        if (nt != null && nt.getGroup().equals((Object)NTTypeGroupEnum.CHEQUE) && ChequeStatusEnum.WRITTEN_OFF.equals((Object)info.getState()) && info.getPaymentBillNum() == null && info.getCashier() == null && !info.isIsVC()) {
            flag = true;
        }
        if (nt != null && nt.getGroup().equals((Object)NTTypeGroupEnum.TELE_ORDER) && ChequeStatusEnum.APPLIED.equals((Object)info.getState()) && info.getPaymentBillNum() == null && info.getCashier() == null && !info.isIsVC()) {
            flag = true;
        }
        return flag;
    }

    public static boolean isCanVC(ChequeInfo info) {
        NTTypeInfo nt = info.getNtType();
        return nt != null && nt.getGroup().equals((Object)NTTypeGroupEnum.CHEQUE) && !info.isIsVC();
    }

    public static boolean isCanRemove(ChequeInfo info) {
        return !ChequeHelper.isAlreadyGenBill(info);
    }

    public static boolean isAlreadyGenBill(ChequeInfo info) {
        return info.isFiVouchered() || info.getJournal() != null;
    }
}

